/*
 * Decompiled with CFR 0.152.
 */
package ru.xordev.stopAndCheck;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import ru.xordev.stopAndCheck.Utils;
import ru.xordev.stopAndCheck.commands.CheckerCommand;
import ru.xordev.stopAndCheck.handlers.CheckerEventHandler;

public final class Main
extends JavaPlugin {
    public void onEnable() {
        try {
            this.saveDefaultConfig();
            PluginManager pm = this.getServer().getPluginManager();
            int currentConfigVersion = this.getConfig().getInt("config-version", -1);
            int latestConfigVersion = 2;
            if (currentConfigVersion < latestConfigVersion) {
                this.migrateConfig(currentConfigVersion, latestConfigVersion);
            }
            pm.addPermission(new Permission("sac.command", "Access to /sac command", PermissionDefault.OP));
            pm.addPermission(new Permission("sac.immunity", "Deny send player to checks", PermissionDefault.OP));
            pm.addPermission(new Permission("sac.help", "Access to /help command", PermissionDefault.OP));
            Permission moderPerm = new Permission("sac.moder.*", "Allow all moderator commands", PermissionDefault.OP);
            moderPerm.getChildren().put("sac.moder.reload", true);
            moderPerm.getChildren().put("sac.moder.check", true);
            moderPerm.getChildren().put("sac.moder.free", true);
            moderPerm.getChildren().put("sac.moder.info", true);
            pm.addPermission(moderPerm);
            pm.registerEvents((Listener)new CheckerEventHandler(this, new Utils(this)), (Plugin)this);
            Objects.requireNonNull(this.getServer().getPluginCommand("sac")).setExecutor((CommandExecutor)new CheckerCommand(this));
            this.getServer().getLogger().log(Level.INFO, " ");
            this.getServer().getLogger().log(Level.INFO, "-| StopAndCheck 1.2.2 by XOR |-");
            this.getServer().getLogger().log(Level.INFO, "All releases here: https://github.com/justyXOR/StopAndCheck");
            this.getServer().getLogger().log(Level.INFO, " ");
            this.getServer().getLogger().log(Level.INFO, "Plugin is ready to work!");
            this.getServer().getLogger().log(Level.INFO, " ");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error when enabling plugin!", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void migrateConfig(int fromVersion, int toVersion) {
        this.getLogger().warning(" ");
        this.getLogger().warning("\u26a0\ufe0f CONFIG MIGRATION REQUIRED!");
        this.getLogger().warning("Current config version: " + fromVersion);
        this.getLogger().warning("Latest config version: " + toVersion);
        this.getLogger().warning("Creating backup and generating new config...");
        try {
            File configFile = new File(this.getDataFolder(), "config.yml");
            File backupFile = new File(this.getDataFolder(), "config.yml.backup-v" + fromVersion);
            if (configFile.exists()) {
                Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().info("\u2713 Backup created: " + backupFile.getName());
            }
            if (configFile.delete()) {
                this.saveDefaultConfig();
                this.reloadConfig();
                this.getLogger().info("\u2713 New config generated successfully!");
            }
            this.getLogger().warning("\u26a0\ufe0f Please check new config.yml and adjust settings if needed!");
            this.getLogger().warning(" ");
        }
        catch (Exception e) {
            this.getLogger().severe("\u2717 Config migration failed!");
            this.getLogger().severe("Error: " + e.getMessage());
        }
    }

    public void onDisable() {
        this.getLogger().info("Cleaning up metadata...");
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.removeMetadataByPrefix(player);
            player.sendTitle("", "", 0, 0, 10);
        }
        this.getLogger().info("Cleaning up permissions...");
        this.unregisterPermissions();
        this.getLogger().info("See you next time!");
    }

    private void unregisterPermissions() {
        String[] permissionsToRemove;
        PluginManager pm = this.getServer().getPluginManager();
        for (String permName : permissionsToRemove = new String[]{"sac.command", "sac.immunity", "sac.help", "sac.moder.reload", "sac.moder.check", "sac.moder.free", "sac.moder.info", "sac.moder.*"}) {
            Permission perm = pm.getPermission(permName);
            if (perm == null) continue;
            pm.removePermission(perm);
        }
    }

    private void removeMetadataByPrefix(@NotNull Player player) {
        List metadata = player.getMetadata("sac_");
        for (MetadataValue meta : new ArrayList(player.getMetadata("sac_"))) {
            if (!Objects.equals(meta.getOwningPlugin(), (Object)this)) continue;
            player.removeMetadata("sac_", (Plugin)this);
        }
    }
}

