/*
 * Decompiled with CFR 0.152.
 */
package ru.xordev.stopAndCheck;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private final JavaPlugin plugin;

    public Utils(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public String color(String msg) {
        if (msg == null) {
            return null;
        }
        msg = this.processHexColors(msg);
        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        return msg;
    }

    public Location parse_location(@NotNull String coordinates, String world, String split_by) {
        String[] coordArray = coordinates.split(split_by);
        double x = Double.parseDouble(coordArray[0]);
        double y = Double.parseDouble(coordArray[1]);
        double z = Double.parseDouble(coordArray[2]);
        World to = Bukkit.getWorld((String)world);
        if (to == null) {
            throw new IllegalArgumentException("World " + world + " not found");
        }
        Location loc = new Location(to, x, y, z);
        if (coordArray.length >= 5) {
            float yaw = Float.parseFloat(coordArray[3].trim());
            float pitch = Float.parseFloat(coordArray[4].trim());
            loc.setYaw(yaw);
            loc.setPitch(pitch);
        }
        return loc;
    }

    private String processHexColors(String message) {
        try {
            Pattern pattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
            Matcher matcher = pattern.matcher(message);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String hex = matcher.group(1);
                ChatColor color = ChatColor.of((String)("#" + hex));
                matcher.appendReplacement(buffer, color.toString());
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            return message;
        }
    }

    public String get_str(String path, @Nullable Player moderator, @Nullable Player player) {
        String msg = this.plugin.getConfig().getString(path);
        msg = moderator != null ? msg.replace("{moderator}", moderator.getName()) : msg.replace("{moderator}", "&7CONSOLE&r");
        msg = player != null ? msg.replace("{player}", player.getName()) : msg.replace("{player}", "&7???&r");
        return this.color(msg);
    }

    public List<String> get_str_list(String path, @Nullable Player executor, @Nullable Player player) {
        List msgs = this.plugin.getConfig().getStringList(path);
        ArrayList<String> result = new ArrayList<String>();
        for (String msg : msgs) {
            msg = executor != null ? msg.replace("{executor}", executor.getName()) : msg.replace("{executor}", "&7CONSOLE&r");
            msg = player != null ? msg.replace("{player}", player.getName()) : msg.replace("{player}", "&7???&r");
            result.add(this.color(msg));
        }
        return result;
    }

    public void sendMessage(CommandSender sender, String message) {
        if (sender instanceof Player) {
            sender.sendMessage(this.color(message));
        } else if (sender instanceof ConsoleCommandSender) {
            this.plugin.getLogger().log(Level.INFO, message.replaceAll("\u00a7[0-9a-fk-or]", ""));
        }
    }

    public void sendMessage(CommandSender sender, String key, Player moderator, Player target) {
        String message = this.get_str(key, moderator, target);
        this.sendMessage(sender, this.color(message));
    }
}

