/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModrinthVersionChecker {
    private static final String API_URL = "https://api.modrinth.com/v2/project/JyJcJ7vv/version";
    private static final Logger LOGGER = Logger.getLogger(ModrinthVersionChecker.class.getName());

    public static void checkVersion() {
        try {
            String message;
            String jsonResponse = ModrinthVersionChecker.sendGetRequest();
            JSONArray versions = new JSONArray(jsonResponse);
            JSONObject newestVersion = versions.getJSONObject(0);
            for (int i = 1; i < versions.length(); ++i) {
                JSONObject version = versions.getJSONObject(i);
                if (version.getString("date_published").compareTo(newestVersion.getString("date_published")) <= 0) continue;
                newestVersion = version;
            }
            File configFile = new File(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("StatusPlugin")).getDataFolder(), "config.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            String currentVersion = config.getString("current_version");
            String newestVersionNumber = newestVersion.getString("version_number");
            String prefix = ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "StatusPlugin" + ChatColor.DARK_GRAY + "] " + ChatColor.RESET;
            if (newestVersionNumber.equals(currentVersion)) {
                message = prefix + ChatColor.WHITE + "You are using the latest version: " + currentVersion;
            } else if (ModrinthVersionChecker.isVersionHigher(newestVersionNumber, currentVersion)) {
                JSONArray filesArray = newestVersion.getJSONArray("files");
                String downloadLink = filesArray.getJSONObject(0).getString("url");
                message = prefix + ChatColor.RED + "A new version is available: " + newestVersionNumber + "\n" + ChatColor.WHITE + "Current version: " + currentVersion + "\n" + ChatColor.WHITE + "Download it here: " + ChatColor.UNDERLINE + downloadLink;
            } else {
                message = prefix + ChatColor.WHITE + "You are using a higher version: " + currentVersion;
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp() && !player.hasPermission("statusplugin.admin")) continue;
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to fetch version details", e);
        }
    }

    private static boolean isVersionHigher(String version1, String version2) {
        String[] v1 = version1.split("\\.");
        String[] v2 = version2.split("\\.");
        int length = Math.max(v1.length, v2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < v1.length ? Integer.parseInt(v1[i]) : 0;
            int n = num2 = i < v2.length ? Integer.parseInt(v2[i]) : 0;
            if (num1 > num2) {
                return true;
            }
            if (num1 >= num2) continue;
            return false;
        }
        return false;
    }

    private static String sendGetRequest() throws Exception {
        URL url = new URL(API_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            return content.toString();
        }
        throw new Exception("Failed to fetch version details. HTTP response code: " + responseCode);
    }
}

