/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin;

import de.stylelabor.bukkit.Metrics;
import de.stylelabor.statusplugin.CountryLocationManager;
import de.stylelabor.statusplugin.ModrinthVersionChecker;
import de.stylelabor.statusplugin.StatusPlaceholder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.tablist.HeaderFooterManager;
import me.neznamy.tab.api.tablist.TabListFormatManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public final class StatusPlugin
extends JavaPlugin
implements Listener,
TabCompleter {
    private final HashMap<UUID, String> playerStatusMap = new HashMap();
    private final HashMap<UUID, Integer> playerDeathMap = new HashMap();
    private String commandName;
    private String tabListFormat;
    private boolean customTabListEnabled;
    private List<String> tabListHeaderLines = Collections.emptyList();
    private List<String> tabListFooterLines = Collections.emptyList();
    private final HashMap<String, String> statusOptions = new HashMap();
    private FileConfiguration languageConfig;
    private FileConfiguration playerStatusConfig;
    private FileConfiguration playerDeathsConfig;
    private FileConfiguration serverStatsConfig;
    private boolean isTabPluginPresent;
    private boolean useOnlyOneLanguage;
    private String defaultLanguage;
    private boolean isDiscordSrvPresent;
    private CountryLocationManager countryLocationManager;
    private long totalBlocksPlaced;
    private long totalBlocksBroken;
    private long totalTrackedDeaths;
    private boolean serverStatsDirty;
    private int statsAutosaveCounterTicks;
    private BukkitTask fastTabRefreshTask;
    private BukkitTask slowTabRefreshTask;
    private int tabRefreshIntervalTicks;
    private int tabDimensionRefreshIntervalTicks;
    private int rotatingLineIntervalTicks;
    private int rotatingLineElapsedTicks;
    private int rotatingLineIndex;
    private List<String> tabListRotatingLines = Collections.emptyList();
    private int cachedOverworldPlayers;
    private int cachedNetherPlayers;
    private int cachedEndPlayers;
    private String cachedPerformanceLabel = ChatColor.GREEN + ChatColor.UNDERLINE + "Smooth" + ChatColor.RESET;
    private static final ThreadLocal<Boolean> relayingToDiscord = ThreadLocal.withInitial(() -> false);
    private static final DateTimeFormatter TABLIST_TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm", Locale.getDefault());
    private static final String PLACEHOLDER_NOT_AVAILABLE = "N/A";
    private static final int STATS_AUTOSAVE_INTERVAL_TICKS = 6000;
    private Scoreboard sortingScoreboard;
    private final HashMap<String, Team> statusTeams = new HashMap();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
        this.loadPlayerDeathsConfig();
        this.loadServerStatsConfig();
        this.loadPlayerStatuses();
        this.loadPlayerDeaths();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand(this.commandName)).setTabCompleter((TabCompleter)this);
        int pluginId = 20901;
        new Metrics(this, pluginId);
        this.isTabPluginPresent = Bukkit.getPluginManager().getPlugin("TAB") != null;
        boolean bl = this.isDiscordSrvPresent = Bukkit.getPluginManager().getPlugin("DiscordSRV") != null;
        if (this.isDiscordSrvPresent) {
            this.getLogger().info("[StatusPlugin] DiscordSRV detected. Enabling Discord relay features.");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new StatusPlaceholder(this).register();
            this.getLogger().info("PlaceholderAPI placeholder registered successfully.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholder registration skipped.");
        }
        ModrinthVersionChecker.checkVersion();
        if (this.getConfig().getBoolean("country-location-enabled", false)) {
            this.countryLocationManager = new CountryLocationManager(this);
            this.getLogger().info("Country location feature enabled. IP geolocation will be active.");
        } else {
            this.getLogger().info("Country location feature disabled. To enable, set country-location-enabled to true in config.yml");
        }
        this.refreshDimensionCache();
        this.startTabRefreshSchedulers();
        if (this.getConfig().getBoolean("tab-list-sort-by-status", true)) {
            Bukkit.getScheduler().runTask((Plugin)this, this::initializeSortingScoreboard);
        }
    }

    private void loadPlayerStatuses() {
        this.playerStatusMap.clear();
        for (String uuid : this.playerStatusConfig.getKeys(false)) {
            this.playerStatusMap.put(UUID.fromString(uuid), this.playerStatusConfig.getString(uuid));
        }
    }

    private void loadPlayerDeaths() {
        if (this.playerDeathsConfig == null) {
            return;
        }
        this.playerDeathMap.clear();
        long aggregatedDeaths = 0L;
        for (String uuid : this.playerDeathsConfig.getKeys(false)) {
            int deaths = this.playerDeathsConfig.getInt(uuid, 0);
            aggregatedDeaths += (long)deaths;
            this.playerDeathMap.put(UUID.fromString(uuid), deaths);
        }
        this.totalTrackedDeaths = aggregatedDeaths;
        if (this.serverStatsConfig != null) {
            this.serverStatsConfig.set("total-deaths", (Object)this.totalTrackedDeaths);
            this.serverStatsDirty = true;
        }
    }

    public void onDisable() {
        this.stopTabRefreshSchedulers();
        this.savePlayerStatusConfig();
        this.savePlayerDeathsConfig();
        this.persistServerStats(true);
        if (this.countryLocationManager != null) {
            this.countryLocationManager.saveAllPlayerCountries();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args2) {
        if (command.getName().equalsIgnoreCase(this.commandName) && sender instanceof Player) {
            Player player = (Player)sender;
            if (this.getConfig().getBoolean("only-admin-change", false) && !player.hasPermission("statusplugin.admin")) {
                String message = this.getConfig().getString("only-admin-change-message", "&cOnly admins can change statuses.");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                return true;
            }
            if (args2.length <= 0) {
                this.playerStatusMap.remove(player.getUniqueId());
                String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                this.assignPlayerToTeam(player);
                this.updatePlayerTabList();
                this.playerStatusConfig.set(player.getUniqueId().toString(), null);
                this.savePlayerStatusConfig();
                return true;
            }
            String statusKey = args2[0].toUpperCase(Locale.ROOT);
            String status = this.statusOptions.get(statusKey);
            if (status == null) {
                String message = this.getLanguageText(player, "invalid_status", "&cInvalid status option. Use /status <option>");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                return true;
            }
            if ("ADMIN".equals(statusKey) && !player.isOp() && !player.hasPermission("statusplugin.admin")) {
                player.sendMessage(ChatColor.RED + "Only admins can use the ADMIN status.");
                return true;
            }
            if ("MOD".equals(statusKey) && !player.hasPermission("statusplugin.mod")) {
                player.sendMessage(ChatColor.RED + "Only moderators can use the MOD status.");
                return true;
            }
            this.playerStatusMap.put(player.getUniqueId(), status);
            String message = this.getLanguageText(player, "status_set", "&aYour status has been set to: &r%s");
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, status)));
            this.assignPlayerToTeam(player);
            this.updatePlayerTabList();
            this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)status);
            this.savePlayerStatusConfig();
            return true;
        }
        if (command.getName().equalsIgnoreCase("reloadstatus") && (sender.isOp() || sender.hasPermission("statusplugin.reload"))) {
            this.reloadPlugin();
            sender.sendMessage(ChatColor.GREEN + "StatusPlugin configuration reloaded!");
            return true;
        }
        if (command.getName().equalsIgnoreCase("status-clear") && sender instanceof Player) {
            Player player = (Player)sender;
            this.playerStatusMap.remove(player.getUniqueId());
            String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            this.assignPlayerToTeam(player);
            this.updatePlayerTabList();
            this.playerStatusConfig.set(player.getUniqueId().toString(), null);
            this.savePlayerStatusConfig();
            return true;
        }
        if (!command.getName().equalsIgnoreCase("status-admin")) return false;
        if (!sender.hasPermission("statusplugin.admin")) return false;
        if (args2.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: /status-admin <player> <status> | /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount] | /status-admin reload");
            return true;
        }
        String subCommand = args2[0].toLowerCase(Locale.ROOT);
        if (subCommand.equals("reload")) {
            this.reloadPlugin();
            sender.sendMessage(ChatColor.GREEN + "StatusPlugin configuration reloaded!");
            return true;
        }
        if (subCommand.equals("deaths")) {
            Player refreshedOnlineTarget;
            Player targetProfile;
            if (args2.length < 2) {
                sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount]");
                return true;
            }
            Player onlineTarget = Bukkit.getPlayerExact((String)args2[1]);
            Object object = targetProfile = onlineTarget != null ? onlineTarget : Bukkit.getOfflinePlayer((String)args2[1]);
            if (targetProfile == null || !targetProfile.hasPlayedBefore() && !targetProfile.isOnline()) {
                sender.sendMessage(ChatColor.RED + "Player not found.");
                return true;
            }
            UUID targetUuid = targetProfile.getUniqueId();
            int currentDeaths = this.getPlayerDeaths(targetUuid);
            if (args2.length == 2) {
                String targetName = targetProfile.getName() != null ? targetProfile.getName() : args2[1];
                sender.sendMessage(ChatColor.YELLOW + targetName + ChatColor.GRAY + " has " + ChatColor.AQUA + currentDeaths + ChatColor.GRAY + " tracked deaths.");
                return true;
            }
            String action = args2[2].toLowerCase(Locale.ROOT);
            int newDeaths = currentDeaths;
            switch (action) {
                case "reset": {
                    newDeaths = 0;
                    break;
                }
                case "set": {
                    int amount;
                    if (args2.length < 4) {
                        sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> set <amount>");
                        return true;
                    }
                    try {
                        amount = Integer.parseInt(args2[3]);
                        if (amount < 0) {
                            sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                            return true;
                        }
                        newDeaths = amount;
                        break;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                        return true;
                    }
                }
                case "add": {
                    int amount;
                    if (args2.length < 4) {
                        sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> add <amount>");
                        return true;
                    }
                    try {
                        amount = Integer.parseInt(args2[3]);
                        if (amount < 0) {
                            sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                            return true;
                        }
                        newDeaths = currentDeaths + amount;
                        break;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                        return true;
                    }
                }
                case "remove": 
                case "minus": {
                    int amount;
                    if (args2.length < 4) {
                        sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> " + action + " <amount>");
                        return true;
                    }
                    try {
                        amount = Integer.parseInt(args2[3]);
                        if (amount < 0) {
                            sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                            return true;
                        }
                        newDeaths = Math.max(0, currentDeaths - amount);
                        break;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                        return true;
                    }
                }
                default: {
                    sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount]");
                    return true;
                }
            }
            this.playerDeathMap.put(targetUuid, newDeaths);
            if (this.playerDeathsConfig != null) {
                this.playerDeathsConfig.set(targetUuid.toString(), (Object)newDeaths);
                this.savePlayerDeathsConfig();
            }
            if ((refreshedOnlineTarget = Bukkit.getPlayer((UUID)targetUuid)) != null) {
                if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
                    this.updatePlayerTabListName(refreshedOnlineTarget, TabEnvironmentSnapshot.capture(this), "");
                }
                refreshedOnlineTarget.sendMessage(ChatColor.GOLD + "Your tracked deaths were updated to " + ChatColor.AQUA + newDeaths + ChatColor.GOLD + " by an administrator.");
            }
            String targetName = targetProfile.getName() != null ? targetProfile.getName() : args2[1];
            sender.sendMessage(ChatColor.GREEN + "Set " + targetName + "'s tracked deaths to " + newDeaths + ".");
            return true;
        }
        int targetIndex = 0;
        int statusIndex = 1;
        if (subCommand.equals("set")) {
            if (args2.length < 3) {
                sender.sendMessage(ChatColor.RED + "Usage: /status-admin set <player> <status>");
                return true;
            }
            targetIndex = 1;
            statusIndex = 2;
        } else if (args2.length < 2) {
            sender.sendMessage(ChatColor.RED + "Usage: /status-admin <player> <status>");
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)args2[targetIndex]);
        if (targetPlayer == null) {
            sender.sendMessage(ChatColor.RED + "Player not found.");
            return true;
        }
        String statusKey = args2[statusIndex].toUpperCase(Locale.ROOT);
        String status = this.statusOptions.get(statusKey);
        if (status == null) {
            sender.sendMessage(ChatColor.RED + "Invalid status option. Use /status-admin " + (subCommand.equals("set") ? "set <player> <status>" : "<player> <status>"));
            return true;
        }
        if ("ADMIN".equals(statusKey) && !targetPlayer.isOp() && !targetPlayer.hasPermission("statusplugin.admin")) {
            sender.sendMessage(ChatColor.RED + "ADMIN status can only be applied to admins or operators.");
            return true;
        }
        if ("MOD".equals(statusKey) && !targetPlayer.hasPermission("statusplugin.mod")) {
            sender.sendMessage(ChatColor.RED + "MOD status can only be applied to moderators.");
            return true;
        }
        this.playerStatusMap.put(targetPlayer.getUniqueId(), status);
        String message = this.getLanguageText(targetPlayer, "status_set", "&aYour status has been set to: &r%s");
        targetPlayer.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, status)));
        this.assignPlayerToTeam(targetPlayer);
        this.updatePlayerTabList();
        this.playerStatusConfig.set(targetPlayer.getUniqueId().toString(), (Object)status);
        this.savePlayerStatusConfig();
        sender.sendMessage(ChatColor.GREEN + "Status of " + targetPlayer.getName() + " has been set to: " + ChatColor.translateAlternateColorCodes((char)'&', (String)status));
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.getConfig().getBoolean("default_status_enabled", true)) {
            String defaultStatus = this.getConfig().getString("default_status", "DEFAULT");
            this.playerStatusMap.put(player.getUniqueId(), defaultStatus);
            this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)defaultStatus);
            this.savePlayerStatusConfig();
        }
        if (this.countryLocationManager != null && this.getConfig().getBoolean("country-location-enabled", true)) {
            ((CompletableFuture)this.countryLocationManager.getPlayerCountryAsync(player).thenAccept(countryData -> {
                if (countryData != null && this.getConfig().getBoolean("tab-styling-enabled", true)) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> this.updatePlayerTabList());
                }
            })).exceptionally(throwable -> {
                this.getLogger().warning("Failed to fetch country data for player " + player.getName() + ": " + throwable.getMessage());
                return null;
            });
        }
        if (player.hasPermission("statusplugin.admin") && this.getConfig().getBoolean("admin-join-message-enabled", false)) {
            String adminJoinMessage = "&aThank you for using this status plugin. When you want to support me, please download my plugin from Modrinth! https://modrinth.com/plugin/statusplugin-like-in-craftattack";
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)adminJoinMessage));
        }
        if (player.isOp() || player.hasPermission("statusplugin.admin")) {
            ModrinthVersionChecker.checkVersion();
        }
        if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
            this.assignPlayerToTeam(player);
            this.updatePlayerTabList();
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        int deaths = this.playerDeathMap.getOrDefault(uuid, 0) + 1;
        this.playerDeathMap.put(uuid, deaths);
        if (this.playerDeathsConfig != null) {
            this.playerDeathsConfig.set(uuid.toString(), (Object)deaths);
            this.savePlayerDeathsConfig();
        }
        ++this.totalTrackedDeaths;
        if (this.serverStatsConfig != null) {
            this.serverStatsConfig.set("total-deaths", (Object)this.totalTrackedDeaths);
            this.serverStatsDirty = true;
        }
        if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
            this.updatePlayerTabListName(player, TabEnvironmentSnapshot.capture(this), "");
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ++this.totalBlocksPlaced;
        if (this.serverStatsConfig != null) {
            this.serverStatsConfig.set("total-blocks-placed", (Object)this.totalBlocksPlaced);
            this.serverStatsDirty = true;
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ++this.totalBlocksBroken;
        if (this.serverStatsConfig != null) {
            this.serverStatsConfig.set("total-blocks-broken", (Object)this.totalBlocksBroken);
            this.serverStatsDirty = true;
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String chatFormat;
        boolean usingAdminStatus;
        if (Boolean.TRUE.equals(relayingToDiscord.get())) {
            return;
        }
        if (!this.getConfig().getBoolean("chat-styling-enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        String adminStatusFormat = this.statusOptions.get("ADMIN");
        boolean bl = usingAdminStatus = adminStatusFormat != null && adminStatusFormat.equals(status);
        if (status.isEmpty()) {
            chatFormat = this.getConfig().getString("chat-format-no-status", "<$$PLAYER$$> ");
        } else {
            chatFormat = this.getConfig().getString("chat-format", "%status% <$$PLAYER$$> ");
            chatFormat = chatFormat.replace("%status%", status);
        }
        if (this.getConfig().getBoolean("country-location-enabled", false) && this.countryLocationManager != null) {
            CountryLocationManager.CountryData countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
            if (countryData != null) {
                chatFormat = chatFormat.replace("%country%", countryData.getCountry());
                chatFormat = chatFormat.replace("%countrycode%", countryData.getCountryCode());
            } else {
                chatFormat = chatFormat.replace("%country%", "");
                chatFormat = chatFormat.replace("%countrycode%", "");
            }
        } else {
            chatFormat = chatFormat.replace("%country%", "");
            chatFormat = chatFormat.replace("%countrycode%", "");
        }
        chatFormat = chatFormat.replace("%deaths%", String.valueOf(this.getPlayerDeaths(player.getUniqueId())));
        String playerName = player.getName();
        if (usingAdminStatus) {
            playerName = ChatColor.RED + playerName + ChatColor.RESET;
        }
        chatFormat = chatFormat.replace("$$PLAYER$$", playerName);
        chatFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)chatFormat);
        BaseComponent[] statusComponent = TextComponent.fromLegacyText((String)chatFormat);
        String messageText = event.getMessage();
        if (usingAdminStatus) {
            messageText = ChatColor.RED + messageText + ChatColor.RESET;
        }
        BaseComponent[] messageComponent = TextComponent.fromLegacyText((String)messageText);
        BaseComponent[] finalComponents = new BaseComponent[statusComponent.length + messageComponent.length];
        System.arraycopy(statusComponent, 0, finalComponents, 0, statusComponent.length);
        System.arraycopy(messageComponent, 0, finalComponents, statusComponent.length, messageComponent.length);
        BaseComponent[] baseComponentArray = finalComponents;
        int n = finalComponents.length;
        int n2 = 0;
        while (n2 < n) {
            BaseComponent component = baseComponentArray[n2];
            String text = component.toPlainText();
            if (text.contains("http://") || text.contains("https://")) {
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, text));
            }
            ++n2;
        }
        for (Player recipient : Bukkit.getOnlinePlayers()) {
            recipient.spigot().sendMessage(finalComponents);
        }
        event.setCancelled(true);
        if (this.isDiscordSrvPresent && this.getConfig().getBoolean("discordsrv-relay-enabled", true) && !Boolean.TRUE.equals(relayingToDiscord.get())) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                try {
                    relayingToDiscord.set(true);
                    AsyncPlayerChatEvent forward = new AsyncPlayerChatEvent(false, player, event.getMessage(), new HashSet());
                    Bukkit.getPluginManager().callEvent((Event)forward);
                }
                finally {
                    relayingToDiscord.set(false);
                }
            });
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args2) {
        ArrayList<String> completions;
        block21: {
            block20: {
                completions = new ArrayList<String>();
                if (!command.getName().equalsIgnoreCase("status")) break block20;
                if (args2.length != 1) break block21;
                String prefix = args2[0].toUpperCase(Locale.ROOT);
                boolean canUseAdminStatus = true;
                boolean canUseModStatus = true;
                if (sender instanceof Player) {
                    Player playerSender = (Player)sender;
                    canUseAdminStatus = playerSender.isOp() || playerSender.hasPermission("statusplugin.admin");
                    canUseModStatus = playerSender.hasPermission("statusplugin.mod");
                }
                for (String option : this.statusOptions.keySet()) {
                    if (!option.startsWith(prefix) || "ADMIN".equals(option) && !canUseAdminStatus || "MOD".equals(option) && !canUseModStatus) continue;
                    completions.add(option);
                }
                break block21;
            }
            if (!command.getName().equalsIgnoreCase("status-admin")) break block21;
            if (args2.length == 1) {
                String prefix = args2[0].toLowerCase(Locale.ROOT);
                if ("reload".startsWith(prefix)) {
                    completions.add("reload");
                }
                if ("deaths".startsWith(prefix)) {
                    completions.add("deaths");
                }
                if ("set".startsWith(prefix)) {
                    completions.add("set");
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                    completions.add(player.getName());
                }
            } else if (args2.length == 2) {
                if (args2[0].equalsIgnoreCase("deaths") || args2[0].equalsIgnoreCase("set")) {
                    String prefix = args2[1].toLowerCase(Locale.ROOT);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                        completions.add(player.getName());
                    }
                } else {
                    String prefix = args2[1].toUpperCase(Locale.ROOT);
                    for (String option : this.statusOptions.keySet()) {
                        if (!option.startsWith(prefix)) continue;
                        completions.add(option);
                    }
                }
            } else if (args2.length == 3) {
                if (args2[0].equalsIgnoreCase("deaths")) {
                    String prefix = args2[2].toLowerCase(Locale.ROOT);
                    List<String> actions = Arrays.asList("add", "remove", "minus", "reset", "set");
                    for (String action : actions) {
                        if (!action.startsWith(prefix)) continue;
                        completions.add(action);
                    }
                } else if (args2[0].equalsIgnoreCase("set")) {
                    String prefix = args2[2].toUpperCase(Locale.ROOT);
                    for (String option : this.statusOptions.keySet()) {
                        if (!option.startsWith(prefix)) continue;
                        completions.add(option);
                    }
                }
            }
        }
        return completions;
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.commandName = config.getString("command-name", "status");
        config.getString("chat-format", "%status% &r<$$PLAYER$$> &e%countrycode% &c%deaths%");
        this.tabListFormat = config.getString("tab-list-format", "&a%status% &r$$PLAYER$$ &e%countrycode% &c%deaths%");
        this.defaultLanguage = config.getString("default-language", "english");
        this.useOnlyOneLanguage = config.getBoolean("use-only-one-language", true);
        this.customTabListEnabled = config.getBoolean("custom-tablist-enabled", false);
        this.tabRefreshIntervalTicks = Math.max(1, config.getInt("tab-refresh-interval-ticks", 20));
        this.tabDimensionRefreshIntervalTicks = Math.max(this.tabRefreshIntervalTicks, config.getInt("tab-dimension-refresh-interval-ticks", 200));
        this.loadStatusOptions();
        this.loadTabListConfig();
        boolean defaultStatusEnabled = config.getBoolean("default_status_enabled", true);
        String defaultStatus = config.getString("default_status", "DEFAULT");
        if (defaultStatusEnabled) {
            this.statusOptions.put("DEFAULT", defaultStatus);
        }
    }

    private void loadStatusOptions() {
        YamlConfiguration statusOptionsConfig;
        File statusOptionsFile = new File(this.getDataFolder(), "status-options.yml");
        if (!statusOptionsFile.exists()) {
            this.saveResource("status-options.yml", false);
        }
        if ((statusOptionsConfig = YamlConfiguration.loadConfiguration((File)statusOptionsFile)).isConfigurationSection("status")) {
            Set keys2 = Objects.requireNonNull(statusOptionsConfig.getConfigurationSection("status")).getKeys(false);
            for (String key : keys2) {
                this.statusOptions.put(key.toUpperCase(), statusOptionsConfig.getString("status." + key));
            }
        }
    }

    private void loadTabListConfig() {
        YamlConfiguration tabListConfig;
        List<String> headerLines;
        File tabListFile = new File(this.getDataFolder(), "tablist.yml");
        if (!tabListFile.exists()) {
            this.saveResource("tablist.yml", false);
        }
        if ((headerLines = (tabListConfig = YamlConfiguration.loadConfiguration((File)tabListFile)).getStringList("header")).isEmpty() && tabListConfig.isString("header")) {
            String headerLine = tabListConfig.getString("header");
            headerLines = Collections.singletonList(headerLine == null ? "" : headerLine);
        }
        this.tabListHeaderLines = headerLines.isEmpty() ? Collections.emptyList() : new ArrayList(headerLines);
        List<String> footerLines = tabListConfig.getStringList("footer");
        if (footerLines.isEmpty() && tabListConfig.isString("footer")) {
            String footerLine = tabListConfig.getString("footer");
            footerLines = Collections.singletonList(footerLine == null ? "" : footerLine);
        }
        this.tabListFooterLines = footerLines.isEmpty() ? Collections.emptyList() : new ArrayList(footerLines);
        List rotatingLines = Collections.emptyList();
        this.rotatingLineIntervalTicks = Math.max(this.tabRefreshIntervalTicks, 100);
        if (tabListConfig.isList("rotating-line")) {
            rotatingLines = tabListConfig.getStringList("rotating-line");
        } else {
            ConfigurationSection rotatingSection = tabListConfig.getConfigurationSection("rotating-line");
            if (rotatingSection != null) {
                rotatingLines = rotatingSection.getStringList("entries");
                this.rotatingLineIntervalTicks = Math.max(this.tabRefreshIntervalTicks, rotatingSection.getInt("interval-ticks", this.rotatingLineIntervalTicks));
            }
        }
        this.tabListRotatingLines = rotatingLines.isEmpty() ? Collections.emptyList() : new ArrayList<String>(rotatingLines);
        this.rotatingLineIndex = 0;
        this.rotatingLineElapsedTicks = 0;
    }

    private void loadLanguageConfig() {
        File languageFile;
        String languageFileName;
        String string = languageFileName = this.useOnlyOneLanguage ? "language.yml" : String.valueOf(this.defaultLanguage) + "_language.yml";
        if (this.useOnlyOneLanguage) {
            languageFile = new File(this.getDataFolder(), languageFileName);
            if (!languageFile.exists()) {
                this.saveResource(languageFileName, false);
            }
        } else {
            languageFile = new File(this.getDataFolder(), String.valueOf(this.defaultLanguage) + "_language.yml");
            if (!languageFile.exists()) {
                this.saveResource(String.valueOf(this.defaultLanguage) + "_language.yml", false);
            }
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    private void loadPlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        if (!playerStatusFile.exists()) {
            try {
                if (playerStatusFile.createNewFile()) {
                    this.getLogger().info("player-status.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadPlayerStatusConfig | IOException e");
            }
        }
        this.playerStatusConfig = YamlConfiguration.loadConfiguration((File)playerStatusFile);
    }

    private void loadPlayerDeathsConfig() {
        File playerDeathsFile = new File(this.getDataFolder(), "player-deaths.yml");
        if (!playerDeathsFile.exists()) {
            try {
                if (playerDeathsFile.createNewFile()) {
                    this.getLogger().info("player-deaths.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadPlayerDeathsConfig | IOException e");
            }
        }
        this.playerDeathsConfig = YamlConfiguration.loadConfiguration((File)playerDeathsFile);
    }

    private void loadServerStatsConfig() {
        File serverStatsFile = new File(this.getDataFolder(), "server-stats.yml");
        if (!serverStatsFile.exists()) {
            try {
                if (serverStatsFile.createNewFile()) {
                    this.getLogger().info("server-stats.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadServerStatsConfig | IOException e");
            }
        }
        this.serverStatsConfig = YamlConfiguration.loadConfiguration((File)serverStatsFile);
        this.totalBlocksPlaced = this.serverStatsConfig.getLong("total-blocks-placed", 0L);
        this.totalBlocksBroken = this.serverStatsConfig.getLong("total-blocks-broken", 0L);
        long storedTotalDeaths = this.serverStatsConfig.getLong("total-deaths", -1L);
        if (storedTotalDeaths >= 0L) {
            this.totalTrackedDeaths = storedTotalDeaths;
        }
        this.serverStatsDirty = false;
        this.statsAutosaveCounterTicks = 0;
    }

    private void savePlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        try {
            this.playerStatusConfig.save(playerStatusFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | savePlayerStatusConfig | IOException e");
        }
    }

    private void savePlayerDeathsConfig() {
        File playerDeathsFile = new File(this.getDataFolder(), "player-deaths.yml");
        try {
            this.playerDeathsConfig.save(playerDeathsFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | savePlayerDeathsConfig | IOException e");
        }
    }

    private void saveServerStatsConfig() {
        if (this.serverStatsConfig == null) {
            return;
        }
        File serverStatsFile = new File(this.getDataFolder(), "server-stats.yml");
        this.serverStatsConfig.set("total-blocks-placed", (Object)this.totalBlocksPlaced);
        this.serverStatsConfig.set("total-blocks-broken", (Object)this.totalBlocksBroken);
        this.serverStatsConfig.set("total-deaths", (Object)this.totalTrackedDeaths);
        try {
            this.serverStatsConfig.save(serverStatsFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | saveServerStatsConfig | IOException e");
        }
    }

    private void persistServerStats(boolean force) {
        if (this.serverStatsConfig == null) {
            return;
        }
        if (!this.serverStatsDirty && !force) {
            return;
        }
        if (!force) {
            this.statsAutosaveCounterTicks += this.tabRefreshIntervalTicks;
            if (this.statsAutosaveCounterTicks < 6000) {
                return;
            }
        }
        this.statsAutosaveCounterTicks = 0;
        this.serverStatsDirty = false;
        this.saveServerStatsConfig();
    }

    private String getLanguageText(Player player, String key, String defaultText) {
        if (this.useOnlyOneLanguage) {
            return this.languageConfig.getString(key, defaultText);
        }
        String playerLanguage = this.languageConfig.getString(player.getUniqueId() + ".language", this.defaultLanguage);
        File playerLanguageFile = new File(this.getDataFolder(), String.valueOf(playerLanguage) + "_language.yml");
        YamlConfiguration playerLanguageConfig = YamlConfiguration.loadConfiguration((File)playerLanguageFile);
        return playerLanguageConfig.getString(key, defaultText);
    }

    private void initializeSortingScoreboard() {
        try {
            if (Bukkit.getScoreboardManager() == null) {
                this.getLogger().warning("ScoreboardManager is not available yet. Tab list sorting will be disabled.");
                return;
            }
            this.sortingScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            this.statusTeams.clear();
            this.getLogger().info("Initialized tab list sorting scoreboard");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize scoreboard for tab list sorting: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Team getOrCreateStatusTeam(String statusKey) {
        if (this.sortingScoreboard == null) {
            return null;
        }
        String teamName = this.getTeamNameForStatus(statusKey);
        Team team = this.statusTeams.get(teamName);
        if (team != null) {
            return team;
        }
        team = this.sortingScoreboard.getTeam(teamName);
        if (team == null) {
            try {
                team = this.sortingScoreboard.registerNewTeam(teamName);
            }
            catch (IllegalArgumentException e) {
                team = this.sortingScoreboard.getTeam(teamName);
            }
        }
        if (team != null) {
            this.statusTeams.put(teamName, team);
        }
        return team;
    }

    private String getTeamNameForStatus(String statusKey) {
        String upperKey;
        if (statusKey == null || statusKey.isEmpty()) {
            return "2_nostatus";
        }
        switch (upperKey = statusKey.toUpperCase(Locale.ROOT)) {
            case "ADMIN": {
                return "0_admin";
            }
            case "MOD": {
                return "1_mod";
            }
            case "AFK": {
                return "9_afk";
            }
            case "CAM": {
                return "9_cam";
            }
        }
        return "2_" + statusKey.toLowerCase(Locale.ROOT);
    }

    private void assignPlayerToTeam(Player player) {
        if (this.sortingScoreboard == null || !this.getConfig().getBoolean("tab-list-sort-by-status", true)) {
            return;
        }
        try {
            Team team;
            String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
            String statusKey = this.getStatusKey(status);
            Team currentTeam = this.sortingScoreboard.getEntryTeam(player.getName());
            if (currentTeam != null) {
                currentTeam.removeEntry(player.getName());
            }
            if ((team = this.getOrCreateStatusTeam(statusKey)) != null) {
                team.addEntry(player.getName());
            }
            if (player.getScoreboard() != this.sortingScoreboard) {
                player.setScoreboard(this.sortingScoreboard);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to assign player " + player.getName() + " to team: " + e.getMessage());
        }
    }

    private void updateAllPlayerTeams() {
        if (this.sortingScoreboard == null || !this.getConfig().getBoolean("tab-list-sort-by-status", true)) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.assignPlayerToTeam(player);
        }
    }

    private void updatePlayerTabList() {
        this.updatePlayerTabList(TabEnvironmentSnapshot.capture(this));
    }

    private String getStatusKey(String statusValue) {
        if (statusValue == null || statusValue.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, String> entry : this.statusOptions.entrySet()) {
            if (!entry.getValue().equals(statusValue)) continue;
            return entry.getKey();
        }
        return "";
    }

    private void updatePlayerTabList(TabEnvironmentSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        boolean sortByStatus = this.getConfig().getBoolean("tab-list-sort-by-status", true);
        if (sortByStatus && this.sortingScoreboard != null) {
            this.updateAllPlayerTeams();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updatePlayerTabListName(player, snapshot, "");
        }
    }

    private void startTabRefreshSchedulers() {
        this.stopTabRefreshSchedulers();
        if (!this.getConfig().getBoolean("tab-styling-enabled", true)) {
            return;
        }
        this.statsAutosaveCounterTicks = 0;
        this.refreshDimensionCache();
        this.runFastTabRefreshTick();
        this.slowTabRefreshTask = new BukkitRunnable(){

            public void run() {
                StatusPlugin.this.refreshDimensionCache();
            }
        }.runTaskTimer((Plugin)this, (long)this.tabDimensionRefreshIntervalTicks, (long)this.tabDimensionRefreshIntervalTicks);
        this.fastTabRefreshTask = new BukkitRunnable(){

            public void run() {
                StatusPlugin.this.runFastTabRefreshTick();
            }
        }.runTaskTimer((Plugin)this, (long)this.tabRefreshIntervalTicks, (long)this.tabRefreshIntervalTicks);
    }

    private void stopTabRefreshSchedulers() {
        if (this.fastTabRefreshTask != null) {
            this.fastTabRefreshTask.cancel();
            this.fastTabRefreshTask = null;
        }
        if (this.slowTabRefreshTask != null) {
            this.slowTabRefreshTask.cancel();
            this.slowTabRefreshTask = null;
        }
    }

    private void refreshDimensionCache() {
        this.cachedOverworldPlayers = this.countPlayersInEnvironment(World.Environment.NORMAL);
        this.cachedNetherPlayers = this.countPlayersInEnvironment(World.Environment.NETHER);
        this.cachedEndPlayers = this.countPlayersInEnvironment(World.Environment.THE_END);
    }

    private void runFastTabRefreshTick() {
        if (!this.getConfig().getBoolean("tab-styling-enabled", true)) {
            return;
        }
        double[] tpsValues = this.fetchRecentTps();
        this.cachedPerformanceLabel = this.computePerformanceLabel(tpsValues);
        if (!this.tabListRotatingLines.isEmpty()) {
            this.rotatingLineElapsedTicks += this.tabRefreshIntervalTicks;
            if (this.rotatingLineElapsedTicks >= Math.max(this.rotatingLineIntervalTicks, this.tabRefreshIntervalTicks)) {
                this.rotatingLineElapsedTicks = 0;
                this.rotatingLineIndex = (this.rotatingLineIndex + 1) % this.tabListRotatingLines.size();
            }
        }
        TabEnvironmentSnapshot snapshot = TabEnvironmentSnapshot.capture(this, tpsValues);
        this.updatePlayerTabList(snapshot);
        this.persistServerStats(false);
    }

    private String computePerformanceLabel(double[] tpsValues) {
        double tps;
        double d = tps = tpsValues != null && tpsValues.length > 0 ? tpsValues[0] : -1.0;
        if (tps <= 0.0) {
            return ChatColor.DARK_RED + ChatColor.UNDERLINE + "UNKNOWN" + ChatColor.RESET;
        }
        if (tps >= 19.5) {
            return ChatColor.GREEN + ChatColor.UNDERLINE + "SMOOTH" + ChatColor.RESET;
        }
        if (tps >= 18.0) {
            return ChatColor.YELLOW + ChatColor.UNDERLINE + "STABLE" + ChatColor.RESET;
        }
        if (tps >= 15.0) {
            return ChatColor.GOLD + ChatColor.UNDERLINE + "STRUGGLING" + ChatColor.RESET;
        }
        return ChatColor.RED + ChatColor.UNDERLINE + "CRITICAL" + ChatColor.RESET;
    }

    public String getPlayerStatus(UUID uuid) {
        return this.playerStatusMap.getOrDefault(uuid, "");
    }

    public CountryLocationManager getCountryLocationManager() {
        return this.countryLocationManager;
    }

    public int getPlayerDeaths(UUID uuid) {
        return this.playerDeathMap.getOrDefault(uuid, 0);
    }

    public String getPerformanceLabel() {
        if (this.fastTabRefreshTask == null) {
            this.cachedPerformanceLabel = this.computePerformanceLabel(this.fetchRecentTps());
        }
        return this.cachedPerformanceLabel;
    }

    public long getTotalBlocksPlaced() {
        return this.totalBlocksPlaced;
    }

    public String getFormattedTotalBlocksPlaced() {
        return this.formatLargeNumber(this.totalBlocksPlaced);
    }

    public long getTotalBlocksBroken() {
        return this.totalBlocksBroken;
    }

    public String getFormattedTotalBlocksBroken() {
        return this.formatLargeNumber(this.totalBlocksBroken);
    }

    public long getTotalTrackedDeaths() {
        return this.totalTrackedDeaths;
    }

    public String getFormattedTotalTrackedDeaths() {
        return this.formatLargeNumber(this.totalTrackedDeaths);
    }

    private void updatePlayerTabListName(Player player, TabEnvironmentSnapshot snapshot, String invisibleSortPrefix) {
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        String playerName = player.getName();
        String adminStatusFormat = this.statusOptions.get("ADMIN");
        boolean usingAdminStatus = adminStatusFormat != null && adminStatusFormat.equals(status);
        String coloredPlayerName = usingAdminStatus ? ChatColor.RED + playerName + ChatColor.RESET : playerName;
        CountryLocationManager.CountryData countryData = null;
        if (snapshot.countryPlaceholdersEnabled) {
            countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
        }
        if (snapshot.tabStylingEnabled) {
            String template = status.isEmpty() ? this.getConfig().getString("tab-list-format-no-status", "&7[&e%countrycode%&7] &r$$PLAYER$$") : this.tabListFormat;
            String tabListName = this.formatTabListText(template, player, status, coloredPlayerName, countryData, snapshot);
            tabListName = ChatColor.translateAlternateColorCodes((char)'&', (String)tabListName);
            tabListName = String.valueOf(invisibleSortPrefix) + tabListName;
            if (this.isTabPluginPresent) {
                TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
                TabListFormatManager formatManager = TabAPI.getInstance().getTabListFormatManager();
                if (tabPlayer != null && formatManager != null) {
                    formatManager.setPrefix(tabPlayer, null);
                    formatManager.setName(tabPlayer, tabListName);
                    formatManager.setSuffix(tabPlayer, null);
                }
            } else {
                player.setPlayerListName(tabListName);
            }
        } else {
            this.resetTabListName(player);
        }
        this.applyTabListHeaderFooter(player, snapshot, status, coloredPlayerName, countryData);
    }

    private void resetTabListName(Player player) {
        if (this.isTabPluginPresent) {
            TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
            TabListFormatManager formatManager = TabAPI.getInstance().getTabListFormatManager();
            if (tabPlayer != null && formatManager != null) {
                formatManager.setPrefix(tabPlayer, null);
                formatManager.setName(tabPlayer, player.getName());
                formatManager.setSuffix(tabPlayer, null);
            }
        } else {
            player.setPlayerListName(player.getName());
        }
    }

    private void applyTabListHeaderFooter(Player player, TabEnvironmentSnapshot snapshot, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData) {
        String header = "";
        String footer = "";
        if (this.customTabListEnabled) {
            header = this.formatTabListSection(this.tabListHeaderLines, player, status, coloredPlayerName, countryData, snapshot);
            footer = this.formatTabListSection(this.tabListFooterLines, player, status, coloredPlayerName, countryData, snapshot);
        }
        header = ChatColor.translateAlternateColorCodes((char)'&', (String)header);
        footer = ChatColor.translateAlternateColorCodes((char)'&', (String)footer);
        if (this.isTabPluginPresent) {
            TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
            HeaderFooterManager headerFooterManager = TabAPI.getInstance().getHeaderFooterManager();
            if (tabPlayer != null && headerFooterManager != null) {
                headerFooterManager.setHeaderAndFooter(tabPlayer, header, footer);
            }
        } else {
            player.setPlayerListHeaderFooter(header, footer);
        }
    }

    private String formatTabListSection(List<String> lines, Player player, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData, TabEnvironmentSnapshot snapshot) {
        if (lines == null || lines.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            String processed = this.formatTabListText(line == null ? "" : line, player, status, coloredPlayerName, countryData, snapshot);
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(processed);
        }
        return builder.toString();
    }

    private String formatTabListText(String template, Player player, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData, TabEnvironmentSnapshot snapshot) {
        return this.applyTabListPlaceholders(template, player, status, coloredPlayerName, countryData, snapshot, true);
    }

    private String applyTabListPlaceholders(String template, Player player, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData, TabEnvironmentSnapshot snapshot, boolean includeRotatingToken) {
        if (template == null) {
            return "";
        }
        String result = template.replace("$$PLAYER$$", coloredPlayerName).replace("%status%", status).replace("%deaths%", String.valueOf(this.getPlayerDeaths(player.getUniqueId()))).replace("%online_players%", String.valueOf(snapshot.onlinePlayers)).replace("%max_players%", String.valueOf(snapshot.maxPlayers)).replace("%overworld_players%", String.valueOf(snapshot.overworldPlayers)).replace("%nether_players%", String.valueOf(snapshot.netherPlayers)).replace("%end_players%", String.valueOf(snapshot.endPlayers)).replace("%server_time%", snapshot.serverTime).replace("%time%", snapshot.serverTime).replace("%tps%", snapshot.tps1m).replace("%tps_1m%", snapshot.tps1m).replace("%tps_5m%", snapshot.tps5m).replace("%tps_15m%", snapshot.tps15m).replace("%performance%", snapshot.performanceLabel).replace("%performance_label%", snapshot.performanceLabel).replace("%total_blocks%", snapshot.totalBlocksShort).replace("%total_blocks_raw%", String.valueOf(snapshot.totalBlocksRaw)).replace("%total_blocks_broken%", snapshot.totalBlocksBrokenShort).replace("%total_blocks_broken_raw%", String.valueOf(snapshot.totalBlocksBrokenRaw)).replace("%total_deaths%", snapshot.totalDeathsShort).replace("%total_deaths_raw%", String.valueOf(snapshot.totalDeathsRaw));
        result = this.replaceCountryPlaceholders(result, countryData);
        if (includeRotatingToken && result.contains("%rotating_line%")) {
            String rotatingLine = "";
            if (!this.tabListRotatingLines.isEmpty()) {
                String rotatingTemplate = this.tabListRotatingLines.get(this.rotatingLineIndex % this.tabListRotatingLines.size());
                rotatingLine = this.applyTabListPlaceholders(rotatingTemplate, player, status, coloredPlayerName, countryData, snapshot, false);
            }
            result = result.replace("%rotating_line%", rotatingLine);
        } else if (!includeRotatingToken) {
            result = result.replace("%rotating_line%", "");
        }
        return result;
    }

    private int countPlayersInEnvironment(World.Environment environment) {
        int total = 0;
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != environment) continue;
            total += world.getPlayers().size();
        }
        return total;
    }

    private double[] fetchRecentTps() {
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]);
            Object dedicatedServer = method.invoke((Object)Bukkit.getServer(), new Object[0]);
            Field recentTpsField = dedicatedServer.getClass().getField("recentTps");
            recentTpsField.setAccessible(true);
            double[] values2 = (double[])recentTpsField.get(dedicatedServer);
            return values2 != null ? (double[])values2.clone() : null;
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            return null;
        }
    }

    private String getCurrentServerTime() {
        return LocalTime.now().format(TABLIST_TIME_FORMAT);
    }

    private static String formatTpsValue(double[] values2, int index) {
        if (values2 != null && index >= 0 && index < values2.length) {
            double value = Math.min(values2[index], 20.0);
            return String.format(Locale.US, "%.2f", value);
        }
        return PLACEHOLDER_NOT_AVAILABLE;
    }

    private String formatLargeNumber(long value) {
        long absValue = Math.abs(value);
        if (absValue >= 1000000000L) {
            return this.formatWithSuffix(value, 1000000000L, "b");
        }
        if (absValue >= 1000000L) {
            return this.formatWithSuffix(value, 1000000L, "m");
        }
        if (absValue >= 1000L) {
            return this.formatWithSuffix(value, 1000L, "k");
        }
        return String.valueOf(value);
    }

    private String formatWithSuffix(long value, long divisor, String suffix) {
        String formatted;
        double scaled = (double)value / (double)divisor;
        String string = formatted = Math.abs(scaled) >= 100.0 ? String.format(Locale.US, "%.0f", scaled) : String.format(Locale.US, "%.1f", scaled);
        if (formatted.endsWith(".0")) {
            formatted = formatted.substring(0, formatted.length() - 2);
        }
        return String.valueOf(formatted) + suffix;
    }

    private String replaceCountryPlaceholders(String text, CountryLocationManager.CountryData countryData) {
        if (text == null) {
            return "";
        }
        if (countryData != null) {
            text = text.replace("%country%", countryData.getCountry());
            text = text.replace("%countrycode%", countryData.getCountryCode());
        } else {
            text = text.replace("%country%", "");
            text = text.replace("%countrycode%", "");
        }
        return text;
    }

    private void reloadPlugin() {
        this.persistServerStats(true);
        this.stopTabRefreshSchedulers();
        this.reloadConfig();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
        this.loadPlayerDeathsConfig();
        this.loadServerStatsConfig();
        this.loadPlayerStatuses();
        this.loadPlayerDeaths();
        this.refreshDimensionCache();
        this.startTabRefreshSchedulers();
        if (this.getConfig().getBoolean("tab-list-sort-by-status", true)) {
            this.statusTeams.clear();
            if (this.sortingScoreboard == null) {
                this.initializeSortingScoreboard();
            }
            this.updateAllPlayerTeams();
        }
        this.updatePlayerTabList();
    }

    private static final class TabEnvironmentSnapshot {
        private final boolean tabStylingEnabled;
        private final boolean countryPlaceholdersEnabled;
        private final String serverTime;
        private final int overworldPlayers;
        private final int netherPlayers;
        private final int endPlayers;
        private final int onlinePlayers;
        private final int maxPlayers;
        private final String tps1m;
        private final String tps5m;
        private final String tps15m;
        private final String performanceLabel;
        private final long totalBlocksRaw;
        private final String totalBlocksShort;
        private final long totalBlocksBrokenRaw;
        private final String totalBlocksBrokenShort;
        private final long totalDeathsRaw;
        private final String totalDeathsShort;

        private TabEnvironmentSnapshot(boolean tabStylingEnabled, boolean countryPlaceholdersEnabled, String serverTime, int overworldPlayers, int netherPlayers, int endPlayers, int onlinePlayers, int maxPlayers, String tps1m, String tps5m, String tps15m, String performanceLabel, long totalBlocksRaw, String totalBlocksShort, long totalBlocksBrokenRaw, String totalBlocksBrokenShort, long totalDeathsRaw, String totalDeathsShort) {
            this.tabStylingEnabled = tabStylingEnabled;
            this.countryPlaceholdersEnabled = countryPlaceholdersEnabled;
            this.serverTime = serverTime;
            this.overworldPlayers = overworldPlayers;
            this.netherPlayers = netherPlayers;
            this.endPlayers = endPlayers;
            this.onlinePlayers = onlinePlayers;
            this.maxPlayers = maxPlayers;
            this.tps1m = tps1m;
            this.tps5m = tps5m;
            this.tps15m = tps15m;
            this.performanceLabel = performanceLabel;
            this.totalBlocksRaw = totalBlocksRaw;
            this.totalBlocksShort = totalBlocksShort;
            this.totalBlocksBrokenRaw = totalBlocksBrokenRaw;
            this.totalBlocksBrokenShort = totalBlocksBrokenShort;
            this.totalDeathsRaw = totalDeathsRaw;
            this.totalDeathsShort = totalDeathsShort;
        }

        private static TabEnvironmentSnapshot capture(StatusPlugin plugin) {
            return TabEnvironmentSnapshot.capture(plugin, null);
        }

        private static TabEnvironmentSnapshot capture(StatusPlugin plugin, double[] tpsValues) {
            boolean tabStylingEnabled = plugin.getConfig().getBoolean("tab-styling-enabled", true);
            boolean countryEnabled = plugin.getConfig().getBoolean("country-location-enabled", false) && plugin.countryLocationManager != null;
            double[] resolvedTps = tpsValues != null ? tpsValues : plugin.fetchRecentTps();
            return new TabEnvironmentSnapshot(tabStylingEnabled, countryEnabled, plugin.getCurrentServerTime(), plugin.cachedOverworldPlayers, plugin.cachedNetherPlayers, plugin.cachedEndPlayers, Bukkit.getOnlinePlayers().size(), Bukkit.getMaxPlayers(), StatusPlugin.formatTpsValue(resolvedTps, 0), StatusPlugin.formatTpsValue(resolvedTps, 1), StatusPlugin.formatTpsValue(resolvedTps, 2), plugin.cachedPerformanceLabel, plugin.totalBlocksPlaced, plugin.formatLargeNumber(plugin.totalBlocksPlaced), plugin.totalBlocksBroken, plugin.formatLargeNumber(plugin.totalBlocksBroken), plugin.totalTrackedDeaths, plugin.formatLargeNumber(plugin.totalTrackedDeaths));
        }
    }
}

