/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin;

import de.stylelabor.bukkit.Metrics;
import de.stylelabor.statusplugin.CountryLocationManager;
import de.stylelabor.statusplugin.ModrinthVersionChecker;
import de.stylelabor.statusplugin.StatusPlaceholder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.tablist.TabListFormatManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class StatusPlugin
extends JavaPlugin
implements Listener,
TabCompleter {
    private final HashMap<UUID, String> playerStatusMap = new HashMap();
    private String commandName;
    private String tabListFormat;
    private final HashMap<String, String> statusOptions = new HashMap();
    private FileConfiguration languageConfig;
    private FileConfiguration playerStatusConfig;
    private boolean isTabPluginPresent;
    private boolean useOnlyOneLanguage;
    private String defaultLanguage;
    private boolean isDiscordSrvPresent;
    private CountryLocationManager countryLocationManager;
    private static final ThreadLocal<Boolean> relayingToDiscord = ThreadLocal.withInitial(() -> false);

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
        this.loadPlayerStatuses();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand(this.commandName)).setTabCompleter((TabCompleter)this);
        int pluginId = 20901;
        new Metrics(this, pluginId);
        this.isTabPluginPresent = Bukkit.getPluginManager().getPlugin("TAB") != null;
        boolean bl = this.isDiscordSrvPresent = Bukkit.getPluginManager().getPlugin("DiscordSRV") != null;
        if (this.isDiscordSrvPresent) {
            this.getLogger().info("[StatusPlugin] DiscordSRV detected. Enabling Discord relay features.");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new StatusPlaceholder(this).register();
            this.getLogger().info("PlaceholderAPI placeholder registered successfully.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholder registration skipped.");
        }
        ModrinthVersionChecker.checkVersion();
        if (this.getConfig().getBoolean("country-location-enabled", false)) {
            this.countryLocationManager = new CountryLocationManager(this);
            this.getLogger().info("Country location feature enabled. IP geolocation will be active.");
        } else {
            this.getLogger().info("Country location feature disabled. To enable, set country-location-enabled to true in config.yml");
        }
    }

    private void loadPlayerStatuses() {
        for (String uuid : this.playerStatusConfig.getKeys(false)) {
            this.playerStatusMap.put(UUID.fromString(uuid), this.playerStatusConfig.getString(uuid));
        }
    }

    public void onDisable() {
        this.savePlayerStatusConfig();
        if (this.countryLocationManager != null) {
            this.countryLocationManager.saveAllPlayerCountries();
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args2) {
        if (command.getName().equalsIgnoreCase(this.commandName) && sender instanceof Player) {
            Player player = (Player)sender;
            if (this.getConfig().getBoolean("only-admin-change", false) && !player.hasPermission("statusplugin.admin")) {
                String message = this.getConfig().getString("only-admin-change-message", "&cOnly admins can change statuses.");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                return true;
            }
            if (args2.length > 0) {
                String status = this.statusOptions.get(args2[0].toUpperCase());
                if (status != null) {
                    this.playerStatusMap.put(player.getUniqueId(), status);
                    String message = this.getLanguageText(player, "status_set", "&aYour status has been set to: &r%s");
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, status)));
                    this.updatePlayerTabList();
                    this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)status);
                    this.savePlayerStatusConfig();
                } else {
                    String message = this.getLanguageText(player, "invalid_status", "&cInvalid status option. Use /status <option>");
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                }
            } else {
                this.playerStatusMap.remove(player.getUniqueId());
                String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                this.updatePlayerTabList();
                this.playerStatusConfig.set(player.getUniqueId().toString(), null);
                this.savePlayerStatusConfig();
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("reloadstatus") && (sender.isOp() || sender.hasPermission("statusplugin.reload"))) {
            this.reloadPlugin();
            sender.sendMessage(ChatColor.GREEN + "StatusPlugin configuration reloaded!");
            return true;
        }
        if (command.getName().equalsIgnoreCase("status-clear") && sender instanceof Player) {
            Player player = (Player)sender;
            this.playerStatusMap.remove(player.getUniqueId());
            String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            this.updatePlayerTabList();
            this.playerStatusConfig.set(player.getUniqueId().toString(), null);
            this.savePlayerStatusConfig();
            return true;
        }
        if (command.getName().equalsIgnoreCase("status-admin") && sender.hasPermission("statusplugin.admin")) {
            if (args2.length == 2) {
                Player targetPlayer = Bukkit.getPlayer((String)args2[0]);
                if (targetPlayer != null) {
                    String status = this.statusOptions.get(args2[1].toUpperCase());
                    if (status != null) {
                        this.playerStatusMap.put(targetPlayer.getUniqueId(), status);
                        String message = this.getLanguageText(targetPlayer, "status_set", "&aYour status has been set to: &r%s");
                        targetPlayer.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, status)));
                        this.updatePlayerTabList();
                        this.playerStatusConfig.set(targetPlayer.getUniqueId().toString(), (Object)status);
                        this.savePlayerStatusConfig();
                        sender.sendMessage(ChatColor.GREEN + "Status of " + targetPlayer.getName() + " has been set to: " + ChatColor.translateAlternateColorCodes((char)'&', (String)status));
                    } else {
                        sender.sendMessage(ChatColor.RED + "Invalid status option. Use /status-admin <playerName> <status>");
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "Player not found.");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Usage: /status-admin <playerName> <status>");
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.getConfig().getBoolean("default_status_enabled", true)) {
            String defaultStatus = this.getConfig().getString("default_status", "DEFAULT");
            this.playerStatusMap.put(player.getUniqueId(), defaultStatus);
            this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)defaultStatus);
            this.savePlayerStatusConfig();
        }
        if (this.countryLocationManager != null && this.getConfig().getBoolean("country-location-enabled", true)) {
            ((CompletableFuture)this.countryLocationManager.getPlayerCountryAsync(player).thenAccept(countryData -> {
                if (countryData != null && this.getConfig().getBoolean("tab-styling-enabled", true)) {
                    Bukkit.getScheduler().runTask((Plugin)this, this::updatePlayerTabList);
                }
            })).exceptionally(throwable -> {
                this.getLogger().warning("Failed to fetch country data for player " + player.getName() + ": " + throwable.getMessage());
                return null;
            });
        }
        if (player.hasPermission("statusplugin.admin") && this.getConfig().getBoolean("admin-join-message-enabled", false)) {
            String adminJoinMessage = "&aThank you for using this status plugin. When you want to support me, please download my plugin from Modrinth! https://modrinth.com/plugin/statusplugin-like-in-craftattack";
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)adminJoinMessage));
        }
        if (player.isOp() || player.hasPermission("statusplugin.admin")) {
            ModrinthVersionChecker.checkVersion();
        }
        if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
            this.updatePlayerTabList();
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String chatFormat;
        if (Boolean.TRUE.equals(relayingToDiscord.get())) {
            return;
        }
        if (!this.getConfig().getBoolean("chat-styling-enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        if (status.isEmpty()) {
            chatFormat = this.getConfig().getString("chat-format-no-status", "<$$PLAYER$$> ");
        } else {
            chatFormat = this.getConfig().getString("chat-format", "%status% <$$PLAYER$$> ");
            chatFormat = chatFormat.replace("%status%", status);
        }
        if (this.getConfig().getBoolean("country-location-enabled", false) && this.countryLocationManager != null) {
            CountryLocationManager.CountryData countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
            if (countryData != null) {
                chatFormat = chatFormat.replace("%country%", countryData.getCountry());
                chatFormat = chatFormat.replace("%countrycode%", countryData.getCountryCode());
            } else {
                chatFormat = chatFormat.replace("%country%", "");
                chatFormat = chatFormat.replace("%countrycode%", "");
            }
        } else {
            chatFormat = chatFormat.replace("%country%", "");
            chatFormat = chatFormat.replace("%countrycode%", "");
        }
        chatFormat = chatFormat.replace("$$PLAYER$$", player.getName());
        chatFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)chatFormat);
        BaseComponent[] statusComponent = TextComponent.fromLegacyText((String)chatFormat);
        BaseComponent[] messageComponent = TextComponent.fromLegacyText((String)event.getMessage());
        BaseComponent[] finalComponents = new BaseComponent[statusComponent.length + messageComponent.length];
        System.arraycopy(statusComponent, 0, finalComponents, 0, statusComponent.length);
        System.arraycopy(messageComponent, 0, finalComponents, statusComponent.length, messageComponent.length);
        for (BaseComponent component : finalComponents) {
            String text = component.toPlainText();
            if (!text.contains("http://") && !text.contains("https://")) continue;
            component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, text));
        }
        for (Player recipient : Bukkit.getOnlinePlayers()) {
            recipient.spigot().sendMessage(finalComponents);
        }
        event.setCancelled(true);
        if (this.isDiscordSrvPresent && this.getConfig().getBoolean("discordsrv-relay-enabled", true) && !Boolean.TRUE.equals(relayingToDiscord.get())) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                try {
                    relayingToDiscord.set(true);
                    AsyncPlayerChatEvent forward = new AsyncPlayerChatEvent(false, player, event.getMessage(), new HashSet());
                    Bukkit.getPluginManager().callEvent((Event)forward);
                }
                finally {
                    relayingToDiscord.set(false);
                }
            });
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args2) {
        ArrayList<String> completions;
        block8: {
            block7: {
                completions = new ArrayList<String>();
                if (!command.getName().equalsIgnoreCase("status")) break block7;
                if (args2.length != 1) break block8;
                String prefix = args2[0].toUpperCase();
                for (String option : this.statusOptions.keySet()) {
                    if (!option.startsWith(prefix)) continue;
                    completions.add(option);
                }
                break block8;
            }
            if (command.getName().equalsIgnoreCase("status-admin")) {
                if (args2.length == 1) {
                    String prefix = args2[0].toLowerCase();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(prefix)) continue;
                        completions.add(player.getName());
                    }
                } else if (args2.length == 2) {
                    String prefix = args2[1].toUpperCase();
                    for (String option : this.statusOptions.keySet()) {
                        if (!option.startsWith(prefix)) continue;
                        completions.add(option);
                    }
                }
            }
        }
        return completions;
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.commandName = config.getString("command-name", "status");
        config.getString("chat-format", "&7[&a%status%&7] &r%s");
        this.tabListFormat = config.getString("tab-list-format", "&7[&a%status%&7] &r%s");
        this.defaultLanguage = config.getString("default-language", "english");
        this.useOnlyOneLanguage = config.getBoolean("use-only-one-language", true);
        this.loadStatusOptions();
        boolean defaultStatusEnabled = config.getBoolean("default_status_enabled", true);
        String defaultStatus = config.getString("default_status", "DEFAULT");
        if (defaultStatusEnabled) {
            this.statusOptions.put("DEFAULT", defaultStatus);
        }
    }

    private void loadStatusOptions() {
        YamlConfiguration statusOptionsConfig;
        File statusOptionsFile = new File(this.getDataFolder(), "status-options.yml");
        if (!statusOptionsFile.exists()) {
            this.saveResource("status-options.yml", false);
        }
        if ((statusOptionsConfig = YamlConfiguration.loadConfiguration((File)statusOptionsFile)).isConfigurationSection("status")) {
            Set keys2 = Objects.requireNonNull(statusOptionsConfig.getConfigurationSection("status")).getKeys(false);
            for (String key : keys2) {
                this.statusOptions.put(key.toUpperCase(), statusOptionsConfig.getString("status." + key));
            }
        }
    }

    private void loadLanguageConfig() {
        File languageFile;
        String languageFileName;
        String string = languageFileName = this.useOnlyOneLanguage ? "language.yml" : this.defaultLanguage + "_language.yml";
        if (this.useOnlyOneLanguage) {
            languageFile = new File(this.getDataFolder(), languageFileName);
            if (!languageFile.exists()) {
                this.saveResource(languageFileName, false);
            }
        } else {
            languageFile = new File(this.getDataFolder(), this.defaultLanguage + "_language.yml");
            if (!languageFile.exists()) {
                this.saveResource(this.defaultLanguage + "_language.yml", false);
            }
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    private void loadPlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        if (!playerStatusFile.exists()) {
            try {
                if (playerStatusFile.createNewFile()) {
                    this.getLogger().info("player-status.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadPlayerStatusConfig | IOException e");
            }
        }
        this.playerStatusConfig = YamlConfiguration.loadConfiguration((File)playerStatusFile);
    }

    private void savePlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        try {
            this.playerStatusConfig.save(playerStatusFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | savePlayerStatusConfig | IOException e");
        }
    }

    private String getLanguageText(Player player, String key, String defaultText) {
        if (this.useOnlyOneLanguage) {
            return this.languageConfig.getString(key, defaultText);
        }
        String playerLanguage = this.languageConfig.getString(player.getUniqueId() + ".language", this.defaultLanguage);
        File playerLanguageFile = new File(this.getDataFolder(), playerLanguage + "_language.yml");
        YamlConfiguration playerLanguageConfig = YamlConfiguration.loadConfiguration((File)playerLanguageFile);
        return playerLanguageConfig.getString(key, defaultText);
    }

    private void updatePlayerTabList() {
        if (!this.getConfig().getBoolean("tab-styling-enabled", true)) {
            return;
        }
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        for (int i = 0; i < players.size(); ++i) {
            Player player = (Player)players.get(i);
            String invisiblePrefix = "\u00a7" + (char)(97 + i);
            player.setDisplayName(invisiblePrefix + player.getName());
            this.updatePlayerTabListName(player);
        }
    }

    public String getPlayerStatus(UUID uuid) {
        return this.playerStatusMap.getOrDefault(uuid, "");
    }

    public CountryLocationManager getCountryLocationManager() {
        return this.countryLocationManager;
    }

    private void updatePlayerTabListName(Player player) {
        String tabListName;
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        String playerName = player.getName();
        if (status.isEmpty()) {
            String noStatusFormat = this.getConfig().getString("tab-list-format-no-status", "&7[&e%countrycode%&7] &r$$PLAYER$$");
            tabListName = noStatusFormat.replace("$$PLAYER$$", playerName);
        } else {
            tabListName = this.tabListFormat.replace("%status%", status).replace("$$PLAYER$$", playerName);
        }
        if (this.getConfig().getBoolean("country-location-enabled", false) && this.countryLocationManager != null) {
            CountryLocationManager.CountryData countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
            if (countryData != null) {
                tabListName = tabListName.replace("%country%", countryData.getCountry());
                tabListName = tabListName.replace("%countrycode%", countryData.getCountryCode());
            } else {
                tabListName = tabListName.replace("%country%", "");
                tabListName = tabListName.replace("%countrycode%", "");
            }
        } else {
            tabListName = tabListName.replace("%country%", "");
            tabListName = tabListName.replace("%countrycode%", "");
        }
        tabListName = ChatColor.translateAlternateColorCodes((char)'&', (String)tabListName);
        if (this.isTabPluginPresent) {
            TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
            TabListFormatManager formatManager = TabAPI.getInstance().getTabListFormatManager();
            if (tabPlayer != null && formatManager != null) {
                formatManager.setPrefix(tabPlayer, null);
                formatManager.setName(tabPlayer, tabListName);
                formatManager.setSuffix(tabPlayer, null);
            }
        } else {
            player.setPlayerListName(tabListName);
        }
    }

    private void reloadPlugin() {
        this.reloadConfig();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
    }
}

