/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin;

import de.stylelabor.bukkit.Metrics;
import de.stylelabor.statusplugin.ColorParser;
import de.stylelabor.statusplugin.CountryLocationManager;
import de.stylelabor.statusplugin.ModrinthVersionChecker;
import de.stylelabor.statusplugin.StatusPlaceholder;
import de.stylelabor.statusplugin.nametag.StatusNametagManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.tablist.HeaderFooterManager;
import me.neznamy.tab.api.tablist.TabListFormatManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class StatusPlugin
extends JavaPlugin
implements Listener,
TabCompleter {
    private final HashMap<UUID, String> playerStatusMap = new HashMap();
    private final HashMap<UUID, Integer> playerDeathMap = new HashMap();
    private String commandName;
    private String tabListFormat;
    private boolean customTabListEnabled;
    private boolean nametagStatusEnabled;
    private boolean nametagCleanJoinMessage;
    private boolean nametagCleanDeathMessage;
    private StatusNametagManager nametagManager;
    private List<String> tabListHeaderLines = Collections.emptyList();
    private List<String> tabListFooterLines = Collections.emptyList();
    private final HashMap<String, String> statusOptions = new HashMap();
    private FileConfiguration languageConfig;
    private FileConfiguration playerStatusConfig;
    private FileConfiguration playerDeathsConfig;
    private FileConfiguration serverStatsConfig;
    private boolean isTabPluginPresent;
    private boolean useOnlyOneLanguage;
    private String defaultLanguage;
    private boolean isDiscordSrvPresent;
    private boolean isLibertyBansPresent;
    private LibertyBansIntegration libertyBansIntegration;
    private CountryLocationManager countryLocationManager;
    private long totalTrackedDeaths;
    private boolean serverStatsDirty;
    private int statsAutosaveCounterTicks;
    private BukkitTask fastTabRefreshTask;
    private BukkitTask slowTabRefreshTask;
    private int tabRefreshIntervalTicks;
    private int tabDimensionRefreshIntervalTicks;
    private int rotatingLineIntervalTicks;
    private int rotatingLineElapsedTicks;
    private int rotatingLineIndex;
    private List<String> tabListRotatingLines = Collections.emptyList();
    private int cachedOverworldPlayers;
    private int cachedNetherPlayers;
    private int cachedEndPlayers;
    private String cachedPerformanceLabel = ChatColor.GREEN + "" + ChatColor.UNDERLINE + "Smooth" + ChatColor.RESET;
    private String cachedMspt = "N/A";
    private static final ThreadLocal<Boolean> relayingToDiscord = ThreadLocal.withInitial(() -> false);
    private static final DateTimeFormatter TABLIST_TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm", Locale.getDefault());
    private static final String PLACEHOLDER_NOT_AVAILABLE = "N/A";
    private static final int STATS_AUTOSAVE_INTERVAL_TICKS = 6000;
    private static final long STATS_SAVE_DELAY_TICKS = 200L;
    private BukkitTask delayedStatsSaveTask;

    public void onEnable() {
        this.nametagManager = new StatusNametagManager(this);
        this.saveDefaultConfig();
        this.updateConfigIfNeeded();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
        this.loadPlayerDeathsConfig();
        this.loadServerStatsConfig();
        this.loadPlayerStatuses();
        this.loadPlayerDeaths();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.registerPaperAsyncChatListeners();
        Objects.requireNonNull(this.getCommand(this.commandName)).setTabCompleter((TabCompleter)this);
        int pluginId = 20901;
        new Metrics(this, pluginId);
        this.isTabPluginPresent = Bukkit.getPluginManager().getPlugin("TAB") != null;
        boolean bl = this.isDiscordSrvPresent = Bukkit.getPluginManager().getPlugin("DiscordSRV") != null;
        if (this.isDiscordSrvPresent) {
            this.getLogger().info("[StatusPlugin] DiscordSRV detected. Enabling Discord relay features.");
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.initializeLibertyBans(), 20L);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new StatusPlaceholder(this).register();
            this.getLogger().info("PlaceholderAPI placeholder registered successfully.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholder registration skipped.");
        }
        ModrinthVersionChecker.checkVersion();
        if (this.getConfig().getBoolean("country-location-enabled", false)) {
            this.countryLocationManager = new CountryLocationManager(this);
            this.getLogger().info("Country location feature enabled. IP geolocation will be active.");
        } else {
            this.getLogger().info("Country location feature disabled. To enable, set country-location-enabled to true in config.yml");
        }
        this.refreshDimensionCache();
        this.detectTpsFetchingMethod();
        this.detectMiniMessageSupport();
        this.startTabRefreshSchedulers();
        if (this.nametagManager != null) {
            this.nametagManager.scheduleInitialization();
            this.nametagManager.updateAllPlayerTeams();
        }
    }

    private void loadPlayerStatuses() {
        this.playerStatusMap.clear();
        for (String uuid : this.playerStatusConfig.getKeys(false)) {
            this.playerStatusMap.put(UUID.fromString(uuid), this.playerStatusConfig.getString(uuid));
        }
    }

    private void loadPlayerDeaths() {
        if (this.playerDeathsConfig == null) {
            return;
        }
        this.playerDeathMap.clear();
        for (String uuid : this.playerDeathsConfig.getKeys(false)) {
            int deaths = this.playerDeathsConfig.getInt(uuid, 0);
            this.playerDeathMap.put(UUID.fromString(uuid), deaths);
        }
        this.recalculateTotalTrackedDeathsFromMap();
    }

    public void onDisable() {
        this.stopTabRefreshSchedulers();
        this.savePlayerStatusConfig();
        this.savePlayerDeathsConfig();
        this.persistServerStats(true);
        if (this.nametagManager != null) {
            this.nametagManager.tearDown();
        }
        if (this.countryLocationManager != null) {
            this.countryLocationManager.saveAllPlayerCountries();
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args2) {
        if (command.getName().equalsIgnoreCase(this.commandName) && sender instanceof Player) {
            Player player = (Player)sender;
            if (this.getConfig().getBoolean("only-admin-change", false) && !player.hasPermission("statusplugin.admin")) {
                String message = this.getConfig().getString("only-admin-change-message", "&cOnly admins can change statuses.");
                player.sendMessage(ColorParser.parse(message));
                return true;
            }
            if (args2.length > 0) {
                String statusKey = args2[0].toUpperCase(Locale.ROOT);
                String status = this.statusOptions.get(statusKey);
                if (status != null) {
                    if ("ADMIN".equals(statusKey) && !player.isOp() && !player.hasPermission("statusplugin.admin")) {
                        player.sendMessage(ChatColor.RED + "Only admins can use the ADMIN status.");
                        return true;
                    }
                    if ("MOD".equals(statusKey) && !player.hasPermission("statusplugin.mod")) {
                        player.sendMessage(ChatColor.RED + "Only moderators can use the MOD status.");
                        return true;
                    }
                    this.playerStatusMap.put(player.getUniqueId(), status);
                    String message = this.getLanguageText(player, "status_set", "&aYour status has been set to: &r%s");
                    player.sendMessage(ColorParser.parse(String.format(message, status)));
                    player.sendMessage(ChatColor.GRAY + "Your status will show in chat when you send a message.");
                    this.getLogger().info("Set status for " + player.getName() + ": " + status);
                    if (this.nametagManager != null) {
                        this.nametagManager.assignPlayer(player);
                    }
                    this.updatePlayerTabList();
                    this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)status);
                    this.savePlayerStatusConfig();
                } else {
                    String message = this.getLanguageText(player, "invalid_status", "&cInvalid status option. Use /status <option>");
                    player.sendMessage(ColorParser.parse(message));
                }
            } else {
                this.playerStatusMap.remove(player.getUniqueId());
                String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
                player.sendMessage(ColorParser.parse(message));
                if (this.nametagManager != null) {
                    this.nametagManager.assignPlayer(player);
                }
                this.updatePlayerTabList();
                this.playerStatusConfig.set(player.getUniqueId().toString(), null);
                this.savePlayerStatusConfig();
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("reloadstatus") && (sender.isOp() || sender.hasPermission("statusplugin.reload"))) {
            this.reloadPlugin();
            sender.sendMessage(ChatColor.GREEN + "StatusPlugin configuration reloaded!");
            return true;
        }
        if (command.getName().equalsIgnoreCase("status-clear") && sender instanceof Player) {
            Player player = (Player)sender;
            this.playerStatusMap.remove(player.getUniqueId());
            String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
            player.sendMessage(ColorParser.parse(message));
            if (this.nametagManager != null) {
                this.nametagManager.assignPlayer(player);
            }
            this.updatePlayerTabList();
            this.playerStatusConfig.set(player.getUniqueId().toString(), null);
            this.savePlayerStatusConfig();
            return true;
        }
        if (command.getName().equalsIgnoreCase("status-admin") && sender.hasPermission("statusplugin.admin")) {
            if (args2.length == 0) {
                sender.sendMessage(ChatColor.RED + "Usage: /status-admin <player> <status> | /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount] | /status-admin reload");
                return true;
            }
            String subCommand = args2[0].toLowerCase(Locale.ROOT);
            if (subCommand.equals("reload")) {
                this.reloadPlugin();
                sender.sendMessage(ChatColor.GREEN + "StatusPlugin configuration reloaded!");
                return true;
            }
            if (subCommand.equals("deaths")) {
                Player refreshedOnlineTarget;
                Player targetProfile;
                if (args2.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount]");
                    return true;
                }
                Player onlineTarget = Bukkit.getPlayerExact((String)args2[1]);
                Object object = targetProfile = onlineTarget != null ? onlineTarget : Bukkit.getOfflinePlayer((String)args2[1]);
                if (targetProfile == null || !targetProfile.hasPlayedBefore() && !targetProfile.isOnline()) {
                    sender.sendMessage(ChatColor.RED + "Player not found.");
                    return true;
                }
                UUID targetUuid = targetProfile.getUniqueId();
                int currentDeaths = this.getPlayerDeaths(targetUuid);
                if (args2.length == 2) {
                    String targetName = targetProfile.getName() != null ? targetProfile.getName() : args2[1];
                    sender.sendMessage(ChatColor.YELLOW + targetName + ChatColor.GRAY + " has " + ChatColor.AQUA + currentDeaths + ChatColor.GRAY + " tracked deaths.");
                    return true;
                }
                String action = args2[2].toLowerCase(Locale.ROOT);
                int newDeaths = currentDeaths;
                switch (action) {
                    case "reset": {
                        newDeaths = 0;
                        break;
                    }
                    case "set": {
                        if (args2.length < 4) {
                            sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> set <amount>");
                            return true;
                        }
                        try {
                            int amount = Integer.parseInt(args2[3]);
                            if (amount < 0) {
                                sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                                return true;
                            }
                            newDeaths = amount;
                            break;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                            return true;
                        }
                    }
                    case "add": {
                        if (args2.length < 4) {
                            sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> add <amount>");
                            return true;
                        }
                        try {
                            int amount = Integer.parseInt(args2[3]);
                            if (amount < 0) {
                                sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                                return true;
                            }
                            newDeaths = currentDeaths + amount;
                            break;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                            return true;
                        }
                    }
                    case "remove": 
                    case "minus": {
                        if (args2.length < 4) {
                            sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> " + action + " <amount>");
                            return true;
                        }
                        try {
                            int amount = Integer.parseInt(args2[3]);
                            if (amount < 0) {
                                sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                                return true;
                            }
                            newDeaths = Math.max(0, currentDeaths - amount);
                            break;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                            return true;
                        }
                    }
                    default: {
                        sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount]");
                        return true;
                    }
                }
                this.playerDeathMap.put(targetUuid, newDeaths);
                if (this.playerDeathsConfig != null) {
                    this.playerDeathsConfig.set(targetUuid.toString(), (Object)newDeaths);
                    this.savePlayerDeathsConfig();
                }
                this.adjustTotalTrackedDeaths((long)newDeaths - (long)currentDeaths);
                if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
                    this.updatePlayerTabList();
                }
                if ((refreshedOnlineTarget = Bukkit.getPlayer((UUID)targetUuid)) != null) {
                    try {
                        refreshedOnlineTarget.setStatistic(Statistic.DEATHS, newDeaths);
                    }
                    catch (IllegalArgumentException ex) {
                        this.getLogger().log(Level.FINE, "Failed to set vanilla death statistic for " + refreshedOnlineTarget.getName(), ex);
                    }
                    if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
                        this.updatePlayerTabListName(refreshedOnlineTarget, TabEnvironmentSnapshot.capture(this), "");
                    }
                    refreshedOnlineTarget.sendMessage(ChatColor.GOLD + "Your tracked deaths were updated to " + ChatColor.AQUA + newDeaths + ChatColor.GOLD + " by an administrator.");
                }
                String targetName = targetProfile.getName() != null ? targetProfile.getName() : args2[1];
                sender.sendMessage(ChatColor.GREEN + "Set " + targetName + "'s tracked deaths to " + newDeaths + ".");
                return true;
            }
            int targetIndex = 0;
            int statusIndex = 1;
            if (subCommand.equals("set")) {
                if (args2.length < 3) {
                    sender.sendMessage(ChatColor.RED + "Usage: /status-admin set <player> <status>");
                    return true;
                }
                targetIndex = 1;
                statusIndex = 2;
            } else if (args2.length < 2) {
                sender.sendMessage(ChatColor.RED + "Usage: /status-admin <player> <status>");
                return true;
            }
            Player targetPlayer = Bukkit.getPlayer((String)args2[targetIndex]);
            if (targetPlayer == null) {
                sender.sendMessage(ChatColor.RED + "Player not found.");
                return true;
            }
            String statusKey = args2[statusIndex].toUpperCase(Locale.ROOT);
            String status = this.statusOptions.get(statusKey);
            if (status == null) {
                sender.sendMessage(ChatColor.RED + "Invalid status option. Use /status-admin " + (subCommand.equals("set") ? "set <player> <status>" : "<player> <status>"));
                return true;
            }
            if ("ADMIN".equals(statusKey) && !targetPlayer.isOp() && !targetPlayer.hasPermission("statusplugin.admin")) {
                sender.sendMessage(ChatColor.RED + "ADMIN status can only be applied to admins or operators.");
                return true;
            }
            if ("MOD".equals(statusKey) && !targetPlayer.hasPermission("statusplugin.mod")) {
                sender.sendMessage(ChatColor.RED + "MOD status can only be applied to moderators.");
                return true;
            }
            this.playerStatusMap.put(targetPlayer.getUniqueId(), status);
            String message = this.getLanguageText(targetPlayer, "status_set", "&aYour status has been set to: &r%s");
            targetPlayer.sendMessage(ColorParser.parse(String.format(message, status)));
            if (this.nametagManager != null) {
                this.nametagManager.assignPlayer(targetPlayer);
            }
            this.updatePlayerTabList();
            this.playerStatusConfig.set(targetPlayer.getUniqueId().toString(), (Object)status);
            this.savePlayerStatusConfig();
            sender.sendMessage(ChatColor.GREEN + "Status of " + targetPlayer.getName() + " has been set to: " + ColorParser.parse(status));
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String joinMessage;
        Player player = event.getPlayer();
        if (this.getConfig().getBoolean("default_status_enabled", true)) {
            String defaultStatus = this.getConfig().getString("default_status", "DEFAULT");
            this.playerStatusMap.put(player.getUniqueId(), defaultStatus);
            this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)defaultStatus);
            this.savePlayerStatusConfig();
        }
        if (this.countryLocationManager != null && this.getConfig().getBoolean("country-location-enabled", true)) {
            ((CompletableFuture)this.countryLocationManager.getPlayerCountryAsync(player).thenAccept(countryData -> {
                if (countryData != null && this.getConfig().getBoolean("tab-styling-enabled", true)) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> this.updatePlayerTabList());
                }
            })).exceptionally(throwable -> {
                this.getLogger().warning("Failed to fetch country data for player " + player.getName() + ": " + throwable.getMessage());
                return null;
            });
        }
        this.syncPlayerDeathsFromStatistic(player);
        if (player.hasPermission("statusplugin.admin") && this.getConfig().getBoolean("admin-join-message-enabled", false)) {
            String adminJoinMessage = "&aThank you for using this status plugin. When you want to support me, please download my plugin from Modrinth! https://modrinth.com/plugin/statusplugin-like-in-craftattack";
            player.sendMessage(ColorParser.parse(adminJoinMessage));
        }
        if (player.isOp() || player.hasPermission("statusplugin.admin")) {
            ModrinthVersionChecker.checkVersion();
        }
        if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
            if (this.nametagManager != null) {
                this.nametagManager.assignPlayer(player);
            }
            this.updatePlayerTabList();
        }
        if (this.nametagCleanJoinMessage && (joinMessage = event.getJoinMessage()) != null && !joinMessage.isEmpty()) {
            joinMessage = this.sanitizeDisplayNameOccurrences(joinMessage, player);
            event.setJoinMessage(joinMessage);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        String deathMessage;
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        int deaths = this.playerDeathMap.getOrDefault(uuid, 0) + 1;
        this.playerDeathMap.put(uuid, deaths);
        if (this.playerDeathsConfig != null) {
            this.playerDeathsConfig.set(uuid.toString(), (Object)deaths);
            this.savePlayerDeathsConfig();
        }
        this.adjustTotalTrackedDeaths(1L);
        if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
            this.updatePlayerTabList();
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.syncPlayerDeathsFromStatistic(player));
        if (this.nametagCleanDeathMessage && (deathMessage = event.getDeathMessage()) != null && !deathMessage.isEmpty()) {
            deathMessage = this.sanitizeDisplayNameOccurrences(deathMessage, player);
            Player killer = player.getKiller();
            if (killer != null) {
                deathMessage = this.sanitizeDisplayNameOccurrences(deathMessage, killer);
            }
            event.setDeathMessage(deathMessage);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChatMuteCheck(AsyncPlayerChatEvent event) {
        this.cancelIfMuted(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.handleChatMessage(event.getPlayer(), event.getMessage(), (Cancellable)event);
    }

    private void handleChatMessage(Player player, String originalMessage, Cancellable cancellable) {
        String chatFormat;
        String adminStatusFormat;
        boolean usingAdminStatus;
        if (Boolean.TRUE.equals(relayingToDiscord.get())) {
            return;
        }
        if (cancellable.isCancelled()) {
            return;
        }
        if (!this.getConfig().getBoolean("chat-styling-enabled", true)) {
            return;
        }
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        if (!status.isEmpty()) {
            this.getLogger().info("Chat from " + player.getName() + " with status: " + status);
        }
        boolean bl = usingAdminStatus = (adminStatusFormat = this.statusOptions.get("ADMIN")) != null && adminStatusFormat.equals(status);
        if (status.isEmpty()) {
            chatFormat = this.getConfig().getString("chat-format-no-status", "<$$PLAYER$$> ");
        } else {
            chatFormat = this.getConfig().getString("chat-format", "%status% <$$PLAYER$$> ");
            chatFormat = chatFormat.replace("%status%", status);
            this.getLogger().info("Using chat format: " + chatFormat);
        }
        if (this.getConfig().getBoolean("country-location-enabled", false) && this.countryLocationManager != null) {
            CountryLocationManager.CountryData countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
            if (countryData != null) {
                chatFormat = chatFormat.replace("%country%", countryData.getCountry());
                chatFormat = chatFormat.replace("%countrycode%", countryData.getCountryCode());
            } else {
                chatFormat = chatFormat.replace("%country%", "");
                chatFormat = chatFormat.replace("%countrycode%", "");
            }
        } else {
            chatFormat = chatFormat.replace("%country%", "");
            chatFormat = chatFormat.replace("%countrycode%", "");
        }
        chatFormat = chatFormat.replace("%deaths%", String.valueOf(this.getPlayerDeaths(player.getUniqueId())));
        String playerName = player.getName();
        if (usingAdminStatus) {
            playerName = ChatColor.RED + playerName + ChatColor.RESET;
        }
        chatFormat = chatFormat.replace("$$PLAYER$$", playerName);
        chatFormat = ColorParser.parse(chatFormat);
        BaseComponent[] statusComponent = TextComponent.fromLegacyText((String)chatFormat);
        String messageText = originalMessage;
        if (usingAdminStatus) {
            messageText = ChatColor.RED + messageText + ChatColor.RESET;
        }
        BaseComponent[] messageComponent = TextComponent.fromLegacyText((String)messageText);
        BaseComponent[] finalComponents = new BaseComponent[statusComponent.length + messageComponent.length];
        System.arraycopy(statusComponent, 0, finalComponents, 0, statusComponent.length);
        System.arraycopy(messageComponent, 0, finalComponents, statusComponent.length, messageComponent.length);
        for (BaseComponent component : finalComponents) {
            String text = component.toPlainText();
            if (!text.contains("http://") && !text.contains("https://")) continue;
            component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, text));
        }
        for (Player recipient : Bukkit.getOnlinePlayers()) {
            recipient.spigot().sendMessage(finalComponents);
        }
        cancellable.setCancelled(true);
        this.relayChatToDiscord(player, originalMessage);
    }

    private boolean cancelIfMuted(Player player, Cancellable event) {
        Optional muteInfo;
        if (event.isCancelled()) {
            return true;
        }
        if (this.isLibertyBansPresent && this.libertyBansIntegration != null && (muteInfo = this.libertyBansIntegration.getActiveMute(player)).isPresent()) {
            event.setCancelled(true);
            this.sendMuteNotification(player, (MuteInfo)muteInfo.get());
            return true;
        }
        return false;
    }

    private void relayChatToDiscord(Player player, String message) {
        if (!this.isDiscordSrvPresent || !this.getConfig().getBoolean("discordsrv-relay-enabled", true) || Boolean.TRUE.equals(relayingToDiscord.get())) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            try {
                relayingToDiscord.set(true);
                AsyncPlayerChatEvent forward = new AsyncPlayerChatEvent(false, player, message, new HashSet());
                Bukkit.getPluginManager().callEvent((Event)forward);
            }
            finally {
                relayingToDiscord.set(false);
            }
        });
    }

    private String convertAdventureComponentToLegacy(Object adventureComponent) {
        int start;
        int end;
        if (adventureComponent == null) {
            return "";
        }
        try {
            Class<?> serializerClass;
            Method plainTextMethod;
            Object serializer;
            Method serializeMethod;
            Object plain;
            ClassLoader loader = adventureComponent.getClass().getClassLoader();
            Class<?> componentClass = Class.forName("de.stylelabor.lib.kyori.adventure.text.Component", true, loader);
            if (componentClass.isInstance(adventureComponent) && (plain = (serializeMethod = (serializer = (plainTextMethod = (serializerClass = Class.forName("de.stylelabor.lib.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer", true, loader)).getMethod("plainText", new Class[0])).invoke(null, new Object[0])).getClass().getMethod("serialize", componentClass)).invoke(serializer, adventureComponent)) instanceof String) {
                return (String)plain;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException loader) {
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            this.getLogger().log(Level.FINE, "Failed to convert Adventure component using plain serializer", ex);
        }
        try {
            Method contentMethod = adventureComponent.getClass().getMethod("content", new Class[0]);
            Object content = contentMethod.invoke(adventureComponent, new Object[0]);
            if (content instanceof String) {
                return (String)content;
            }
        }
        catch (NoSuchMethodException contentMethod) {
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            this.getLogger().log(Level.FINE, "Failed to access Adventure component content", ex);
        }
        String raw = adventureComponent.toString();
        int contentIndex = raw.indexOf("content=\"");
        if (contentIndex >= 0 && (end = raw.indexOf(34, start = contentIndex + "content=\"".length())) > start) {
            return raw.substring(start, end);
        }
        return raw;
    }

    private void registerPaperAsyncChatListeners() {
        try {
            Class<?> asyncChatEventClass = Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
            Method playerMethod = asyncChatEventClass.getMethod("getPlayer", new Class[0]);
            Method messageMethod = asyncChatEventClass.getMethod("message", new Class[0]);
            EventExecutor muteExecutor = (listener, event) -> {
                if (!asyncChatEventClass.isInstance(event)) {
                    return;
                }
                if (!(event instanceof Cancellable)) {
                    return;
                }
                try {
                    Player player = (Player)playerMethod.invoke((Object)event, new Object[0]);
                    this.cancelIfMuted(player, (Cancellable)event);
                }
                catch (IllegalAccessException | InvocationTargetException reflectionException) {
                    this.getLogger().log(Level.SEVERE, "Failed to handle Paper AsyncChatEvent mute check", reflectionException);
                }
            };
            EventExecutor chatExecutor = (listener, event) -> {
                if (!asyncChatEventClass.isInstance(event)) {
                    return;
                }
                if (!(event instanceof Cancellable)) {
                    return;
                }
                try {
                    Player player = (Player)playerMethod.invoke((Object)event, new Object[0]);
                    Object component = messageMethod.invoke((Object)event, new Object[0]);
                    String message = this.convertAdventureComponentToLegacy(component);
                    this.handleChatMessage(player, message, (Cancellable)event);
                }
                catch (IllegalAccessException | InvocationTargetException reflectionException) {
                    this.getLogger().log(Level.SEVERE, "Failed to handle Paper AsyncChatEvent formatting", reflectionException);
                }
            };
            Bukkit.getPluginManager().registerEvent(asyncChatEventClass, (Listener)this, EventPriority.LOWEST, muteExecutor, (Plugin)this, false);
            Bukkit.getPluginManager().registerEvent(asyncChatEventClass, (Listener)this, EventPriority.HIGH, chatExecutor, (Plugin)this, false);
            this.getLogger().info("Paper AsyncChatEvent detected. Modern chat pipeline support enabled.");
        }
        catch (ClassNotFoundException asyncChatEventClass) {
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Failed to register Paper AsyncChatEvent listeners", ex);
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args2) {
        ArrayList<String> completions;
        block21: {
            block20: {
                completions = new ArrayList<String>();
                if (!command.getName().equalsIgnoreCase("status")) break block20;
                if (args2.length != 1) break block21;
                String prefix = args2[0].toUpperCase(Locale.ROOT);
                boolean canUseAdminStatus = true;
                boolean canUseModStatus = true;
                if (sender instanceof Player) {
                    Player playerSender = (Player)sender;
                    canUseAdminStatus = playerSender.isOp() || playerSender.hasPermission("statusplugin.admin");
                    canUseModStatus = playerSender.hasPermission("statusplugin.mod");
                }
                for (String option : this.statusOptions.keySet()) {
                    if (!option.startsWith(prefix) || "ADMIN".equals(option) && !canUseAdminStatus || "MOD".equals(option) && !canUseModStatus) continue;
                    completions.add(option);
                }
                break block21;
            }
            if (!command.getName().equalsIgnoreCase("status-admin")) break block21;
            if (args2.length == 1) {
                String prefix = args2[0].toLowerCase(Locale.ROOT);
                if ("reload".startsWith(prefix)) {
                    completions.add("reload");
                }
                if ("deaths".startsWith(prefix)) {
                    completions.add("deaths");
                }
                if ("set".startsWith(prefix)) {
                    completions.add("set");
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                    completions.add(player.getName());
                }
            } else if (args2.length == 2) {
                if (args2[0].equalsIgnoreCase("deaths") || args2[0].equalsIgnoreCase("set")) {
                    String prefix = args2[1].toLowerCase(Locale.ROOT);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                        completions.add(player.getName());
                    }
                } else {
                    String prefix = args2[1].toUpperCase(Locale.ROOT);
                    for (String option : this.statusOptions.keySet()) {
                        if (!option.startsWith(prefix)) continue;
                        completions.add(option);
                    }
                }
            } else if (args2.length == 3) {
                if (args2[0].equalsIgnoreCase("deaths")) {
                    String prefix = args2[2].toLowerCase(Locale.ROOT);
                    List<String> actions = Arrays.asList("add", "remove", "minus", "reset", "set");
                    for (String action : actions) {
                        if (!action.startsWith(prefix)) continue;
                        completions.add(action);
                    }
                } else if (args2[0].equalsIgnoreCase("set")) {
                    String prefix = args2[2].toUpperCase(Locale.ROOT);
                    for (String option : this.statusOptions.keySet()) {
                        if (!option.startsWith(prefix)) continue;
                        completions.add(option);
                    }
                }
            }
        }
        return completions;
    }

    private void updateConfigIfNeeded() {
        int expectedConfigVersion;
        FileConfiguration config = this.getConfig();
        int currentConfigVersion = config.getInt("config-version", 1);
        if (currentConfigVersion >= (expectedConfigVersion = 8)) {
            return;
        }
        this.getLogger().info("========================================");
        this.getLogger().info("[StatusPlugin] Detected config from older version!");
        this.getLogger().info("[StatusPlugin] Current config version: " + currentConfigVersion);
        this.getLogger().info("[StatusPlugin] Expected config version: " + expectedConfigVersion);
        this.getLogger().info("[StatusPlugin] Updating config with new options...");
        this.getLogger().info("[StatusPlugin] IMPORTANT: Only adding NEW keys, preserving ALL existing settings!");
        File configFile = new File(this.getDataFolder(), "config.yml");
        File backupFile = new File(this.getDataFolder(), "config.yml.backup-v" + currentConfigVersion);
        try {
            if (configFile.exists()) {
                Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().info("[StatusPlugin] Created backup: " + backupFile.getName());
            }
        }
        catch (IOException e) {
            this.getLogger().warning("[StatusPlugin] Failed to create config backup: " + e.getMessage());
        }
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getResource("config.yml"), StandardCharsets.UTF_8));
        int addedKeys = 0;
        int skippedKeys = 0;
        for (String key : defaultConfig.getKeys(true)) {
            Object value = defaultConfig.get(key);
            if (value instanceof ConfigurationSection) continue;
            if (!config.contains(key)) {
                config.set(key, defaultConfig.get(key));
                ++addedKeys;
                this.getLogger().info("[StatusPlugin] + Added: " + key);
                continue;
            }
            ++skippedKeys;
        }
        config.set("config-version", (Object)expectedConfigVersion);
        config.set("plugin-version", (Object)this.getDescription().getVersion());
        this.saveConfig();
        this.getLogger().info("[StatusPlugin] \u2713 Config update complete!");
        this.getLogger().info("[StatusPlugin] \u2713 Added " + addedKeys + " NEW config options");
        this.getLogger().info("[StatusPlugin] \u2713 Preserved " + skippedKeys + " EXISTING settings (not touched)");
        this.getLogger().info("[StatusPlugin] \u2713 Your tab list formats, statuses, and all settings are safe!");
        this.getLogger().info("[StatusPlugin] Backup saved as: " + backupFile.getName());
        this.getLogger().info("========================================");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.commandName = config.getString("command-name", "status");
        config.getString("chat-format", "%status% &r<$$PLAYER$$> &e%countrycode% &c%deaths%");
        this.tabListFormat = config.getString("tab-list-format", "&a%status% &r$$PLAYER$$ &e%countrycode% &c%deaths%");
        this.defaultLanguage = config.getString("default-language", "english");
        this.useOnlyOneLanguage = config.getBoolean("use-only-one-language", true);
        this.customTabListEnabled = config.getBoolean("custom-tablist-enabled", false);
        this.tabRefreshIntervalTicks = Math.max(1, config.getInt("tab-refresh-interval-ticks", 20));
        this.tabDimensionRefreshIntervalTicks = Math.max(this.tabRefreshIntervalTicks, config.getInt("tab-dimension-refresh-interval-ticks", 200));
        boolean sortByStatus = config.getBoolean("tab-list-sort-by-status", true);
        this.nametagStatusEnabled = config.getBoolean("nametag-status-enabled", false);
        this.nametagCleanJoinMessage = config.getBoolean("nametag-clean-join-message", true);
        this.nametagCleanDeathMessage = config.getBoolean("nametag-clean-death-message", true);
        this.loadStatusOptions();
        this.loadTabListConfig();
        boolean defaultStatusEnabled = config.getBoolean("default_status_enabled", true);
        String defaultStatus = config.getString("default_status", "DEFAULT");
        if (defaultStatusEnabled) {
            this.statusOptions.put("DEFAULT", defaultStatus);
        }
        if (this.nametagManager != null) {
            this.nametagManager.updateSettings(this.nametagStatusEnabled, sortByStatus);
        }
    }

    private void loadStatusOptions() {
        YamlConfiguration statusOptionsConfig;
        File statusOptionsFile = new File(this.getDataFolder(), "status-options.yml");
        if (!statusOptionsFile.exists()) {
            this.saveResource("status-options.yml", false);
        }
        if ((statusOptionsConfig = YamlConfiguration.loadConfiguration((File)statusOptionsFile)).isConfigurationSection("status")) {
            Set keys2 = Objects.requireNonNull(statusOptionsConfig.getConfigurationSection("status")).getKeys(false);
            for (String key : keys2) {
                this.statusOptions.put(key.toUpperCase(), statusOptionsConfig.getString("status." + key));
            }
        }
    }

    private void loadTabListConfig() {
        YamlConfiguration tabListConfig;
        List<String> headerLines;
        File tabListFile = new File(this.getDataFolder(), "tablist.yml");
        if (!tabListFile.exists()) {
            this.saveResource("tablist.yml", false);
        }
        if ((headerLines = (tabListConfig = YamlConfiguration.loadConfiguration((File)tabListFile)).getStringList("header")).isEmpty() && tabListConfig.isString("header")) {
            String headerLine = tabListConfig.getString("header");
            headerLines = Collections.singletonList(headerLine == null ? "" : headerLine);
        }
        this.tabListHeaderLines = headerLines.isEmpty() ? Collections.emptyList() : new ArrayList(headerLines);
        List<String> footerLines = tabListConfig.getStringList("footer");
        if (footerLines.isEmpty() && tabListConfig.isString("footer")) {
            String footerLine = tabListConfig.getString("footer");
            footerLines = Collections.singletonList(footerLine == null ? "" : footerLine);
        }
        this.tabListFooterLines = footerLines.isEmpty() ? Collections.emptyList() : new ArrayList(footerLines);
        List rotatingLines = Collections.emptyList();
        this.rotatingLineIntervalTicks = Math.max(this.tabRefreshIntervalTicks, 100);
        if (tabListConfig.isList("rotating-line")) {
            rotatingLines = tabListConfig.getStringList("rotating-line");
        } else {
            ConfigurationSection rotatingSection = tabListConfig.getConfigurationSection("rotating-line");
            if (rotatingSection != null) {
                rotatingLines = rotatingSection.getStringList("entries");
                this.rotatingLineIntervalTicks = Math.max(this.tabRefreshIntervalTicks, rotatingSection.getInt("interval-ticks", this.rotatingLineIntervalTicks));
            }
        }
        this.tabListRotatingLines = rotatingLines.isEmpty() ? Collections.emptyList() : new ArrayList<String>(rotatingLines);
        this.rotatingLineIndex = 0;
        this.rotatingLineElapsedTicks = 0;
    }

    private void loadLanguageConfig() {
        File languageFile;
        String languageFileName;
        String string = languageFileName = this.useOnlyOneLanguage ? "language.yml" : this.defaultLanguage + "_language.yml";
        if (this.useOnlyOneLanguage) {
            languageFile = new File(this.getDataFolder(), languageFileName);
            if (!languageFile.exists()) {
                this.saveResource(languageFileName, false);
            }
        } else {
            languageFile = new File(this.getDataFolder(), this.defaultLanguage + "_language.yml");
            if (!languageFile.exists()) {
                this.saveResource(this.defaultLanguage + "_language.yml", false);
            }
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    private void loadPlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        if (!playerStatusFile.exists()) {
            try {
                if (playerStatusFile.createNewFile()) {
                    this.getLogger().info("player-status.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadPlayerStatusConfig | IOException e");
            }
        }
        this.playerStatusConfig = YamlConfiguration.loadConfiguration((File)playerStatusFile);
    }

    private void loadPlayerDeathsConfig() {
        File playerDeathsFile = new File(this.getDataFolder(), "player-deaths.yml");
        if (!playerDeathsFile.exists()) {
            try {
                if (playerDeathsFile.createNewFile()) {
                    this.getLogger().info("player-deaths.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadPlayerDeathsConfig | IOException e");
            }
        }
        this.playerDeathsConfig = YamlConfiguration.loadConfiguration((File)playerDeathsFile);
    }

    private void loadServerStatsConfig() {
        File serverStatsFile = new File(this.getDataFolder(), "server-stats.yml");
        if (!serverStatsFile.exists()) {
            try {
                if (serverStatsFile.createNewFile()) {
                    this.getLogger().info("server-stats.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadServerStatsConfig | IOException e");
            }
        }
        this.serverStatsConfig = YamlConfiguration.loadConfiguration((File)serverStatsFile);
        long storedTotalDeaths = this.serverStatsConfig.getLong("total-deaths", -1L);
        if (storedTotalDeaths >= 0L) {
            this.totalTrackedDeaths = storedTotalDeaths;
        }
        this.serverStatsDirty = false;
        this.statsAutosaveCounterTicks = 0;
    }

    private void savePlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        try {
            this.playerStatusConfig.save(playerStatusFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | savePlayerStatusConfig | IOException e");
        }
    }

    private void savePlayerDeathsConfig() {
        File playerDeathsFile = new File(this.getDataFolder(), "player-deaths.yml");
        try {
            this.playerDeathsConfig.save(playerDeathsFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | savePlayerDeathsConfig | IOException e");
        }
    }

    private void saveServerStatsConfig() {
        if (this.serverStatsConfig == null) {
            return;
        }
        File serverStatsFile = new File(this.getDataFolder(), "server-stats.yml");
        this.serverStatsConfig.set("total-deaths", (Object)this.totalTrackedDeaths);
        try {
            this.serverStatsConfig.save(serverStatsFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | saveServerStatsConfig | IOException e");
        }
    }

    private void persistServerStats(boolean force) {
        if (this.serverStatsConfig == null) {
            return;
        }
        if (force) {
            this.cancelDelayedStatsSave();
        }
        if (!this.serverStatsDirty && !force) {
            return;
        }
        if (!force) {
            this.statsAutosaveCounterTicks += this.tabRefreshIntervalTicks;
            if (this.statsAutosaveCounterTicks < 6000) {
                return;
            }
        }
        this.statsAutosaveCounterTicks = 0;
        this.serverStatsDirty = false;
        this.saveServerStatsConfig();
    }

    private void markServerStatsDirty() {
        if (this.serverStatsConfig == null) {
            return;
        }
        this.serverStatsDirty = true;
        this.scheduleStatsSave();
    }

    private void scheduleStatsSave() {
        if (this.delayedStatsSaveTask != null) {
            return;
        }
        this.delayedStatsSaveTask = Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this.delayedStatsSaveTask = null;
            this.persistServerStats(true);
        }, 200L);
    }

    private void cancelDelayedStatsSave() {
        if (this.delayedStatsSaveTask != null) {
            this.delayedStatsSaveTask.cancel();
            this.delayedStatsSaveTask = null;
        }
    }

    private void adjustTotalTrackedDeaths(long delta) {
        if (delta == 0L) {
            return;
        }
        long recalculated = this.totalTrackedDeaths + delta;
        if (recalculated < 0L) {
            this.recalculateTotalTrackedDeathsFromMap();
            return;
        }
        this.totalTrackedDeaths = recalculated;
        if (this.serverStatsConfig != null) {
            this.serverStatsConfig.set("total-deaths", (Object)this.totalTrackedDeaths);
            this.markServerStatsDirty();
        }
    }

    private void recalculateTotalTrackedDeathsFromMap() {
        long total = 0L;
        for (int deaths : this.playerDeathMap.values()) {
            total += (long)deaths;
        }
        this.totalTrackedDeaths = Math.max(0L, total);
        if (this.serverStatsConfig != null) {
            this.serverStatsConfig.set("total-deaths", (Object)this.totalTrackedDeaths);
            this.markServerStatsDirty();
        }
    }

    private void syncPlayerDeathsFromStatistic(Player player) {
        if (player == null) {
            return;
        }
        try {
            int vanillaDeaths = player.getStatistic(Statistic.DEATHS);
            UUID uuid = player.getUniqueId();
            int storedDeaths = this.playerDeathMap.getOrDefault(uuid, 0);
            if (vanillaDeaths == storedDeaths) {
                return;
            }
            boolean statisticUpdated = false;
            try {
                player.setStatistic(Statistic.DEATHS, storedDeaths);
                statisticUpdated = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!statisticUpdated) {
                this.playerDeathMap.put(uuid, vanillaDeaths);
                if (this.playerDeathsConfig != null) {
                    this.playerDeathsConfig.set(uuid.toString(), (Object)vanillaDeaths);
                    this.savePlayerDeathsConfig();
                }
                this.adjustTotalTrackedDeaths((long)vanillaDeaths - (long)storedDeaths);
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
    }

    private String getLanguageText(Player player, String key, String defaultText) {
        if (this.useOnlyOneLanguage) {
            return this.languageConfig.getString(key, defaultText);
        }
        String playerLanguage = this.languageConfig.getString(player.getUniqueId() + ".language", this.defaultLanguage);
        File playerLanguageFile = new File(this.getDataFolder(), playerLanguage + "_language.yml");
        YamlConfiguration playerLanguageConfig = YamlConfiguration.loadConfiguration((File)playerLanguageFile);
        return playerLanguageConfig.getString(key, defaultText);
    }

    private void updatePlayerTabList() {
        this.updatePlayerTabList(TabEnvironmentSnapshot.capture(this));
    }

    public String getStatusKeyFromValue(String statusValue) {
        if (statusValue == null || statusValue.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, String> entry : this.statusOptions.entrySet()) {
            if (!entry.getValue().equals(statusValue)) continue;
            return entry.getKey();
        }
        return "";
    }

    private void updatePlayerTabList(TabEnvironmentSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        if (this.nametagManager != null && this.nametagManager.isActive()) {
            this.nametagManager.updateAllPlayerTeams();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updatePlayerTabListName(player, snapshot, "");
        }
    }

    private void startTabRefreshSchedulers() {
        this.stopTabRefreshSchedulers();
        if (!this.getConfig().getBoolean("tab-styling-enabled", true)) {
            return;
        }
        this.statsAutosaveCounterTicks = 0;
        this.refreshDimensionCache();
        this.runFastTabRefreshTick();
        this.slowTabRefreshTask = new BukkitRunnable(){

            public void run() {
                StatusPlugin.this.refreshDimensionCache();
            }
        }.runTaskTimer((Plugin)this, (long)this.tabDimensionRefreshIntervalTicks, (long)this.tabDimensionRefreshIntervalTicks);
        this.fastTabRefreshTask = new BukkitRunnable(){

            public void run() {
                StatusPlugin.this.runFastTabRefreshTick();
            }
        }.runTaskTimer((Plugin)this, (long)this.tabRefreshIntervalTicks, (long)this.tabRefreshIntervalTicks);
    }

    private void stopTabRefreshSchedulers() {
        this.cancelDelayedStatsSave();
        if (this.fastTabRefreshTask != null) {
            this.fastTabRefreshTask.cancel();
            this.fastTabRefreshTask = null;
        }
        if (this.slowTabRefreshTask != null) {
            this.slowTabRefreshTask.cancel();
            this.slowTabRefreshTask = null;
        }
    }

    private void refreshDimensionCache() {
        this.cachedOverworldPlayers = this.countPlayersInEnvironment(World.Environment.NORMAL);
        this.cachedNetherPlayers = this.countPlayersInEnvironment(World.Environment.NETHER);
        this.cachedEndPlayers = this.countPlayersInEnvironment(World.Environment.THE_END);
    }

    private void runFastTabRefreshTick() {
        if (!this.getConfig().getBoolean("tab-styling-enabled", true)) {
            return;
        }
        double[] tpsValues = this.fetchRecentTps();
        this.cachedPerformanceLabel = this.computePerformanceLabel(tpsValues);
        this.cachedMspt = this.fetchMspt();
        if (!this.tabListRotatingLines.isEmpty()) {
            this.rotatingLineElapsedTicks += this.tabRefreshIntervalTicks;
            if (this.rotatingLineElapsedTicks >= Math.max(this.rotatingLineIntervalTicks, this.tabRefreshIntervalTicks)) {
                this.rotatingLineElapsedTicks = 0;
                this.rotatingLineIndex = (this.rotatingLineIndex + 1) % this.tabListRotatingLines.size();
            }
        }
        TabEnvironmentSnapshot snapshot = TabEnvironmentSnapshot.capture(this, tpsValues);
        this.updatePlayerTabList(snapshot);
        this.persistServerStats(false);
    }

    private String computePerformanceLabel(double[] tpsValues) {
        double tps;
        double d = tps = tpsValues != null && tpsValues.length > 0 ? tpsValues[0] : -1.0;
        if (tps <= 0.0) {
            return ChatColor.DARK_RED + "" + ChatColor.UNDERLINE + "UNKNOWN" + ChatColor.RESET;
        }
        if (tps >= 19.5) {
            return ChatColor.GREEN + "" + ChatColor.UNDERLINE + "SMOOTH" + ChatColor.RESET;
        }
        if (tps >= 18.0) {
            return ChatColor.YELLOW + "" + ChatColor.UNDERLINE + "STABLE" + ChatColor.RESET;
        }
        if (tps >= 15.0) {
            return ChatColor.GOLD + "" + ChatColor.UNDERLINE + "STRUGGLING" + ChatColor.RESET;
        }
        return ChatColor.RED + "" + ChatColor.UNDERLINE + "CRITICAL" + ChatColor.RESET;
    }

    public String getPlayerStatus(UUID uuid) {
        return this.playerStatusMap.getOrDefault(uuid, "");
    }

    public CountryLocationManager getCountryLocationManager() {
        return this.countryLocationManager;
    }

    public int getPlayerDeaths(UUID uuid) {
        return this.playerDeathMap.getOrDefault(uuid, 0);
    }

    public String getPerformanceLabel() {
        if (this.fastTabRefreshTask == null) {
            this.cachedPerformanceLabel = this.computePerformanceLabel(this.fetchRecentTps());
        }
        return this.cachedPerformanceLabel;
    }

    public String getMspt() {
        if (this.fastTabRefreshTask == null) {
            this.cachedMspt = this.fetchMspt();
        }
        return this.cachedMspt;
    }

    public long getTotalTrackedDeaths() {
        return this.totalTrackedDeaths;
    }

    public String getFormattedTotalTrackedDeaths() {
        return this.formatLargeNumber(this.totalTrackedDeaths);
    }

    private void updatePlayerTabListName(Player player, TabEnvironmentSnapshot snapshot, String invisibleSortPrefix) {
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        String playerName = player.getName();
        String adminStatusFormat = this.statusOptions.get("ADMIN");
        boolean usingAdminStatus = adminStatusFormat != null && adminStatusFormat.equals(status);
        String coloredPlayerName = usingAdminStatus ? ChatColor.RED + playerName + ChatColor.RESET : playerName;
        CountryLocationManager.CountryData countryData = null;
        if (snapshot.countryPlaceholdersEnabled) {
            countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
        }
        if (snapshot.tabStylingEnabled) {
            String template = status.isEmpty() ? this.getConfig().getString("tab-list-format-no-status", "&7[&e%countrycode%&7] &r$$PLAYER$$") : this.tabListFormat;
            String tabListName = this.formatTabListText(template, player, status, coloredPlayerName, countryData, snapshot);
            tabListName = ColorParser.parse(tabListName);
            tabListName = invisibleSortPrefix + tabListName;
            if (this.isTabPluginPresent) {
                TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
                TabListFormatManager formatManager = TabAPI.getInstance().getTabListFormatManager();
                if (tabPlayer != null && formatManager != null) {
                    formatManager.setPrefix(tabPlayer, null);
                    formatManager.setName(tabPlayer, tabListName);
                    formatManager.setSuffix(tabPlayer, null);
                }
            } else {
                player.setPlayerListName(tabListName);
            }
        } else {
            this.resetTabListName(player);
        }
        this.applyTabListHeaderFooter(player, snapshot, status, coloredPlayerName, countryData);
    }

    private void resetTabListName(Player player) {
        if (this.isTabPluginPresent) {
            TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
            TabListFormatManager formatManager = TabAPI.getInstance().getTabListFormatManager();
            if (tabPlayer != null && formatManager != null) {
                formatManager.setPrefix(tabPlayer, null);
                formatManager.setName(tabPlayer, player.getName());
                formatManager.setSuffix(tabPlayer, null);
            }
        } else {
            player.setPlayerListName(player.getName());
        }
    }

    private void applyTabListHeaderFooter(Player player, TabEnvironmentSnapshot snapshot, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData) {
        String header = "";
        String footer = "";
        if (this.customTabListEnabled) {
            header = this.formatTabListSection(this.tabListHeaderLines, player, status, coloredPlayerName, countryData, snapshot);
            footer = this.formatTabListSection(this.tabListFooterLines, player, status, coloredPlayerName, countryData, snapshot);
        }
        header = ColorParser.parse(header);
        footer = ColorParser.parse(footer);
        if (this.isTabPluginPresent) {
            TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
            HeaderFooterManager headerFooterManager = TabAPI.getInstance().getHeaderFooterManager();
            if (tabPlayer != null && headerFooterManager != null) {
                headerFooterManager.setHeaderAndFooter(tabPlayer, header, footer);
            }
        } else {
            player.setPlayerListHeaderFooter(header, footer);
        }
    }

    private String formatTabListSection(List<String> lines, Player player, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData, TabEnvironmentSnapshot snapshot) {
        if (lines == null || lines.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            String processed = this.formatTabListText(line == null ? "" : line, player, status, coloredPlayerName, countryData, snapshot);
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(processed);
        }
        return builder.toString();
    }

    private String formatTabListText(String template, Player player, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData, TabEnvironmentSnapshot snapshot) {
        return this.applyTabListPlaceholders(template, player, status, coloredPlayerName, countryData, snapshot, true);
    }

    private String sanitizeDisplayNameOccurrences(String message, Player player) {
        String strippedDisplay;
        if (message == null || player == null) {
            return message;
        }
        String displayName = player.getDisplayName();
        String realName = player.getName();
        if (displayName != null && !displayName.equals(realName)) {
            message = message.replace(displayName, realName);
        }
        String string = strippedDisplay = displayName != null ? ChatColor.stripColor((String)displayName) : null;
        if (strippedDisplay != null && !strippedDisplay.equals(realName)) {
            message = message.replace(strippedDisplay, realName);
        }
        return message;
    }

    private String applyTabListPlaceholders(String template, Player player, String status, String coloredPlayerName, CountryLocationManager.CountryData countryData, TabEnvironmentSnapshot snapshot, boolean includeRotatingToken) {
        if (template == null) {
            return "";
        }
        String result = template.replace("$$PLAYER$$", coloredPlayerName).replace("%status%", status).replace("%deaths%", String.valueOf(this.getPlayerDeaths(player.getUniqueId()))).replace("%online_players%", String.valueOf(snapshot.onlinePlayers)).replace("%max_players%", String.valueOf(snapshot.maxPlayers)).replace("%overworld_players%", String.valueOf(snapshot.overworldPlayers)).replace("%nether_players%", String.valueOf(snapshot.netherPlayers)).replace("%end_players%", String.valueOf(snapshot.endPlayers)).replace("%server_time%", snapshot.serverTime).replace("%time%", snapshot.serverTime).replace("%tps%", snapshot.tps1m).replace("%tps_1m%", snapshot.tps1m).replace("%tps_5m%", snapshot.tps5m).replace("%tps_15m%", snapshot.tps15m).replace("%mspt%", snapshot.mspt).replace("%performance%", snapshot.performanceLabel).replace("%performance_label%", snapshot.performanceLabel).replace("%total_deaths%", snapshot.totalDeathsShort).replace("%total_deaths_raw%", String.valueOf(snapshot.totalDeathsRaw));
        result = this.replaceCountryPlaceholders(result, countryData);
        if (includeRotatingToken && result.contains("%rotating_line%")) {
            String rotatingLine = "";
            if (!this.tabListRotatingLines.isEmpty()) {
                String rotatingTemplate = this.tabListRotatingLines.get(this.rotatingLineIndex % this.tabListRotatingLines.size());
                rotatingLine = this.applyTabListPlaceholders(rotatingTemplate, player, status, coloredPlayerName, countryData, snapshot, false);
            }
            result = result.replace("%rotating_line%", rotatingLine);
        } else if (!includeRotatingToken) {
            result = result.replace("%rotating_line%", "");
        }
        return result;
    }

    private int countPlayersInEnvironment(World.Environment environment) {
        int total = 0;
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != environment) continue;
            total += world.getPlayers().size();
        }
        return total;
    }

    private void detectMiniMessageSupport() {
        this.getLogger().info("========================================");
        this.getLogger().info("[StatusPlugin] MiniMessage support DISABLED.");
        this.getLogger().info("[StatusPlugin] Using legacy & color codes only for all formats.");
        this.getLogger().info("[StatusPlugin] Update your status-options.yml to remove MiniMessage tags if present.");
        this.getLogger().info("========================================");
    }

    private void detectTpsFetchingMethod() {
        boolean hasPaperTps = false;
        boolean hasPaperMspt = false;
        try {
            Method getTpsMethod = Bukkit.class.getMethod("getTPS", new Class[0]);
            double[] tps = (double[])getTpsMethod.invoke(null, new Object[0]);
            if (tps != null && tps.length >= 3) {
                hasPaperTps = true;
            }
        }
        catch (NoSuchMethodException getTpsMethod) {
        }
        catch (Exception e) {
            this.getLogger().warning("Paper getTPS() available but failed: " + e.getMessage());
        }
        try {
            Method getAverageMsptMethod = Bukkit.class.getMethod("getAverageTickTime", new Class[0]);
            Double mspt = (Double)getAverageMsptMethod.invoke(null, new Object[0]);
            if (mspt != null) {
                hasPaperMspt = true;
            }
        }
        catch (NoSuchMethodException getAverageMsptMethod) {
        }
        catch (Exception e) {
            this.getLogger().warning("Paper getAverageTickTime() available but failed: " + e.getMessage());
        }
        if (hasPaperTps || hasPaperMspt) {
            this.getLogger().info("========================================");
            this.getLogger().info("[StatusPlugin] Paper API DETECTED!");
            if (hasPaperTps) {
                this.getLogger().info("[StatusPlugin] \u2713 TPS: Using Paper's native getTPS() method");
            }
            if (hasPaperMspt) {
                this.getLogger().info("[StatusPlugin] \u2713 MSPT: Using Paper's native getAverageTickTime() method");
            }
            this.getLogger().info("[StatusPlugin] All performance metrics fully supported");
            this.getLogger().info("========================================");
            return;
        }
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]);
            Object dedicatedServer = method.invoke((Object)Bukkit.getServer(), new Object[0]);
            Field recentTpsField = dedicatedServer.getClass().getField("recentTps");
            recentTpsField.setAccessible(true);
            double[] values2 = (double[])recentTpsField.get(dedicatedServer);
            if (values2 != null) {
                this.getLogger().info("========================================");
                this.getLogger().info("[StatusPlugin] Spigot TPS detection active");
                this.getLogger().info("[StatusPlugin] \u2713 TPS: Using reflection method");
                this.getLogger().info("[StatusPlugin] \u26a0 MSPT: Not available (Paper-only feature)");
                this.getLogger().info("[StatusPlugin] TPS metrics available, MSPT will show N/A");
                this.getLogger().info("========================================");
                return;
            }
        }
        catch (ClassCastException | ReflectiveOperationException exception) {
            // empty catch block
        }
        this.getLogger().warning("========================================");
        this.getLogger().warning("[StatusPlugin] WARNING: Could not detect TPS!");
        this.getLogger().warning("[StatusPlugin] TPS, MSPT and performance metrics will show as UNKNOWN");
        this.getLogger().warning("[StatusPlugin] This may indicate an incompatible server version");
        this.getLogger().warning("========================================");
    }

    private double[] fetchRecentTps() {
        try {
            Method getTpsMethod = Bukkit.class.getMethod("getTPS", new Class[0]);
            double[] tps = (double[])getTpsMethod.invoke(null, new Object[0]);
            if (tps != null && tps.length >= 3) {
                return (double[])tps.clone();
            }
        }
        catch (NoSuchMethodException getTpsMethod) {
        }
        catch (Exception getTpsMethod) {
            // empty catch block
        }
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]);
            Object dedicatedServer = method.invoke((Object)Bukkit.getServer(), new Object[0]);
            Field recentTpsField = dedicatedServer.getClass().getField("recentTps");
            recentTpsField.setAccessible(true);
            double[] values2 = (double[])recentTpsField.get(dedicatedServer);
            return values2 != null ? (double[])values2.clone() : null;
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            return null;
        }
    }

    private String fetchMspt() {
        try {
            Method getAverageMsptMethod = Bukkit.class.getMethod("getAverageTickTime", new Class[0]);
            Double mspt = (Double)getAverageMsptMethod.invoke(null, new Object[0]);
            if (mspt != null && mspt >= 0.0) {
                return String.format(Locale.US, "%.2f", mspt);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PLACEHOLDER_NOT_AVAILABLE;
    }

    private String getCurrentServerTime() {
        return LocalTime.now().format(TABLIST_TIME_FORMAT);
    }

    private static String formatTpsValue(double[] values2, int index) {
        if (values2 != null && index >= 0 && index < values2.length) {
            double value = Math.min(values2[index], 20.0);
            return String.format(Locale.US, "%.2f", value);
        }
        return PLACEHOLDER_NOT_AVAILABLE;
    }

    private String formatLargeNumber(long value) {
        long absValue = Math.abs(value);
        if (absValue >= 1000000000L) {
            return this.formatWithSuffix(value, 1000000000L, "b");
        }
        if (absValue >= 1000000L) {
            return this.formatWithSuffix(value, 1000000L, "m");
        }
        if (absValue >= 1000L) {
            return this.formatWithSuffix(value, 1000L, "k");
        }
        return String.valueOf(value);
    }

    private String formatWithSuffix(long value, long divisor, String suffix) {
        String formatted;
        double scaled = (double)value / (double)divisor;
        String string = formatted = Math.abs(scaled) >= 100.0 ? String.format(Locale.US, "%.0f", scaled) : String.format(Locale.US, "%.1f", scaled);
        if (formatted.endsWith(".0")) {
            formatted = formatted.substring(0, formatted.length() - 2);
        }
        return formatted + suffix;
    }

    private String replaceCountryPlaceholders(String text, CountryLocationManager.CountryData countryData) {
        if (text == null) {
            return "";
        }
        if (countryData != null) {
            text = text.replace("%country%", countryData.getCountry());
            text = text.replace("%countrycode%", countryData.getCountryCode());
        } else {
            text = text.replace("%country%", "");
            text = text.replace("%countrycode%", "");
        }
        return text;
    }

    private void initializeLibertyBans() {
        Plugin libertyBansPlugin = Bukkit.getPluginManager().getPlugin("LibertyBans");
        this.libertyBansIntegration = null;
        if (libertyBansPlugin == null || !libertyBansPlugin.isEnabled()) {
            this.isLibertyBansPresent = false;
            return;
        }
        try {
            this.libertyBansIntegration = LibertyBansIntegration.tryCreate(this);
            if (this.libertyBansIntegration != null) {
                this.isLibertyBansPresent = true;
                this.getLogger().info("========================================");
                this.getLogger().info("[StatusPlugin] LibertyBans DETECTED!");
                this.getLogger().info("[StatusPlugin] Mute checking is now ACTIVE");
                this.getLogger().info("[StatusPlugin] Muted players will be blocked from chat");
                this.getLogger().info("========================================");
            } else {
                this.isLibertyBansPresent = false;
                this.getLogger().warning("[StatusPlugin] LibertyBans is installed but API could not be initialized.");
            }
        }
        catch (Exception e) {
            this.isLibertyBansPresent = false;
            this.getLogger().log(Level.SEVERE, "[StatusPlugin] Failed to initialize LibertyBans API: " + e.getMessage(), e);
        }
        if (!this.isLibertyBansPresent) {
            this.libertyBansIntegration = null;
        }
    }

    private void sendMuteNotification(Player player, MuteInfo muteInfo) {
        try {
            Instant end;
            String muteTitle = this.getLanguageText(player, "mute_title", "&c&lYOU ARE MUTED!");
            String muteWithReason = this.getLanguageText(player, "mute_with_reason", "&7Reason: &f%reason%");
            String muteDurationTemporary = this.getLanguageText(player, "mute_duration_temporary", "&7Duration: &e%duration%");
            String muteDurationPermanent = this.getLanguageText(player, "mute_duration_permanent", "&7Duration: &4&lPERMANENT");
            String muteDurationExpiring = this.getLanguageText(player, "mute_duration_expiring", "&7Duration: &eExpiring soon...");
            StringBuilder message = new StringBuilder();
            message.append(ColorParser.parse(muteTitle)).append("\n");
            String reason = muteInfo.getReason();
            if (reason != null && !reason.isEmpty()) {
                String reasonLine = muteWithReason.replace("%reason%", reason);
                message.append(ColorParser.parse(reasonLine)).append("\n");
            }
            if ((end = muteInfo.getEnd()) == null) {
                message.append(ColorParser.parse(muteDurationPermanent));
            } else {
                Duration remaining = Duration.between(Instant.now(), end);
                long fiveYearsInDays = 1825L;
                if (remaining.toDays() > fiveYearsInDays) {
                    message.append(ColorParser.parse(muteDurationPermanent));
                } else if (remaining.isNegative() || remaining.isZero()) {
                    message.append(ColorParser.parse(muteDurationExpiring));
                } else {
                    String durationLine = muteDurationTemporary.replace("%duration%", this.formatDuration(remaining));
                    message.append(ColorParser.parse(durationLine));
                }
            }
            player.sendMessage(message.toString());
        }
        catch (Exception e) {
            String fallback = this.getLanguageText(player, "mute_fallback", "&cYou are currently muted and cannot send messages.");
            player.sendMessage(ColorParser.parse(fallback));
            this.getLogger().warning("[StatusPlugin] Error sending mute notification: " + e.getMessage());
        }
    }

    private String formatDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        StringBuilder result = new StringBuilder();
        if (days > 0L) {
            result.append(days).append("d ");
        }
        if (hours > 0L) {
            result.append(hours).append("h ");
        }
        if (minutes > 0L) {
            result.append(minutes).append("m ");
        }
        if (days == 0L && hours == 0L && minutes == 0L) {
            result.append(seconds).append("s");
        }
        return result.toString().trim();
    }

    private void reloadPlugin() {
        this.persistServerStats(true);
        this.stopTabRefreshSchedulers();
        this.reloadConfig();
        this.updateConfigIfNeeded();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
        this.loadPlayerDeathsConfig();
        this.loadServerStatsConfig();
        this.loadPlayerStatuses();
        this.loadPlayerDeaths();
        this.refreshDimensionCache();
        this.startTabRefreshSchedulers();
        if (this.nametagManager != null) {
            boolean sortEnabled = this.getConfig().getBoolean("tab-list-sort-by-status", true);
            this.nametagManager.updateSettings(this.nametagStatusEnabled, sortEnabled);
            this.nametagManager.scheduleInitialization();
            this.nametagManager.updateAllPlayerTeams();
        }
        this.updatePlayerTabList();
    }

    private static final class TabEnvironmentSnapshot {
        private final boolean tabStylingEnabled;
        private final boolean countryPlaceholdersEnabled;
        private final String serverTime;
        private final int overworldPlayers;
        private final int netherPlayers;
        private final int endPlayers;
        private final int onlinePlayers;
        private final int maxPlayers;
        private final String tps1m;
        private final String tps5m;
        private final String tps15m;
        private final String mspt;
        private final String performanceLabel;
        private final long totalDeathsRaw;
        private final String totalDeathsShort;

        private TabEnvironmentSnapshot(boolean tabStylingEnabled, boolean countryPlaceholdersEnabled, String serverTime, int overworldPlayers, int netherPlayers, int endPlayers, int onlinePlayers, int maxPlayers, String tps1m, String tps5m, String tps15m, String mspt, String performanceLabel, long totalDeathsRaw, String totalDeathsShort) {
            this.tabStylingEnabled = tabStylingEnabled;
            this.countryPlaceholdersEnabled = countryPlaceholdersEnabled;
            this.serverTime = serverTime;
            this.overworldPlayers = overworldPlayers;
            this.netherPlayers = netherPlayers;
            this.endPlayers = endPlayers;
            this.onlinePlayers = onlinePlayers;
            this.maxPlayers = maxPlayers;
            this.tps1m = tps1m;
            this.tps5m = tps5m;
            this.tps15m = tps15m;
            this.mspt = mspt;
            this.performanceLabel = performanceLabel;
            this.totalDeathsRaw = totalDeathsRaw;
            this.totalDeathsShort = totalDeathsShort;
        }

        private static TabEnvironmentSnapshot capture(StatusPlugin plugin) {
            return TabEnvironmentSnapshot.capture(plugin, null);
        }

        private static TabEnvironmentSnapshot capture(StatusPlugin plugin, double[] tpsValues) {
            boolean tabStylingEnabled = plugin.getConfig().getBoolean("tab-styling-enabled", true);
            boolean countryEnabled = plugin.getConfig().getBoolean("country-location-enabled", false) && plugin.countryLocationManager != null;
            double[] resolvedTps = tpsValues != null ? tpsValues : plugin.fetchRecentTps();
            return new TabEnvironmentSnapshot(tabStylingEnabled, countryEnabled, plugin.getCurrentServerTime(), plugin.cachedOverworldPlayers, plugin.cachedNetherPlayers, plugin.cachedEndPlayers, Bukkit.getOnlinePlayers().size(), Bukkit.getMaxPlayers(), StatusPlugin.formatTpsValue(resolvedTps, 0), StatusPlugin.formatTpsValue(resolvedTps, 1), StatusPlugin.formatTpsValue(resolvedTps, 2), plugin.cachedMspt, plugin.cachedPerformanceLabel, plugin.totalTrackedDeaths, plugin.formatLargeNumber(plugin.totalTrackedDeaths));
        }
    }

    private static final class LibertyBansIntegration {
        private final StatusPlugin plugin;
        private final Object libertyBansApi;
        private final Object mutePunishmentType;
        private final Method getSelectorMethod;
        private final Method getReasonMethod;
        private final Method getEndDateMethod;
        private final Class<?> punishmentTypeClass;
        private boolean loggedError;

        private LibertyBansIntegration(StatusPlugin plugin, Object libertyBansApi, Object mutePunishmentType, Method getSelectorMethod, Method getReasonMethod, Method getEndDateMethod, Class<?> punishmentTypeClass) {
            this.plugin = plugin;
            this.libertyBansApi = libertyBansApi;
            this.mutePunishmentType = mutePunishmentType;
            this.getSelectorMethod = getSelectorMethod;
            this.getReasonMethod = getReasonMethod;
            this.getEndDateMethod = getEndDateMethod;
            this.punishmentTypeClass = punishmentTypeClass;
        }

        private static LibertyBansIntegration tryCreate(StatusPlugin plugin) throws Exception {
            Class<?> omnibusProviderClass = Class.forName("space.arim.omnibus.OmnibusProvider");
            Method getOmnibusMethod = omnibusProviderClass.getMethod("getOmnibus", new Class[0]);
            Object omnibus = getOmnibusMethod.invoke(null, new Object[0]);
            if (omnibus == null) {
                return null;
            }
            Method getRegistryMethod = omnibus.getClass().getMethod("getRegistry", new Class[0]);
            Object registry = getRegistryMethod.invoke(omnibus, new Object[0]);
            if (registry == null) {
                return null;
            }
            Class<?> libertyBansClass = Class.forName("space.arim.libertybans.api.LibertyBans");
            Method getProviderMethod = registry.getClass().getMethod("getProvider", Class.class);
            Optional libertyBansOptional = (Optional)getProviderMethod.invoke(registry, libertyBansClass);
            Object libertyBansApi = libertyBansOptional.orElse(null);
            if (libertyBansApi == null) {
                return null;
            }
            Method getSelectorMethod = libertyBansClass.getMethod("getSelector", new Class[0]);
            Class<?> punishmentTypeClass = Class.forName("space.arim.libertybans.api.PunishmentType");
            Method valueOfMethod = punishmentTypeClass.getMethod("valueOf", String.class);
            Object muteType = valueOfMethod.invoke(null, "MUTE");
            Class<?> punishmentClass = Class.forName("space.arim.libertybans.api.punish.Punishment");
            Method getReasonMethod = punishmentClass.getMethod("getReason", new Class[0]);
            Method getEndDateMethod = punishmentClass.getMethod("getEndDate", new Class[0]);
            return new LibertyBansIntegration(plugin, libertyBansApi, muteType, getSelectorMethod, getReasonMethod, getEndDateMethod, punishmentTypeClass);
        }

        private Optional<MuteInfo> getActiveMute(Player player) {
            if (player == null) {
                return Optional.empty();
            }
            try {
                InetAddress inetAddress;
                Object selector = this.getSelectorMethod.invoke(this.libertyBansApi, new Object[0]);
                if (selector == null) {
                    return Optional.empty();
                }
                InetAddress inetAddress2 = inetAddress = player.getAddress() != null ? player.getAddress().getAddress() : null;
                if (inetAddress == null) {
                    return Optional.empty();
                }
                Method builderMethod = selector.getClass().getMethod("selectionByApplicabilityBuilder", UUID.class, InetAddress.class);
                Object builder = builderMethod.invoke(selector, player.getUniqueId(), inetAddress);
                if (builder == null) {
                    return Optional.empty();
                }
                Method typeMethod = builder.getClass().getMethod("type", this.punishmentTypeClass);
                typeMethod.invoke(builder, this.mutePunishmentType);
                Method buildMethod = builder.getClass().getMethod("build", new Class[0]);
                Object selection = buildMethod.invoke(builder, new Object[0]);
                if (selection == null) {
                    return Optional.empty();
                }
                Method firstSpecificMethod = selection.getClass().getMethod("getFirstSpecificPunishment", new Class[0]);
                Object stageObj = firstSpecificMethod.invoke(selection, new Object[0]);
                if (!(stageObj instanceof CompletionStage)) {
                    return Optional.empty();
                }
                CompletionStage stage = (CompletionStage)stageObj;
                Optional optional = (Optional)stage.toCompletableFuture().join();
                if (optional == null || !optional.isPresent()) {
                    return Optional.empty();
                }
                Object punishment = optional.get();
                String reason = null;
                try {
                    Object reasonObj = this.getReasonMethod.invoke(punishment, new Object[0]);
                    if (reasonObj instanceof String) {
                        reason = (String)reasonObj;
                    }
                }
                catch (Exception reasonObj) {
                    // empty catch block
                }
                Instant end = null;
                try {
                    Object endObj = this.getEndDateMethod.invoke(punishment, new Object[0]);
                    if (endObj instanceof Instant) {
                        end = (Instant)endObj;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Optional.of(new MuteInfo(reason, end));
            }
            catch (Exception ex) {
                if (!this.loggedError) {
                    this.loggedError = true;
                    this.plugin.getLogger().log(Level.WARNING, "[StatusPlugin] Error checking LibertyBans mute status: " + ex.getMessage(), ex);
                }
                return Optional.empty();
            }
        }
    }

    private static final class MuteInfo {
        private final String reason;
        private final Instant end;

        private MuteInfo(String reason, Instant end) {
            this.reason = reason;
            this.end = end;
        }

        private String getReason() {
            return this.reason;
        }

        private Instant getEnd() {
            return this.end;
        }
    }
}

