/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin.nametag;

import de.stylelabor.statusplugin.ColorParser;
import de.stylelabor.statusplugin.StatusPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class StatusNametagManager {
    private static final int SCOREBOARD_TEXT_LIMIT = 256;
    private final StatusPlugin plugin;
    private final Map<String, Team> statusTeams = new HashMap<String, Team>();
    private Scoreboard sortingScoreboard;
    private boolean nametagEnabled;
    private boolean sortEnabled;

    public StatusNametagManager(StatusPlugin plugin) {
        this.plugin = plugin;
    }

    public void updateSettings(boolean nametagEnabled, boolean sortEnabled) {
        this.nametagEnabled = nametagEnabled;
        this.sortEnabled = sortEnabled;
        if (this.isActive()) {
            this.ensureScoreboardInitialized(true);
        } else {
            this.clearStatusTeams();
            this.statusTeams.clear();
            this.sortingScoreboard = null;
        }
    }

    public boolean isActive() {
        return this.nametagEnabled || this.sortEnabled;
    }

    public boolean isNametagEnabled() {
        return this.nametagEnabled;
    }

    public void scheduleInitialization() {
        if (!this.isActive()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.ensureScoreboardInitialized(false)) {
                this.updateAllPlayerTeams();
            }
        });
    }

    public void assignPlayer(Player player) {
        if (!this.isActive() || player == null) {
            return;
        }
        if (!this.ensureScoreboardInitialized(false)) {
            return;
        }
        try {
            String statusValue;
            String statusKey;
            Team team;
            Team currentTeam = this.sortingScoreboard.getEntryTeam(player.getName());
            if (currentTeam != null) {
                currentTeam.removeEntry(player.getName());
            }
            if ((team = this.getOrCreateStatusTeam(statusKey = this.plugin.getStatusKeyFromValue(statusValue = this.plugin.getPlayerStatus(player.getUniqueId())))) == null) {
                return;
            }
            team.addEntry(player.getName());
            if (this.nametagEnabled) {
                String prefix = this.buildTeamPrefix(statusValue);
                this.applyTeamFormatting(team, prefix, statusValue);
            } else {
                team.setPrefix("");
                team.setSuffix("");
            }
            if (player.getScoreboard() != this.sortingScoreboard) {
                player.setScoreboard(this.sortingScoreboard);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to assign player " + player.getName() + " to status team: " + e.getMessage());
        }
    }

    public void updateAllPlayerTeams() {
        if (!this.isActive()) {
            return;
        }
        if (!this.ensureScoreboardInitialized(false)) {
            return;
        }
        for (Player online : Bukkit.getOnlinePlayers()) {
            this.assignPlayer(online);
        }
    }

    public void tearDown() {
        this.clearStatusTeams();
        this.statusTeams.clear();
        this.sortingScoreboard = null;
    }

    private boolean ensureScoreboardInitialized(boolean logNotReady) {
        if (!this.isActive()) {
            return false;
        }
        if (this.sortingScoreboard != null) {
            return true;
        }
        if (Bukkit.getScoreboardManager() == null) {
            if (logNotReady) {
                this.plugin.getLogger().warning("ScoreboardManager is not available yet. Status sorting will be disabled temporarily.");
            }
            return false;
        }
        this.sortingScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        this.statusTeams.clear();
        return true;
    }

    private Team getOrCreateStatusTeam(String statusKey) {
        if (this.sortingScoreboard == null) {
            return null;
        }
        String teamName = this.getTeamNameForStatus(statusKey);
        Team team = this.statusTeams.get(teamName);
        if (team != null) {
            return team;
        }
        team = this.sortingScoreboard.getTeam(teamName);
        if (team == null) {
            try {
                team = this.sortingScoreboard.registerNewTeam(teamName);
            }
            catch (IllegalArgumentException ignored) {
                team = this.sortingScoreboard.getTeam(teamName);
            }
        }
        if (team != null) {
            this.statusTeams.put(teamName, team);
        }
        return team;
    }

    private String getTeamNameForStatus(String statusKey) {
        String upperKey;
        if (statusKey == null || statusKey.isEmpty()) {
            return "z_nostatus";
        }
        switch (upperKey = statusKey.toUpperCase(Locale.ROOT)) {
            case "ADMIN": {
                return "0_admin";
            }
            case "MOD": {
                return "1_mod";
            }
            case "AFK": {
                return "9_afk";
            }
            case "CAM": {
                return "9_cam";
            }
        }
        return "2_" + statusKey.toLowerCase(Locale.ROOT);
    }

    private String buildTeamPrefix(String status) {
        if (status == null || status.isEmpty()) {
            return "";
        }
        String colored = ColorParser.parse(status);
        if (colored == null || colored.isEmpty()) {
            return "";
        }
        String withSpace = colored + ChatColor.RESET + " ";
        return withSpace;
    }

    private void applyTeamFormatting(Team team, String prefix, String originalStatus) {
        String safePrefix;
        String decorated = safePrefix = prefix == null ? "" : prefix;
        NametagParts parts = this.splitForScoreboard(decorated);
        try {
            team.setPrefix(parts.prefix());
        }
        catch (IllegalArgumentException ex) {
            String fallback = ColorParser.parse(originalStatus == null ? "" : originalStatus);
            fallback = ChatColor.stripColor((String)(fallback == null ? "" : fallback));
            if (fallback == null) {
                fallback = "";
            }
            fallback = this.trimPlainText(fallback + " ", 64);
            team.setPrefix(fallback);
            team.setSuffix(ChatColor.RESET.toString());
            return;
        }
        try {
            team.setSuffix(parts.suffix());
        }
        catch (IllegalArgumentException ex) {
            team.setSuffix(ChatColor.RESET.toString());
        }
    }

    private String trimPlainText(String value, int limit) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return value.length() <= limit ? value : value.substring(0, limit);
    }

    private NametagParts splitForScoreboard(String text) {
        if (text == null) {
            return new NametagParts("", ChatColor.RESET.toString());
        }
        if (text.length() <= 256) {
            return new NametagParts(text, ChatColor.RESET.toString());
        }
        StringBuilder prefixBuilder = new StringBuilder(256);
        int index = 0;
        while (index < text.length() && prefixBuilder.length() < 256) {
            char current = text.charAt(index++);
            prefixBuilder.append(current);
            if (current != '\u00a7' || index >= text.length()) continue;
            char next = text.charAt(index++);
            prefixBuilder.append(next);
        }
        if (prefixBuilder.length() > 0 && prefixBuilder.charAt(prefixBuilder.length() - 1) == '\u00a7') {
            prefixBuilder.deleteCharAt(prefixBuilder.length() - 1);
            --index;
        }
        String prefix = prefixBuilder.toString();
        String remaining = index < text.length() ? text.substring(index) : "";
        String activeColors = ChatColor.getLastColors((String)prefix);
        String suffix = (activeColors == null ? "" : activeColors) + remaining + ChatColor.RESET;
        return new NametagParts(prefix, suffix);
    }

    private void clearStatusTeams() {
        if (this.sortingScoreboard == null || this.statusTeams.isEmpty()) {
            return;
        }
        for (Team team : new HashSet<Team>(this.statusTeams.values())) {
            if (team == null) continue;
            for (String entry : new HashSet(team.getEntries())) {
                team.removeEntry(entry);
            }
            team.setPrefix("");
            team.setSuffix("");
        }
    }

    private static final class NametagParts {
        private final String prefix;
        private final String suffix;

        private NametagParts(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        private String prefix() {
            return this.prefix;
        }

        private String suffix() {
            return this.suffix;
        }
    }
}

