/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.lib.kyori.adventure.text.minimessage.tag.standard;

import de.stylelabor.lib.kyori.adventure.text.Component;
import de.stylelabor.lib.kyori.adventure.text.TranslatableComponent;
import de.stylelabor.lib.kyori.adventure.text.TranslationArgument;
import de.stylelabor.lib.kyori.adventure.text.minimessage.Context;
import de.stylelabor.lib.kyori.adventure.text.minimessage.ParsingException;
import de.stylelabor.lib.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import de.stylelabor.lib.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import de.stylelabor.lib.kyori.adventure.text.minimessage.tag.Tag;
import de.stylelabor.lib.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import de.stylelabor.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import de.stylelabor.lib.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class TranslatableTag {
    private static final String TR = "tr";
    private static final String TRANSLATE = "translate";
    private static final String LANG = "lang";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("lang", "translate", "tr"), TranslatableTag::create, TranslatableTag::claim);

    private TranslatableTag() {
    }

    static Tag create(ArgumentQueue args2, Context ctx) throws ParsingException {
        List with;
        String key = args2.popOr("A translation key is required").value();
        if (args2.hasNext()) {
            with = new ArrayList();
            while (args2.hasNext()) {
                with.add(ctx.deserialize(args2.pop().value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return Tag.inserting(Component.translatable(key, with));
    }

    @Nullable
    static Emitable claim(Component input) {
        if (!(input instanceof TranslatableComponent) || ((TranslatableComponent)input).fallback() != null) {
            return null;
        }
        TranslatableComponent tr = (TranslatableComponent)input;
        return emit -> {
            emit.tag(LANG);
            emit.argument(tr.key());
            for (TranslationArgument with : tr.arguments()) {
                emit.argument(with.asComponent());
            }
        };
    }
}

