/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin;

import de.stylelabor.statusplugin.ColorParser;
import de.stylelabor.statusplugin.CountryLocationManager;
import de.stylelabor.statusplugin.StatusPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class StatusPlaceholder
extends PlaceholderExpansion {
    private final StatusPlugin plugin;

    public StatusPlaceholder(StatusPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "statusplugin";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        if (identifier.equals("status")) {
            String status = this.plugin.getPlayerStatus(player.getUniqueId());
            return ColorParser.parse(status);
        }
        if (identifier.equals("country")) {
            if (!this.plugin.getConfig().getBoolean("country-location-enabled", false)) {
                return "";
            }
            CountryLocationManager countryManager = this.plugin.getCountryLocationManager();
            if (countryManager == null) {
                return "";
            }
            CountryLocationManager.CountryData countryData = countryManager.getPlayerCountry(player.getUniqueId());
            return countryData != null ? countryData.getCountry() : "";
        }
        if (identifier.equals("countrycode")) {
            if (!this.plugin.getConfig().getBoolean("country-location-enabled", false)) {
                return "";
            }
            CountryLocationManager countryManager = this.plugin.getCountryLocationManager();
            if (countryManager == null) {
                return "";
            }
            CountryLocationManager.CountryData countryData = countryManager.getPlayerCountry(player.getUniqueId());
            return countryData != null ? countryData.getCountryCode() : "";
        }
        if (identifier.equals("deaths")) {
            return String.valueOf(this.plugin.getPlayerDeaths(player.getUniqueId()));
        }
        if (identifier.equalsIgnoreCase("performance") || identifier.equalsIgnoreCase("performance_label")) {
            return this.plugin.getPerformanceLabel();
        }
        if (identifier.equalsIgnoreCase("mspt")) {
            return this.plugin.getMspt();
        }
        if (identifier.equalsIgnoreCase("total_deaths")) {
            return this.plugin.getFormattedTotalTrackedDeaths();
        }
        if (identifier.equalsIgnoreCase("total_deaths_raw")) {
            return String.valueOf(this.plugin.getTotalTrackedDeaths());
        }
        return null;
    }
}

