/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin;

import de.stylelabor.statusplugin.StatusPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.json.JSONObject;

public class CountryLocationManager {
    private final StatusPlugin plugin;
    private final OkHttpClient httpClient;
    private final Map<UUID, CountryData> playerCountries;
    private File countriesFile;
    private FileConfiguration countriesConfig;

    public CountryLocationManager(StatusPlugin plugin) {
        this.plugin = plugin;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
        this.playerCountries = new HashMap<UUID, CountryData>();
        this.loadCountriesConfig();
        this.loadPlayerCountries();
    }

    public CompletableFuture<CountryData> getPlayerCountryAsync(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.playerCountries.containsKey(playerUUID)) {
            return CompletableFuture.completedFuture(this.playerCountries.get(playerUUID));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                String playerIP = player.getAddress().getAddress().getHostAddress();
                return this.fetchCountryFromAPI(playerIP);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to get IP for player " + player.getName() + ": " + e.getMessage());
                return null;
            }
        }).thenApply(countryData -> {
            if (countryData != null) {
                this.playerCountries.put(playerUUID, (CountryData)countryData);
                this.savePlayerCountry(playerUUID, (CountryData)countryData);
                this.plugin.getLogger().info("Country data fetched and saved for player " + player.getName() + ": " + countryData.getCountry() + " (" + countryData.getCountryCode() + ")");
            }
            return countryData;
        });
    }

    public CountryData getPlayerCountry(UUID playerUUID) {
        return this.playerCountries.get(playerUUID);
    }

    private CountryData fetchCountryFromAPI(String ip) {
        CountryData countryData = this.tryPrimaryAPI(ip);
        if (countryData != null) {
            return countryData;
        }
        countryData = this.tryFallbackAPI(ip);
        if (countryData != null) {
            return countryData;
        }
        this.plugin.getLogger().warning("Failed to fetch country data for IP: " + ip);
        return null;
    }

    private CountryData tryPrimaryAPI(String ip) {
        try {
            String url = "http://ip-api.com/json/" + ip;
            Request request = new Request.Builder().url(url).build();
            Throwable throwable = null;
            Object var5_7 = null;
            try (Response response = this.httpClient.newCall(request).execute();){
                String jsonResponse;
                JSONObject json;
                if (response.isSuccessful() && response.body() != null && (json = new JSONObject(jsonResponse = response.body().string())).getString("status").equals("success")) {
                    String country = json.getString("country");
                    String countryCode = json.getString("countryCode");
                    return new CountryData(country, countryCode);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Primary API (ip-api.com) failed: " + e.getMessage());
        }
        return null;
    }

    private CountryData tryFallbackAPI(String ip) {
        try {
            String url = "https://api.iplocation.net/?ip=" + ip;
            Request request = new Request.Builder().url(url).build();
            Throwable throwable = null;
            Object var5_7 = null;
            try (Response response = this.httpClient.newCall(request).execute();){
                String jsonResponse;
                JSONObject json;
                if (response.isSuccessful() && response.body() != null && (json = new JSONObject(jsonResponse = response.body().string())).getString("response_code").equals("200")) {
                    String country = json.getString("country_name");
                    String countryCode = json.getString("country_code2");
                    return new CountryData(country, countryCode);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Fallback API (api.iplocation.net) failed: " + e.getMessage());
        }
        return null;
    }

    private void loadCountriesConfig() {
        this.countriesFile = new File(this.plugin.getDataFolder(), "player-countries.yml");
        if (!this.countriesFile.exists()) {
            try {
                if (this.countriesFile.createNewFile()) {
                    this.plugin.getLogger().info("player-countries.yml file created.");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to create player-countries.yml: " + e.getMessage());
            }
        }
        this.countriesConfig = YamlConfiguration.loadConfiguration((File)this.countriesFile);
    }

    private void loadPlayerCountries() {
        for (String uuidString : this.countriesConfig.getKeys(false)) {
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                String country = this.countriesConfig.getString(String.valueOf(uuidString) + ".country");
                String countryCode = this.countriesConfig.getString(String.valueOf(uuidString) + ".countryCode");
                if (country == null || countryCode == null) continue;
                this.playerCountries.put(playerUUID, new CountryData(country, countryCode));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load country data for UUID " + uuidString + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Loaded country data for " + this.playerCountries.size() + " players.");
    }

    private void savePlayerCountry(UUID playerUUID, CountryData countryData) {
        String uuidString = playerUUID.toString();
        this.countriesConfig.set(String.valueOf(uuidString) + ".country", (Object)countryData.getCountry());
        this.countriesConfig.set(String.valueOf(uuidString) + ".countryCode", (Object)countryData.getCountryCode());
        try {
            this.countriesConfig.save(this.countriesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save country data for player " + playerUUID + ": " + e.getMessage());
        }
    }

    public void saveAllPlayerCountries() {
        for (Map.Entry<UUID, CountryData> entry : this.playerCountries.entrySet()) {
            this.savePlayerCountry(entry.getKey(), entry.getValue());
        }
    }

    public static class CountryData {
        private final String country;
        private final String countryCode;

        public CountryData(String country, String countryCode) {
            this.country = country;
            this.countryCode = countryCode;
        }

        public String getCountry() {
            return this.country;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String toString() {
            return String.valueOf(this.country) + " (" + this.countryCode + ")";
        }
    }
}

