/*
 * Decompiled with CFR 0.152.
 */
package de.stylelabor.statusplugin;

import de.stylelabor.bukkit.Metrics;
import de.stylelabor.statusplugin.CountryLocationManager;
import de.stylelabor.statusplugin.ModrinthVersionChecker;
import de.stylelabor.statusplugin.StatusPlaceholder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.tablist.TabListFormatManager;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class StatusPlugin
extends JavaPlugin
implements Listener,
TabCompleter {
    private final HashMap<UUID, String> playerStatusMap = new HashMap();
    private final HashMap<UUID, Integer> playerDeathMap = new HashMap();
    private String commandName;
    private String tabListFormat;
    private final HashMap<String, String> statusOptions = new HashMap();
    private FileConfiguration languageConfig;
    private FileConfiguration playerStatusConfig;
    private FileConfiguration playerDeathsConfig;
    private boolean isTabPluginPresent;
    private boolean useOnlyOneLanguage;
    private String defaultLanguage;
    private boolean isDiscordSrvPresent;
    private CountryLocationManager countryLocationManager;
    private static final ThreadLocal<Boolean> relayingToDiscord = ThreadLocal.withInitial(() -> false);

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
        this.loadPlayerDeathsConfig();
        this.loadPlayerStatuses();
        this.loadPlayerDeaths();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand(this.commandName)).setTabCompleter((TabCompleter)this);
        int pluginId = 20901;
        new Metrics(this, pluginId);
        this.isTabPluginPresent = Bukkit.getPluginManager().getPlugin("TAB") != null;
        boolean bl = this.isDiscordSrvPresent = Bukkit.getPluginManager().getPlugin("DiscordSRV") != null;
        if (this.isDiscordSrvPresent) {
            this.getLogger().info("[StatusPlugin] DiscordSRV detected. Enabling Discord relay features.");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new StatusPlaceholder(this).register();
            this.getLogger().info("PlaceholderAPI placeholder registered successfully.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholder registration skipped.");
        }
        ModrinthVersionChecker.checkVersion();
        if (this.getConfig().getBoolean("country-location-enabled", false)) {
            this.countryLocationManager = new CountryLocationManager(this);
            this.getLogger().info("Country location feature enabled. IP geolocation will be active.");
        } else {
            this.getLogger().info("Country location feature disabled. To enable, set country-location-enabled to true in config.yml");
        }
    }

    private void loadPlayerStatuses() {
        this.playerStatusMap.clear();
        for (String uuid : this.playerStatusConfig.getKeys(false)) {
            this.playerStatusMap.put(UUID.fromString(uuid), this.playerStatusConfig.getString(uuid));
        }
    }

    private void loadPlayerDeaths() {
        if (this.playerDeathsConfig == null) {
            return;
        }
        this.playerDeathMap.clear();
        for (String uuid : this.playerDeathsConfig.getKeys(false)) {
            this.playerDeathMap.put(UUID.fromString(uuid), this.playerDeathsConfig.getInt(uuid, 0));
        }
    }

    public void onDisable() {
        this.savePlayerStatusConfig();
        this.savePlayerDeathsConfig();
        if (this.countryLocationManager != null) {
            this.countryLocationManager.saveAllPlayerCountries();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args2) {
        if (command.getName().equalsIgnoreCase(this.commandName) && sender instanceof Player) {
            Player player = (Player)sender;
            if (this.getConfig().getBoolean("only-admin-change", false) && !player.hasPermission("statusplugin.admin")) {
                String message = this.getConfig().getString("only-admin-change-message", "&cOnly admins can change statuses.");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                return true;
            }
            if (args2.length <= 0) {
                this.playerStatusMap.remove(player.getUniqueId());
                String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                this.updatePlayerTabList();
                this.playerStatusConfig.set(player.getUniqueId().toString(), null);
                this.savePlayerStatusConfig();
                return true;
            }
            String status = this.statusOptions.get(args2[0].toUpperCase());
            if (status != null) {
                this.playerStatusMap.put(player.getUniqueId(), status);
                String message = this.getLanguageText(player, "status_set", "&aYour status has been set to: &r%s");
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, status)));
                this.updatePlayerTabList();
                this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)status);
                this.savePlayerStatusConfig();
                return true;
            }
            String message = this.getLanguageText(player, "invalid_status", "&cInvalid status option. Use /status <option>");
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            return true;
        }
        if (command.getName().equalsIgnoreCase("reloadstatus") && (sender.isOp() || sender.hasPermission("statusplugin.reload"))) {
            this.reloadPlugin();
            sender.sendMessage(ChatColor.GREEN + "StatusPlugin configuration reloaded!");
            return true;
        }
        if (command.getName().equalsIgnoreCase("status-clear") && sender instanceof Player) {
            Player player = (Player)sender;
            this.playerStatusMap.remove(player.getUniqueId());
            String message = this.getLanguageText(player, "status_cleared", "&aYour status has been cleared.");
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            this.updatePlayerTabList();
            this.playerStatusConfig.set(player.getUniqueId().toString(), null);
            this.savePlayerStatusConfig();
            return true;
        }
        if (!command.getName().equalsIgnoreCase("status-admin")) return false;
        if (!sender.hasPermission("statusplugin.admin")) return false;
        if (args2.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: /status-admin <player> <status> | /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount] | /status-admin reload");
            return true;
        }
        String subCommand = args2[0].toLowerCase(Locale.ROOT);
        if (subCommand.equals("reload")) {
            this.reloadPlugin();
            sender.sendMessage(ChatColor.GREEN + "StatusPlugin configuration reloaded!");
            return true;
        }
        if (subCommand.equals("deaths")) {
            Player refreshedOnlineTarget;
            Player targetProfile;
            if (args2.length < 2) {
                sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount]");
                return true;
            }
            Player onlineTarget = Bukkit.getPlayerExact((String)args2[1]);
            Object object = targetProfile = onlineTarget != null ? onlineTarget : Bukkit.getOfflinePlayer((String)args2[1]);
            if (targetProfile == null || !targetProfile.hasPlayedBefore() && !targetProfile.isOnline()) {
                sender.sendMessage(ChatColor.RED + "Player not found.");
                return true;
            }
            UUID targetUuid = targetProfile.getUniqueId();
            int currentDeaths = this.getPlayerDeaths(targetUuid);
            if (args2.length == 2) {
                String targetName = targetProfile.getName() != null ? targetProfile.getName() : args2[1];
                sender.sendMessage(ChatColor.YELLOW + targetName + ChatColor.GRAY + " has " + ChatColor.AQUA + currentDeaths + ChatColor.GRAY + " tracked deaths.");
                return true;
            }
            String action = args2[2].toLowerCase(Locale.ROOT);
            int newDeaths = currentDeaths;
            switch (action) {
                case "reset": {
                    newDeaths = 0;
                    break;
                }
                case "set": {
                    int amount;
                    if (args2.length < 4) {
                        sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> set <amount>");
                        return true;
                    }
                    try {
                        amount = Integer.parseInt(args2[3]);
                        if (amount < 0) {
                            sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                            return true;
                        }
                        newDeaths = amount;
                        break;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                        return true;
                    }
                }
                case "add": {
                    int amount;
                    if (args2.length < 4) {
                        sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> add <amount>");
                        return true;
                    }
                    try {
                        amount = Integer.parseInt(args2[3]);
                        if (amount < 0) {
                            sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                            return true;
                        }
                        newDeaths = currentDeaths + amount;
                        break;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                        return true;
                    }
                }
                case "remove": 
                case "minus": {
                    int amount;
                    if (args2.length < 4) {
                        sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> " + action + " <amount>");
                        return true;
                    }
                    try {
                        amount = Integer.parseInt(args2[3]);
                        if (amount < 0) {
                            sender.sendMessage(ChatColor.RED + "Amount must not be negative.");
                            return true;
                        }
                        newDeaths = Math.max(0, currentDeaths - amount);
                        break;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(ChatColor.RED + "Amount must be a whole number.");
                        return true;
                    }
                }
                default: {
                    sender.sendMessage(ChatColor.RED + "Usage: /status-admin deaths <player> [view|add|remove|minus|reset|set] [amount]");
                    return true;
                }
            }
            this.playerDeathMap.put(targetUuid, newDeaths);
            if (this.playerDeathsConfig != null) {
                this.playerDeathsConfig.set(targetUuid.toString(), (Object)newDeaths);
                this.savePlayerDeathsConfig();
            }
            if ((refreshedOnlineTarget = Bukkit.getPlayer((UUID)targetUuid)) != null) {
                if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
                    this.updatePlayerTabListName(refreshedOnlineTarget);
                }
                refreshedOnlineTarget.sendMessage(ChatColor.GOLD + "Your tracked deaths were updated to " + ChatColor.AQUA + newDeaths + ChatColor.GOLD + " by an administrator.");
            }
            String targetName = targetProfile.getName() != null ? targetProfile.getName() : args2[1];
            sender.sendMessage(ChatColor.GREEN + "Set " + targetName + "'s tracked deaths to " + newDeaths + ".");
            return true;
        }
        int targetIndex = 0;
        int statusIndex = 1;
        if (subCommand.equals("set")) {
            if (args2.length < 3) {
                sender.sendMessage(ChatColor.RED + "Usage: /status-admin set <player> <status>");
                return true;
            }
            targetIndex = 1;
            statusIndex = 2;
        } else if (args2.length < 2) {
            sender.sendMessage(ChatColor.RED + "Usage: /status-admin <player> <status>");
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)args2[targetIndex]);
        if (targetPlayer == null) {
            sender.sendMessage(ChatColor.RED + "Player not found.");
            return true;
        }
        String statusKey = args2[statusIndex].toUpperCase(Locale.ROOT);
        String status = this.statusOptions.get(statusKey);
        if (status != null) {
            this.playerStatusMap.put(targetPlayer.getUniqueId(), status);
            String message = this.getLanguageText(targetPlayer, "status_set", "&aYour status has been set to: &r%s");
            targetPlayer.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(message, status)));
            this.updatePlayerTabList();
            this.playerStatusConfig.set(targetPlayer.getUniqueId().toString(), (Object)status);
            this.savePlayerStatusConfig();
            sender.sendMessage(ChatColor.GREEN + "Status of " + targetPlayer.getName() + " has been set to: " + ChatColor.translateAlternateColorCodes((char)'&', (String)status));
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Invalid status option. Use /status-admin " + (subCommand.equals("set") ? "set <player> <status>" : "<player> <status>"));
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.getConfig().getBoolean("default_status_enabled", true)) {
            String defaultStatus = this.getConfig().getString("default_status", "DEFAULT");
            this.playerStatusMap.put(player.getUniqueId(), defaultStatus);
            this.playerStatusConfig.set(player.getUniqueId().toString(), (Object)defaultStatus);
            this.savePlayerStatusConfig();
        }
        if (this.countryLocationManager != null && this.getConfig().getBoolean("country-location-enabled", true)) {
            ((CompletableFuture)this.countryLocationManager.getPlayerCountryAsync(player).thenAccept(countryData -> {
                if (countryData != null && this.getConfig().getBoolean("tab-styling-enabled", true)) {
                    Bukkit.getScheduler().runTask((Plugin)this, this::updatePlayerTabList);
                }
            })).exceptionally(throwable -> {
                this.getLogger().warning("Failed to fetch country data for player " + player.getName() + ": " + throwable.getMessage());
                return null;
            });
        }
        if (player.hasPermission("statusplugin.admin") && this.getConfig().getBoolean("admin-join-message-enabled", false)) {
            String adminJoinMessage = "&aThank you for using this status plugin. When you want to support me, please download my plugin from Modrinth! https://modrinth.com/plugin/statusplugin-like-in-craftattack";
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)adminJoinMessage));
        }
        if (player.isOp() || player.hasPermission("statusplugin.admin")) {
            ModrinthVersionChecker.checkVersion();
        }
        if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
            this.updatePlayerTabList();
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        int deaths = this.playerDeathMap.getOrDefault(uuid, 0) + 1;
        this.playerDeathMap.put(uuid, deaths);
        if (this.playerDeathsConfig != null) {
            this.playerDeathsConfig.set(uuid.toString(), (Object)deaths);
            this.savePlayerDeathsConfig();
        }
        if (this.getConfig().getBoolean("tab-styling-enabled", true)) {
            this.updatePlayerTabListName(player);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String chatFormat;
        if (Boolean.TRUE.equals(relayingToDiscord.get())) {
            return;
        }
        if (!this.getConfig().getBoolean("chat-styling-enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        if (status.isEmpty()) {
            chatFormat = this.getConfig().getString("chat-format-no-status", "<$$PLAYER$$> ");
        } else {
            chatFormat = this.getConfig().getString("chat-format", "%status% <$$PLAYER$$> ");
            chatFormat = chatFormat.replace("%status%", status);
        }
        if (this.getConfig().getBoolean("country-location-enabled", false) && this.countryLocationManager != null) {
            CountryLocationManager.CountryData countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
            if (countryData != null) {
                chatFormat = chatFormat.replace("%country%", countryData.getCountry());
                chatFormat = chatFormat.replace("%countrycode%", countryData.getCountryCode());
            } else {
                chatFormat = chatFormat.replace("%country%", "");
                chatFormat = chatFormat.replace("%countrycode%", "");
            }
        } else {
            chatFormat = chatFormat.replace("%country%", "");
            chatFormat = chatFormat.replace("%countrycode%", "");
        }
        chatFormat = chatFormat.replace("%deaths%", String.valueOf(this.getPlayerDeaths(player.getUniqueId())));
        chatFormat = chatFormat.replace("$$PLAYER$$", player.getName());
        chatFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)chatFormat);
        BaseComponent[] statusComponent = TextComponent.fromLegacyText((String)chatFormat);
        BaseComponent[] messageComponent = TextComponent.fromLegacyText((String)event.getMessage());
        BaseComponent[] finalComponents = new BaseComponent[statusComponent.length + messageComponent.length];
        System.arraycopy(statusComponent, 0, finalComponents, 0, statusComponent.length);
        System.arraycopy(messageComponent, 0, finalComponents, statusComponent.length, messageComponent.length);
        BaseComponent[] baseComponentArray = finalComponents;
        int n = finalComponents.length;
        int n2 = 0;
        while (n2 < n) {
            BaseComponent component = baseComponentArray[n2];
            String text = component.toPlainText();
            if (text.contains("http://") || text.contains("https://")) {
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, text));
            }
            ++n2;
        }
        for (Player recipient : Bukkit.getOnlinePlayers()) {
            recipient.spigot().sendMessage(finalComponents);
        }
        event.setCancelled(true);
        if (this.isDiscordSrvPresent && this.getConfig().getBoolean("discordsrv-relay-enabled", true) && !Boolean.TRUE.equals(relayingToDiscord.get())) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                try {
                    relayingToDiscord.set(true);
                    AsyncPlayerChatEvent forward = new AsyncPlayerChatEvent(false, player, event.getMessage(), new HashSet());
                    Bukkit.getPluginManager().callEvent((Event)forward);
                }
                finally {
                    relayingToDiscord.set(false);
                }
            });
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args2) {
        ArrayList<String> completions;
        block20: {
            block19: {
                completions = new ArrayList<String>();
                if (!command.getName().equalsIgnoreCase("status")) break block19;
                if (args2.length != 1) break block20;
                String prefix = args2[0].toUpperCase();
                for (String option : this.statusOptions.keySet()) {
                    if (!option.startsWith(prefix)) continue;
                    completions.add(option);
                }
                break block20;
            }
            if (!command.getName().equalsIgnoreCase("status-admin")) break block20;
            if (args2.length == 1) {
                String prefix = args2[0].toLowerCase(Locale.ROOT);
                if ("reload".startsWith(prefix)) {
                    completions.add("reload");
                }
                if ("deaths".startsWith(prefix)) {
                    completions.add("deaths");
                }
                if ("set".startsWith(prefix)) {
                    completions.add("set");
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                    completions.add(player.getName());
                }
            } else if (args2.length == 2) {
                if (args2[0].equalsIgnoreCase("deaths") || args2[0].equalsIgnoreCase("set")) {
                    String prefix = args2[1].toLowerCase(Locale.ROOT);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                        completions.add(player.getName());
                    }
                } else {
                    String prefix = args2[1].toUpperCase(Locale.ROOT);
                    for (String option : this.statusOptions.keySet()) {
                        if (!option.startsWith(prefix)) continue;
                        completions.add(option);
                    }
                }
            } else if (args2.length == 3) {
                if (args2[0].equalsIgnoreCase("deaths")) {
                    String prefix = args2[2].toLowerCase(Locale.ROOT);
                    List<String> actions = Arrays.asList("add", "remove", "minus", "reset", "set");
                    for (String action : actions) {
                        if (!action.startsWith(prefix)) continue;
                        completions.add(action);
                    }
                } else if (args2[0].equalsIgnoreCase("set")) {
                    String prefix = args2[2].toUpperCase(Locale.ROOT);
                    for (String option : this.statusOptions.keySet()) {
                        if (!option.startsWith(prefix)) continue;
                        completions.add(option);
                    }
                }
            }
        }
        return completions;
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.commandName = config.getString("command-name", "status");
        config.getString("chat-format", "%status% &r<$$PLAYER$$> &e%countrycode% &c%deaths%");
        this.tabListFormat = config.getString("tab-list-format", "&a%status% &r$$PLAYER$$ &e%countrycode% &c%deaths%");
        this.defaultLanguage = config.getString("default-language", "english");
        this.useOnlyOneLanguage = config.getBoolean("use-only-one-language", true);
        this.loadStatusOptions();
        boolean defaultStatusEnabled = config.getBoolean("default_status_enabled", true);
        String defaultStatus = config.getString("default_status", "DEFAULT");
        if (defaultStatusEnabled) {
            this.statusOptions.put("DEFAULT", defaultStatus);
        }
    }

    private void loadStatusOptions() {
        YamlConfiguration statusOptionsConfig;
        File statusOptionsFile = new File(this.getDataFolder(), "status-options.yml");
        if (!statusOptionsFile.exists()) {
            this.saveResource("status-options.yml", false);
        }
        if ((statusOptionsConfig = YamlConfiguration.loadConfiguration((File)statusOptionsFile)).isConfigurationSection("status")) {
            Set keys2 = Objects.requireNonNull(statusOptionsConfig.getConfigurationSection("status")).getKeys(false);
            for (String key : keys2) {
                this.statusOptions.put(key.toUpperCase(), statusOptionsConfig.getString("status." + key));
            }
        }
    }

    private void loadLanguageConfig() {
        File languageFile;
        String languageFileName;
        String string = languageFileName = this.useOnlyOneLanguage ? "language.yml" : String.valueOf(this.defaultLanguage) + "_language.yml";
        if (this.useOnlyOneLanguage) {
            languageFile = new File(this.getDataFolder(), languageFileName);
            if (!languageFile.exists()) {
                this.saveResource(languageFileName, false);
            }
        } else {
            languageFile = new File(this.getDataFolder(), String.valueOf(this.defaultLanguage) + "_language.yml");
            if (!languageFile.exists()) {
                this.saveResource(String.valueOf(this.defaultLanguage) + "_language.yml", false);
            }
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    private void loadPlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        if (!playerStatusFile.exists()) {
            try {
                if (playerStatusFile.createNewFile()) {
                    this.getLogger().info("player-status.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadPlayerStatusConfig | IOException e");
            }
        }
        this.playerStatusConfig = YamlConfiguration.loadConfiguration((File)playerStatusFile);
    }

    private void loadPlayerDeathsConfig() {
        File playerDeathsFile = new File(this.getDataFolder(), "player-deaths.yml");
        if (!playerDeathsFile.exists()) {
            try {
                if (playerDeathsFile.createNewFile()) {
                    this.getLogger().info("player-deaths.yml file created.");
                }
            }
            catch (IOException e) {
                this.getLogger().info("&c AN ERROR OCCURRED! | loadPlayerDeathsConfig | IOException e");
            }
        }
        this.playerDeathsConfig = YamlConfiguration.loadConfiguration((File)playerDeathsFile);
    }

    private void savePlayerStatusConfig() {
        File playerStatusFile = new File(this.getDataFolder(), "player-status.yml");
        try {
            this.playerStatusConfig.save(playerStatusFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | savePlayerStatusConfig | IOException e");
        }
    }

    private void savePlayerDeathsConfig() {
        File playerDeathsFile = new File(this.getDataFolder(), "player-deaths.yml");
        try {
            this.playerDeathsConfig.save(playerDeathsFile);
        }
        catch (IOException e) {
            this.getLogger().info("&c AN ERROR OCCURRED! | savePlayerDeathsConfig | IOException e");
        }
    }

    private String getLanguageText(Player player, String key, String defaultText) {
        if (this.useOnlyOneLanguage) {
            return this.languageConfig.getString(key, defaultText);
        }
        String playerLanguage = this.languageConfig.getString(player.getUniqueId() + ".language", this.defaultLanguage);
        File playerLanguageFile = new File(this.getDataFolder(), String.valueOf(playerLanguage) + "_language.yml");
        YamlConfiguration playerLanguageConfig = YamlConfiguration.loadConfiguration((File)playerLanguageFile);
        return playerLanguageConfig.getString(key, defaultText);
    }

    private void updatePlayerTabList() {
        if (!this.getConfig().getBoolean("tab-styling-enabled", true)) {
            return;
        }
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        int i = 0;
        while (i < players.size()) {
            Player player = (Player)players.get(i);
            String invisiblePrefix = "\u00a7" + (char)(97 + i);
            player.setDisplayName(String.valueOf(invisiblePrefix) + player.getName());
            this.updatePlayerTabListName(player);
            ++i;
        }
    }

    public String getPlayerStatus(UUID uuid) {
        return this.playerStatusMap.getOrDefault(uuid, "");
    }

    public CountryLocationManager getCountryLocationManager() {
        return this.countryLocationManager;
    }

    public int getPlayerDeaths(UUID uuid) {
        return this.playerDeathMap.getOrDefault(uuid, 0);
    }

    private void updatePlayerTabListName(Player player) {
        String tabListName;
        String status = this.playerStatusMap.getOrDefault(player.getUniqueId(), "");
        String playerName = player.getName();
        if (status.isEmpty()) {
            String noStatusFormat = this.getConfig().getString("tab-list-format-no-status", "&7[&e%countrycode%&7] &r$$PLAYER$$");
            tabListName = noStatusFormat.replace("$$PLAYER$$", playerName);
        } else {
            tabListName = this.tabListFormat.replace("%status%", status).replace("$$PLAYER$$", playerName);
        }
        if (this.getConfig().getBoolean("country-location-enabled", false) && this.countryLocationManager != null) {
            CountryLocationManager.CountryData countryData = this.countryLocationManager.getPlayerCountry(player.getUniqueId());
            if (countryData != null) {
                tabListName = tabListName.replace("%country%", countryData.getCountry());
                tabListName = tabListName.replace("%countrycode%", countryData.getCountryCode());
            } else {
                tabListName = tabListName.replace("%country%", "");
                tabListName = tabListName.replace("%countrycode%", "");
            }
        } else {
            tabListName = tabListName.replace("%country%", "");
            tabListName = tabListName.replace("%countrycode%", "");
        }
        tabListName = tabListName.replace("%deaths%", String.valueOf(this.getPlayerDeaths(player.getUniqueId())));
        tabListName = ChatColor.translateAlternateColorCodes((char)'&', (String)tabListName);
        if (this.isTabPluginPresent) {
            TabPlayer tabPlayer = TabAPI.getInstance().getPlayer(player.getUniqueId());
            TabListFormatManager formatManager = TabAPI.getInstance().getTabListFormatManager();
            if (tabPlayer != null && formatManager != null) {
                formatManager.setPrefix(tabPlayer, null);
                formatManager.setName(tabPlayer, tabListName);
                formatManager.setSuffix(tabPlayer, null);
            }
        } else {
            player.setPlayerListName(tabListName);
        }
    }

    private void reloadPlugin() {
        this.reloadConfig();
        this.loadConfig();
        this.loadLanguageConfig();
        this.loadPlayerStatusConfig();
        this.loadPlayerDeathsConfig();
        this.loadPlayerStatuses();
        this.loadPlayerDeaths();
        this.updatePlayerTabList();
    }
}

