/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.color.interfaces.Colorable;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import org.jetbrains.annotations.Nullable;

public class RuneBlockEntity
extends class_2586
implements Colorable {
    public class_1297 owner;
    public UUID ownerUUID;
    public Spell spell;
    public String spellText;
    public CompletableFuture<List<Targetable>> future;
    public int color;
    boolean unloadedSpell = true;

    public RuneBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ScriptorBlockEntities.RUNE.get(), blockPos, blockState);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10569("com/ssblur/scriptor/color", this.color);
        return tag;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.color = tag.method_10550("com/ssblur/scriptor/color");
        if (tag.method_10545("spell")) {
            this.spellText = tag.method_10558("spell");
        } else {
            this.unloadedSpell = false;
        }
        if (tag.method_10545("owner")) {
            this.ownerUUID = UUID.fromString(tag.method_10558("owner"));
        }
        this.method_5431();
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (this.spell != null) {
                tag.method_10582("spell", DictionarySavedData.computeIfAbsent(server).generate(this.spell));
            }
        }
        if (this.owner != null && this.owner.method_5667() != null) {
            tag.method_10582("owner", this.owner.method_5845());
        } else if (this.ownerUUID != null) {
            tag.method_10582("owner", this.ownerUUID.toString());
        }
        tag.method_10569("com/ssblur/scriptor/color", this.color);
    }

    public void tick() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.field_11863.method_8510() % 40L == 0L && this.owner == null && this.ownerUUID != null && this.field_11863.method_18470(this.ownerUUID) != null) {
            this.owner = this.field_11863.method_18470(this.ownerUUID);
            Spell spell = DictionarySavedData.computeIfAbsent((class_3218)this.field_11863).parse(this.spellText);
            if (spell != null) {
                this.future = this.owner != null ? spell.createFuture(new EntityTargetable(this.owner)) : spell.createFuture(new Targetable(this.field_11863, this.method_11016()));
            }
        }
        if (this.future == null || this.future.isDone()) {
            if (this.spell != null) {
                this.future = this.owner != null && this.owner.method_5805() ? this.spell.createFuture(new EntityTargetable(this.owner)) : this.spell.createFuture(new Targetable(this.field_11863, this.method_11016()));
            } else if (this.spellText != null) {
                this.spell = DictionarySavedData.computeIfAbsent((class_3218)this.field_11863).parse(this.spellText);
                if (this.spell != null) {
                    this.future = this.owner == null ? this.spell.createFuture(new Targetable(this.field_11863, this.field_11867)) : this.spell.createFuture(new EntityTargetable(this.owner));
                }
            }
        }
        double xMin = this.field_11867.method_10263() >= 0 ? 0.2 : -0.8;
        double zMin = this.field_11867.method_10260() >= 0 ? 0.2 : -0.8;
        double xMax = this.field_11867.method_10263() >= 0 ? 0.6 : -0.4;
        double zMax = this.field_11867.method_10260() >= 0 ? 0.6 : -0.4;
        class_238 box = class_238.method_19316((class_3341)class_3341.method_34390((class_2382)new class_2382((int)((double)this.field_11867.method_10263() + xMin), (int)((double)this.field_11867.method_10264() + 0.0), (int)((double)this.field_11867.method_10260() + zMin)), (class_2382)new class_2382((int)((double)this.field_11867.method_10263() + xMax), (int)((double)this.field_11867.method_10264() + 0.0625), (int)((double)this.field_11867.method_10260() + zMax))));
        List entities = this.field_11863.method_8335(null, box);
        if (entities.size() > 0) {
            ArrayList<EntityTargetable> targets = new ArrayList<EntityTargetable>();
            for (class_1297 entity : entities) {
                targets.add(new EntityTargetable(entity));
            }
            if (this.future != null) {
                this.future.complete(targets);
            }
            this.field_11863.method_8650(this.field_11867, true);
        }
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T entity) {
        if (level.field_9236) {
            return;
        }
        if (entity instanceof RuneBlockEntity) {
            RuneBlockEntity tile = (RuneBlockEntity)entity;
            tile.tick();
        }
    }

    @Override
    public void setColor(int color) {
        this.color = color;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }
}

