/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.registry.TokenGeneratorRegistry;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class DictionarySavedData
extends class_18 {
    public List<WORD> spellStructure;
    public BiMap<String, String> words;
    public static final Codec<DictionarySavedData> worldCodec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("spellStructure").forGetter(worldData -> worldData.spellStructure.stream().map(Enum::toString).toList()), (App)Codec.compoundList((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("words").forGetter(worldData -> worldData.words.keySet().stream().map(key -> new Pair(key, (Object)((String)worldData.words.get(key)))).toList())).apply((Applicative)instance, DictionarySavedData::new));

    public DictionarySavedData(List<String> spellStructure, List<Pair<String, String>> words) {
        this.spellStructure = spellStructure.stream().map(WORD::valueOf).toList();
        this.words = HashBiMap.create();
        for (Pair<String, String> pair : words) {
            this.words.put((Object)((String)pair.getFirst()), (Object)((String)pair.getSecond()));
        }
        this.generateMissingWords();
        this.method_80();
    }

    boolean containsKey(String key) {
        return this.words.containsKey((Object)key);
    }

    boolean containsWord(String string) {
        return this.words.containsValue((Object)string);
    }

    void generateMissingWords() {
        String token;
        TokenGeneratorRegistry registry = TokenGeneratorRegistry.INSTANCE;
        if (!this.containsKey("other:and")) {
            while (this.containsWord(token = registry.generateWord("other:and"))) {
            }
            this.words.put((Object)"other:and", (Object)token);
        }
        for (String word : WordRegistry.INSTANCE.actionRegistry.keySet()) {
            if (this.containsKey("action:" + word)) continue;
            while (this.containsWord(token = registry.generateWord("action:" + word))) {
            }
            this.words.put((Object)("action:" + word), (Object)token);
        }
        for (String word : WordRegistry.INSTANCE.descriptorRegistry.keySet()) {
            if (this.containsKey("descriptor:" + word)) continue;
            while (this.containsWord(token = registry.generateWord("descriptor:" + word))) {
            }
            this.words.put((Object)("descriptor:" + word), (Object)token);
        }
        for (String word : WordRegistry.INSTANCE.subjectRegistry.keySet()) {
            if (this.containsKey("subject:" + word)) continue;
            while (this.containsWord(token = registry.generateWord("subject:" + word))) {
            }
            this.words.put((Object)("subject:" + word), (Object)token);
        }
    }

    public DictionarySavedData() {
        WORD[] basicStructure = new WORD[]{WORD.SUBJECT, WORD.ACTION, WORD.DESCRIPTOR};
        List<WORD> structure = Arrays.asList(basicStructure);
        if (!ScriptorMod.COMMUNITY_MODE) {
            Collections.shuffle(structure);
        }
        this.spellStructure = new ArrayList<WORD>();
        this.spellStructure.addAll(structure);
        this.words = HashBiMap.create();
        this.generateMissingWords();
        this.method_80();
    }

    public String parseWord(String word) {
        return (String)this.words.inverse().get((Object)word);
    }

    public String getWord(String key) {
        return (String)this.words.get((Object)key);
    }

    public String getKey(Word word) {
        String key = WordRegistry.INSTANCE.getKey(word);
        if (key != null) {
            if (word instanceof Action) {
                return "action:" + key;
            }
            if (word instanceof Subject) {
                return "subject:" + key;
            }
            if (word instanceof Descriptor) {
                return "descriptor:" + key;
            }
        }
        return null;
    }

    public String getWord(Word word) {
        return this.getWord(this.getKey(word));
    }

    @Nullable
    public Spell parse(@Nullable String text) {
        if (text == null) {
            ScriptorMod.LOGGER.warn("No text provided to parser!");
            return null;
        }
        int position = 0;
        int tokenPosition = 0;
        try {
            String[] tokens = text.split(" ");
            Subject subject = null;
            ArrayList<PartialSpell> spells = new ArrayList<PartialSpell>();
            Action action = null;
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            block7: while (tokenPosition < tokens.length) {
                if (position % this.spellStructure.size() == 0 && position > 0) {
                    String parsed = this.parseWord(tokens[tokenPosition]);
                    if (parsed != null && parsed.equals("other:and")) {
                        ++tokenPosition;
                        spells.add(new PartialSpell(action, (Descriptor[])descriptors.toArray(Descriptor[]::new)));
                        descriptors = new ArrayList();
                    } else {
                        return null;
                    }
                }
                if (position >= this.spellStructure.size() && this.spellStructure.get(position % this.spellStructure.size()) == WORD.SUBJECT) {
                    ++position;
                }
                WORD word = this.spellStructure.get(position % this.spellStructure.size());
                String wordData = this.parseWord(tokens[tokenPosition]);
                switch (word) {
                    case ACTION: {
                        if (wordData == null) {
                            ScriptorMod.LOGGER.debug("Failed to process spell with text: \"" + text + "\"");
                            ScriptorMod.LOGGER.debug("No word found for \"" + tokens[tokenPosition] + "\", action expected");
                            return null;
                        }
                        action = (Action)WordRegistry.INSTANCE.actionRegistry.get((Object)wordData.substring(7));
                        break;
                    }
                    case DESCRIPTOR: {
                        if (wordData == null || wordData.length() < 12) {
                            ++position;
                            continue block7;
                        }
                        Descriptor descriptor = (Descriptor)WordRegistry.INSTANCE.descriptorRegistry.get((Object)wordData.substring(11));
                        if (descriptor == null) {
                            ++position;
                            continue block7;
                        }
                        descriptors.add(descriptor);
                        ++tokenPosition;
                        continue block7;
                    }
                    case SUBJECT: {
                        if (wordData == null) {
                            ScriptorMod.LOGGER.debug("Failed to process spell with text: \"" + text + "\"");
                            ScriptorMod.LOGGER.debug("Subject " + tokens[tokenPosition] + " not found");
                            return null;
                        }
                        subject = (Subject)WordRegistry.INSTANCE.subjectRegistry.get((Object)wordData.substring(8));
                    }
                }
                ++position;
                ++tokenPosition;
            }
            if (action != null && subject != null) {
                spells.add(new PartialSpell(action, (Descriptor[])descriptors.toArray(Descriptor[]::new)));
                return new Spell(subject, (PartialSpell[])spells.toArray(PartialSpell[]::new));
            }
        }
        catch (Exception e) {
            ScriptorMod.LOGGER.warn("==========================================================");
            ScriptorMod.LOGGER.warn("The below error did NOT cause a crash, this is debug info!");
            ScriptorMod.LOGGER.error("Error:", (Throwable)e);
            ScriptorMod.LOGGER.warn("==========================================================");
        }
        ScriptorMod.LOGGER.debug("Failed to process spell with text: \"" + text + "\"");
        return null;
    }

    public List<String> parseComponents(String text) {
        Spell spell = this.parse(text);
        if (spell != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getKey(spell.subject()));
            for (PartialSpell partialSpell : spell.spells()) {
                list.add(this.getKey(partialSpell.action()));
                for (Descriptor descriptor : partialSpell.descriptors()) {
                    list.add(this.getKey(descriptor));
                }
            }
            return list;
        }
        return null;
    }

    public String generate(Spell spell) {
        assert (spell.spells().length >= 1);
        StringBuilder descriptorBuilder = new StringBuilder();
        for (Descriptor descriptor : spell.spells()[0].deduplicatedDescriptors()) {
            descriptorBuilder.append(" ").append(this.getWord(descriptor));
        }
        StringBuilder builder = new StringBuilder();
        for (WORD w : this.spellStructure) {
            if (w == WORD.ACTION) {
                builder.append(" ").append(this.getWord(spell.spells()[0].action()));
                continue;
            }
            if (w == WORD.SUBJECT) {
                builder.append(" ").append(this.getWord(spell.subject()));
                continue;
            }
            if (w != WORD.DESCRIPTOR) continue;
            builder.append((CharSequence)descriptorBuilder);
        }
        for (PartialSpell partialSpell : Arrays.stream(spell.spells()).skip(1L).toList()) {
            builder.append(" ").append(this.getWord("other:and"));
            descriptorBuilder = new StringBuilder();
            for (Descriptor descriptor : partialSpell.deduplicatedDescriptors()) {
                descriptorBuilder.append(" ").append(this.getWord(descriptor));
            }
            for (WORD w : this.spellStructure) {
                if (w == WORD.ACTION) {
                    builder.append(" ").append(this.getWord(partialSpell.action()));
                    continue;
                }
                if (w != WORD.DESCRIPTOR) continue;
                builder.append((CharSequence)descriptorBuilder);
            }
        }
        return builder.toString().strip();
    }

    public class_2487 method_75(class_2487 tag) {
        Optional result = worldCodec.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).get().left();
        result.ifPresent(value -> tag.method_10566("scriptor:dictionary", value));
        return tag;
    }

    public static DictionarySavedData load(class_2487 tag) {
        Optional result;
        class_2520 input = tag.method_10580("scriptor:dictionary");
        if (input != null && (result = worldCodec.decode((DynamicOps)class_2509.field_11560, (Object)input).get().left()).isPresent() && ((Pair)result.get()).getFirst() != null) {
            return (DictionarySavedData)((Object)((Pair)result.get()).getFirst());
        }
        return null;
    }

    public static DictionarySavedData computeIfAbsent(class_3218 level) {
        class_3218 server = level.method_8503().method_3847(class_1937.field_25179);
        Objects.requireNonNull(server);
        return (DictionarySavedData)server.method_17983().method_17924(DictionarySavedData::load, DictionarySavedData::new, ScriptorMod.COMMUNITY_MODE ? "scriptor_community_dictionary" : "scriptor_dictionary");
    }

    public String toString() {
        if (ScriptorMod.COMMUNITY_MODE) {
            return "DictionarySavedData[COMMUNITY_MODE=true]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Structure: ");
        for (WORD w : this.spellStructure) {
            builder.append((Object)w).append(" ");
        }
        builder.append("\nContains ").append(this.words.size()).append(" Words.");
        return builder.toString();
    }

    public static enum WORD {
        ACTION,
        DESCRIPTOR,
        SUBJECT;

    }
}

