/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events;

import com.ssblur.scriptor.damage.ScriptorDamage;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.effect.ScriptorEffects;
import com.ssblur.scriptor.gamerules.ChatRules;
import com.ssblur.scriptor.gamerules.ScriptorGameRules;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.word.Spell;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SpellChatEvents
implements ChatEvent.Received {
    public EventResult received(@Nullable class_3222 player, class_2561 component) {
        String sentence = component.getString();
        if (player != null) {
            class_3218 server;
            Spell spell;
            class_1937 level = player.method_37908();
            if (level instanceof class_3218 && (spell = DictionarySavedData.computeIfAbsent(server = (class_3218)level).parse(sentence)) != null) {
                if (player.method_6059((class_1291)ScriptorEffects.HOARSE.get())) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"extra.scriptor.hoarse"));
                    return EventResult.interruptFalse();
                }
                if (player.method_6059((class_1291)ScriptorEffects.MUTE.get())) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"extra.scriptor.mute"));
                    return EventResult.interruptFalse();
                }
                int cost = (int)Math.round(spell.cost() * 30.0);
                if (level.method_8450().method_8356(ScriptorGameRules.VOCAL_MAX_COST) >= 0 && cost > level.method_8450().method_8356(ScriptorGameRules.VOCAL_MAX_COST)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"extra.scriptor.mute"));
                }
                int adjustedCost = (int)Math.round((double)cost * ((double)level.method_8450().method_8356(ScriptorGameRules.VOCAL_COOLDOWN_MULTIPLIER) / 100.0));
                if (!player.method_7337()) {
                    player.method_6092(new class_1293((class_1291)ScriptorEffects.HOARSE.get(), adjustedCost));
                    if (adjustedCost > level.method_8450().method_8356(ScriptorGameRules.VOCAL_HUNGER_THRESHOLD)) {
                        player.method_6092(new class_1293(class_1294.field_5903, 2 * (adjustedCost - level.method_8450().method_8356(ScriptorGameRules.VOCAL_HUNGER_THRESHOLD))));
                    }
                    if (adjustedCost > level.method_8450().method_8356(ScriptorGameRules.VOCAL_DAMAGE_THRESHOLD)) {
                        player.method_5643(Objects.requireNonNull(ScriptorDamage.overload((class_1297)player)), ((float)adjustedCost - (float)level.method_8450().method_8356(ScriptorGameRules.VOCAL_DAMAGE_THRESHOLD) * 0.75f) / 100.0f);
                    }
                }
                if (player.method_6032() > 0.0f) {
                    spell.cast(new EntityTargetable((class_1297)player));
                }
                if (!server.method_8450().method_8355(ChatRules.SHOW_SPELLS_IN_CHAT)) {
                    return EventResult.interruptFalse();
                }
            }
            if (level instanceof class_3218 && (server = (class_3218)level).method_8450().method_8355(ChatRules.PROXIMITY_CHAT)) {
                int distance = server.method_8450().method_8356(ChatRules.PROXIMITY_RANGE);
                class_2561 name = player.method_5476();
                class_5250 message = name == null ? class_2561.method_43470((String)"> ").method_10852(component) : class_2561.method_43470((String)"<").method_10852(name).method_10852((class_2561)class_2561.method_43470((String)"> ")).method_10852(component);
                List players = server.method_18766(recipient -> recipient.method_5739((class_1297)player) <= (float)distance);
                for (class_3222 recipient2 : players) {
                    recipient2.method_43496((class_2561)message);
                }
                if (players.size() <= 1) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"command.scriptor.unheard").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
                }
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }
}

