/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.subject.InventorySubject;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class EnchantNetwork {
    public static void useBook(class_2540 buf, NetworkManager.PacketContext context) {
        class_1657 player = context.getPlayer();
        class_1937 level = player.method_37908();
        int slot = buf.readInt();
        class_1799 item = (class_1799)player.field_7512.method_7602().get(slot);
        class_1799 carried = player.field_7512.method_34255();
        if (carried == null || carried.method_7960()) {
            return;
        }
        class_2487 tag = carried.method_7969();
        if (tag != null && level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            class_2499 text = tag.method_10554("pages", 8);
            Spell spell = DictionarySavedData.computeIfAbsent(server).parse(LimitedBookSerializer.decodeText(text));
            if (spell == null) {
                return;
            }
            Subject subject = spell.subject();
            if (subject instanceof InventorySubject) {
                InventorySubject subject2 = (InventorySubject)((Object)subject);
                subject2.castOnItem(spell, player, item);
                player.method_7357().method_7906(carried.method_7909(), (int)Math.round(spell.cost() * 7.0));
            }
        }
    }

    public static void clientUseBook(int slot) {
        class_2540 out = new class_2540(Unpooled.buffer());
        out.writeInt(slot);
        NetworkManager.sendToServer((class_2960)ScriptorNetwork.SERVER_CURSOR_USE_BOOK, (class_2540)out);
    }

    public static void useBookCreative(class_2540 buf, NetworkManager.PacketContext context) {
        class_1799 item = class_1799.method_7915((class_2487)Objects.requireNonNull(buf.method_10798()));
        int slot = buf.readInt();
        class_2487 compound = item.method_7969();
        if (compound == null) {
            return;
        }
        class_2499 text = compound.method_10554("pages", 8);
        List<String> spell = DictionarySavedData.computeIfAbsent((class_3218)context.getPlayer().method_37908()).parseComponents(LimitedBookSerializer.decodeText(text));
        class_2487 tagOut = new class_2487();
        class_2499 list = new class_2499();
        spell.forEach(i -> list.add((Object)class_2519.method_23256((String)i)));
        tagOut.method_10566("components", (class_2520)list);
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10794(tagOut);
        out.writeInt(slot);
        NetworkManager.sendToPlayer((class_3222)((class_3222)context.getPlayer()), (class_2960)ScriptorNetwork.CLIENT_CURSOR_RETURN_BOOK_CREATIVE, (class_2540)out);
    }

    public static void returnBookCreative(class_2540 buf, NetworkManager.PacketContext context) {
        class_2487 tag = buf.method_10798();
        if (tag == null) {
            return;
        }
        int slot = buf.readInt();
        class_2499 list = tag.method_10554("components", 8);
        List<String> components = list.stream().map(Object::toString).toList();
        Action action = null;
        Subject subject = null;
        ArrayList<Descriptor> descriptor = new ArrayList<Descriptor>();
        for (String i : components) {
            String[] split = i.replace("\"", "").split(":", 2);
            switch (split[0]) {
                case "action": {
                    action = (Action)WordRegistry.INSTANCE.actionRegistry.get((Object)split[1]);
                    break;
                }
                case "descriptor": {
                    descriptor.add((Descriptor)WordRegistry.INSTANCE.descriptorRegistry.get((Object)split[1]));
                    break;
                }
                case "subject": {
                    subject = (Subject)WordRegistry.INSTANCE.subjectRegistry.get((Object)split[1]);
                }
            }
        }
        Spell spell = new Spell(subject, new PartialSpell(action, descriptor.toArray(new Descriptor[0])));
        class_1657 player = context.getPlayer();
        class_1799 item = (class_1799)player.field_7512.method_7602().get(slot);
        class_1799 carried = player.field_7512.method_34255();
        Subject subject2 = spell.subject();
        if (subject2 instanceof InventorySubject) {
            InventorySubject inventorySubject = (InventorySubject)((Object)subject2);
            inventorySubject.castOnItem(spell, player, item);
            player.method_7357().method_7906(carried.method_7909(), 5);
        }
    }

    public static void clientUseBookCreative(class_1799 itemStack, int slot) {
        class_2540 out = new class_2540(Unpooled.buffer());
        class_2487 tag = new class_2487();
        itemStack.method_7953(tag);
        out.method_10794(tag);
        out.writeInt(slot);
        NetworkManager.sendToServer((class_2960)ScriptorNetwork.SERVER_CURSOR_USE_BOOK_CREATIVE, (class_2540)out);
    }
}

