/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class TraceNetwork {
    static HashMap<UUID, TraceQueue> queue = new HashMap();

    public static void requestTraceData(class_1657 player, TraceCallback callback) {
        UUID uuid = UUID.randomUUID();
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10797(uuid);
        queue.put(uuid, new TraceQueue(new WeakReference<class_1657>(player), callback));
        NetworkManager.sendToPlayer((class_3222)((class_3222)player), (class_2960)ScriptorNetwork.CLIENT_GET_TRACE_DATA, (class_2540)out);
    }

    public static void requestExtendedTraceData(class_1657 player, TraceCallback callback) {
        UUID uuid = UUID.randomUUID();
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10797(uuid);
        queue.put(uuid, new TraceQueue(new WeakReference<class_1657>(player), callback));
        NetworkManager.sendToPlayer((class_3222)((class_3222)player), (class_2960)ScriptorNetwork.CLIENT_GET_HITSCAN_DATA, (class_2540)out);
    }

    public static void validateAndRun(UUID uuid, class_1657 player, Targetable targetable) {
        TraceQueue queueItem = queue.get(uuid);
        if (queueItem.player.get() == player) {
            queueItem.callback.run(targetable);
        }
    }

    public static void validateAndDrop(UUID uuid, class_1657 player) {
        TraceQueue queueItem = queue.get(uuid);
        if (queueItem.player.get() == player) {
            queue.remove(uuid);
        }
    }

    public static void getExtendedTraceData(class_2540 buf, NetworkManager.PacketContext context) {
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10797(buf.method_10790());
        class_1657 player = context.getPlayer();
        class_1937 level = player.method_37908();
        class_243 position = player.method_33571();
        class_243 angle = player.method_5720().method_1029().method_18805(20.0, 20.0, 20.0);
        class_243 dest = angle.method_1019(position);
        class_3965 blockHitResult = level.method_17742(new class_3959(position, dest, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        class_3966 entityHitResult = class_1675.method_18077((class_1937)level, (class_1297)player, (class_243)position, (class_243)dest, (class_238)class_238.method_30048((class_243)position.method_1023(0.1, 0.1, 0.1), (double)0.2, (double)0.2, (double)0.2).method_18804(angle).method_1014(1.0), e -> true);
        if (entityHitResult != null && entityHitResult.method_17783() != class_239.class_240.field_1333) {
            if (blockHitResult.method_17783() != class_239.class_240.field_1333 && blockHitResult.method_24801((class_1297)player) < entityHitResult.method_24801((class_1297)player)) {
                out.method_10817((Enum)TYPE.BLOCK);
                out.method_17813(blockHitResult);
                NetworkManager.sendToServer((class_2960)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (class_2540)out);
                return;
            }
            class_1297 entity = entityHitResult.method_17782();
            out.method_10817((Enum)TYPE.ENTITY);
            out.writeInt(entity.method_5628());
            out.method_10797(entity.method_5667());
            NetworkManager.sendToServer((class_2960)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (class_2540)out);
            return;
        }
        if (blockHitResult.method_17783() != class_239.class_240.field_1333) {
            out.method_10817((Enum)TYPE.BLOCK);
            out.method_17813(blockHitResult);
            NetworkManager.sendToServer((class_2960)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (class_2540)out);
            return;
        }
        out.method_10817((Enum)TYPE.MISS);
        NetworkManager.sendToServer((class_2960)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (class_2540)out);
    }

    public static void getTraceData(class_2540 buf, NetworkManager.PacketContext ignoredContext) {
        class_310 client = class_310.method_1551();
        class_239 hit = client.field_1765;
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10797(buf.method_10790());
        switch (Objects.requireNonNull(hit).method_17783()) {
            case field_1332: {
                class_3965 blockHit = (class_3965)hit;
                out.method_10817((Enum)TYPE.BLOCK);
                out.method_17813(blockHit);
                break;
            }
            case field_1331: {
                class_3966 entityHit = (class_3966)hit;
                class_1297 entity = entityHit.method_17782();
                out.method_10817((Enum)TYPE.ENTITY);
                out.writeInt(entity.method_5628());
                out.method_10797(entity.method_5667());
                break;
            }
            default: {
                out.method_10817((Enum)TYPE.MISS);
            }
        }
        NetworkManager.sendToServer((class_2960)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (class_2540)out);
    }

    public static void returnTraceData(class_2540 buf, NetworkManager.PacketContext context) {
        UUID uuid = buf.method_10790();
        class_1657 player = context.getPlayer();
        TYPE type = (TYPE)buf.method_10818(TYPE.class);
        switch (type) {
            case BLOCK: {
                class_3965 result = buf.method_17814();
                class_2338 pos = result.method_17777().method_10093(result.method_17780());
                Targetable targetable = new Targetable(player.method_37908(), pos).setFacing(result.method_17780());
                context.queue(() -> TraceNetwork.validateAndRun(uuid, player, targetable));
                break;
            }
            case ENTITY: {
                int entityId = buf.readInt();
                UUID entityUUID = buf.method_10790();
                class_1937 level = player.method_37908();
                class_1297 entity = level.method_8469(entityId);
                if (entity != null && entity.method_5667().equals(entityUUID)) {
                    context.queue(() -> TraceNetwork.validateAndRun(uuid, player, new EntityTargetable(entity)));
                    break;
                }
                context.queue(() -> TraceNetwork.validateAndDrop(uuid, player));
                break;
            }
            default: {
                context.queue(() -> TraceNetwork.validateAndDrop(uuid, player));
            }
        }
    }

    record TraceQueue(WeakReference<class_1657> player, TraceCallback callback) {
    }

    public static interface TraceCallback {
        public void run(Targetable var1);
    }

    static enum TYPE {
        BLOCK,
        ENTITY,
        MISS;

    }
}

