/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.reloadlisteners;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.events.reloadlisteners.ScriptorReloadListener;
import com.ssblur.scriptor.exceptions.InvalidGeneratorException;
import com.ssblur.scriptor.exceptions.MissingRequiredElementException;
import com.ssblur.scriptor.helpers.generators.TokenGenerator;
import com.ssblur.scriptor.registry.TokenGeneratorRegistry;
import com.ssblur.scriptor.tabs.ScriptorTabs;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class GeneratorReloadListener
extends ScriptorReloadListener {
    public static final GeneratorReloadListener INSTANCE = new GeneratorReloadListener();

    GeneratorReloadListener() {
        super("scriptor/generators");
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> objects, class_3300 resourceManager, class_3695 profilerFiller) {
        ScriptorMod.COMMUNITY_MODE = false;
        super.apply(objects, resourceManager, profilerFiller);
    }

    @Override
    public void loadResource(class_2960 resourceLocation, JsonElement jsonElement) {
        JsonObject object = jsonElement.getAsJsonObject();
        if (!object.has("generator")) {
            throw new MissingRequiredElementException("generator", resourceLocation);
        }
        if (!object.has("parameters")) {
            throw new MissingRequiredElementException("parameters", resourceLocation);
        }
        String generator = object.get("generator").getAsString();
        if (TokenGeneratorRegistry.INSTANCE.getGeneratorGenerator(generator) == null) {
            throw new InvalidGeneratorException(generator, resourceLocation);
        }
        if (generator.equals("community")) {
            ScriptorMod.LOGGER.info("Community mode generator loaded, locking down debug features.");
            ScriptorMod.COMMUNITY_MODE = true;
            class_1761 class_17612 = (class_1761)ScriptorTabs.SCRIPTOR_TAB.get();
        }
        TokenGenerator.TokenGeneratorGenerator generatorGenerator = TokenGeneratorRegistry.INSTANCE.getGeneratorGenerator(generator);
        TokenGeneratorRegistry.INSTANCE.registerGenerator(resourceLocation, generatorGenerator.create(object.get("parameters").getAsJsonObject()));
        if (object.has("default") && object.get("default").getAsBoolean()) {
            if (TokenGeneratorRegistry.INSTANCE.getDefaultGenerator() == null || TokenGeneratorRegistry.INSTANCE.getDefaultGenerator().method_12836().equals("scriptor") || !resourceLocation.method_12836().equals("scriptor")) {
                TokenGeneratorRegistry.INSTANCE.registerDefaultGenerator(resourceLocation);
            } else {
                ScriptorMod.LOGGER.warn("Skipping registration of default generator at {}; A default generator outside the 'scriptor' namespace was already registered.", (Object)resourceLocation);
            }
        }
        ScriptorMod.LOGGER.info("Loaded custom generator at {}", (Object)resourceLocation);
    }
}

