/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.reloadlisteners;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.data.PlayerSpellsSavedData;
import com.ssblur.scriptor.events.reloadlisteners.ScriptorReloadListener;
import com.ssblur.scriptor.helpers.resource.ScrapResource;
import com.ssblur.scriptor.item.ScriptorItems;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class ScrapReloadListener
extends ScriptorReloadListener {
    static Random RANDOM = new Random();
    static Type SCRAP_TYPE = new TypeToken<ScrapResource>(){}.getType();
    public static final ScrapReloadListener INSTANCE = new ScrapReloadListener();
    public HashMap<Integer, HashMap<class_2960, String>> tiers = new HashMap();

    public ScrapReloadListener() {
        super("scriptor/scraps");
    }

    @Override
    public void loadResource(class_2960 resourceLocation, JsonElement jsonElement) {
        ScrapResource resource = (ScrapResource)GSON.fromJson(jsonElement, SCRAP_TYPE);
        if (!this.tiers.containsKey(resource.getTier())) {
            this.tiers.put(resource.getTier(), new HashMap());
        }
        if (!resource.isDisabled()) {
            for (String key : resource.getKeys()) {
                this.tiers.get(resource.getTier()).put(resourceLocation.method_48331("." + key.replace(":", ".")), key);
            }
        }
    }

    public HashMap<class_2960, String> getTier(int tier) {
        if (!this.tiers.containsKey(tier)) {
            this.tiers.put(tier, new HashMap());
        }
        return this.tiers.get(tier);
    }

    public String getRandomScrapWord(int tier, class_1657 player) {
        PlayerSpellsSavedData data;
        Set<class_2960> keys = this.getTier(tier).keySet();
        if (ScriptorMod.COMMUNITY_MODE) {
            class_1937 level = player.method_37908();
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                int bracket = (int)serverLevel.method_8412() % 5;
                bracket = Math.min(bracket, keys.size());
                HashSet<class_2960> filteredKeys = new HashSet<class_2960>();
                class_2960[] array = keys.toArray(new class_2960[0]);
                for (int i = 0; i < keys.size(); ++i) {
                    if (bracket != i % 5) continue;
                    filteredKeys.add(array[i]);
                }
                keys = filteredKeys;
            } else {
                return null;
            }
        }
        if ((data = PlayerSpellsSavedData.computeIfAbsent(player)) != null) {
            class_2960 resource;
            HashMap<String, Boolean> scraps = data.getScrapTier(tier);
            class_2960[] keysArray = keys.toArray(new class_2960[0]);
            while (scraps.containsKey((resource = keysArray[RANDOM.nextInt(keys.size())]).method_43903()) && scraps.size() < keys.size()) {
            }
            scraps.put(resource.method_43903(), true);
            data.method_80();
            return this.tiers.get(tier).get(resource);
        }
        return this.tiers.get(tier).get(keys.toArray(new class_2960[0])[RANDOM.nextInt(keys.size())]);
    }

    public class_1799 getRandomScrap(int tier, class_1657 player) {
        String key = this.getRandomScrapWord(tier, player);
        class_2487 scriptor = new class_2487();
        scriptor.method_10582("spell", key);
        scriptor.method_10582("word", DictionarySavedData.computeIfAbsent((class_3218)player.method_37908()).getWord(key));
        if (ScriptorMod.COMMUNITY_MODE) {
            scriptor.method_10556("community", true);
        }
        class_1799 itemStack = new class_1799((class_1935)ScriptorItems.SCRAP.get());
        class_2487 tag = itemStack.method_7948();
        tag.method_10566("scriptor", (class_2520)scriptor);
        return itemStack;
    }
}

