/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.registry.words;

import com.google.common.collect.HashBiMap;
import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.registry.words.Actions;
import com.ssblur.scriptor.registry.words.ColorDescriptors;
import com.ssblur.scriptor.registry.words.Descriptors;
import com.ssblur.scriptor.registry.words.InventoryDescriptors;
import com.ssblur.scriptor.registry.words.OffsetDescriptors;
import com.ssblur.scriptor.registry.words.PotionActions;
import com.ssblur.scriptor.registry.words.Subjects;

public class WordRegistry {
    public static final WordRegistry INSTANCE = new WordRegistry();
    public static final Actions ACTIONS = new Actions();
    public static final PotionActions POTION_ACTIONS = new PotionActions();
    public static final ColorDescriptors COLOR_DESCRIPTORS = new ColorDescriptors();
    public static final Descriptors DESCRIPTORS = new Descriptors();
    public static final OffsetDescriptors OFFSET_DESCRIPTORS = new OffsetDescriptors();
    public static final InventoryDescriptors INVENTORY_DESCRIPTORS = new InventoryDescriptors();
    public static final Subjects SUBJECTS = new Subjects();
    public HashBiMap<String, Action> actionRegistry = HashBiMap.create();
    public HashBiMap<String, Descriptor> descriptorRegistry = HashBiMap.create();
    public HashBiMap<String, Subject> subjectRegistry = HashBiMap.create();

    public String getKey(Word word) {
        if (word instanceof Action) {
            Action action = (Action)word;
            return (String)this.actionRegistry.inverse().get((Object)action);
        }
        if (word instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)word;
            return (String)this.descriptorRegistry.inverse().get((Object)descriptor);
        }
        if (word instanceof Subject) {
            Subject subject = (Subject)word;
            return (String)this.subjectRegistry.inverse().get((Object)subject);
        }
        return null;
    }

    public Action register(String key, Action action) {
        return (Action)this.actionRegistry.put((Object)key, (Object)action);
    }

    public Descriptor register(String key, Descriptor descriptor) {
        return (Descriptor)this.descriptorRegistry.put((Object)key, (Object)descriptor);
    }

    public Subject register(String key, Subject subject) {
        return (Subject)this.subjectRegistry.put((Object)key, (Object)subject);
    }
}

