/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.entity.ScriptorEntities;
import com.ssblur.scriptor.entity.ScriptorProjectile;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.descriptor.SpeedDescriptor;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class ProjectileSubject
extends Subject {
    @Override
    public Word.Cost cost() {
        return new Word.Cost(3.0, Word.COSTTYPE.ADDITIVE);
    }

    @Override
    public CompletableFuture<List<Targetable>> getTargets(Targetable caster, Spell spell) {
        CompletableFuture<List<Targetable>> future = new CompletableFuture<List<Targetable>>();
        int color = CustomColors.getColor(spell.deduplicatedDescriptorsForSubjects());
        double duration = 12.0;
        double speed = 1.0;
        for (Descriptor d : spell.deduplicatedDescriptorsForSubjects()) {
            Object descriptor;
            if (d instanceof DurationDescriptor) {
                descriptor = (DurationDescriptor)((Object)d);
                duration += descriptor.durationModifier();
            }
            if (!(d instanceof SpeedDescriptor)) continue;
            descriptor = (SpeedDescriptor)((Object)d);
            speed *= descriptor.speedModifier();
        }
        speed *= 0.8;
        ScriptorProjectile projectile = (ScriptorProjectile)((class_1299)ScriptorEntities.PROJECTILE_TYPE.get()).method_5883(caster.getLevel());
        assert (projectile != null);
        if (caster instanceof EntityTargetable) {
            EntityTargetable entityTargetable = (EntityTargetable)caster;
            class_1297 entity = entityTargetable.getTargetEntity();
            projectile.method_33574(entity.method_33571());
            projectile.method_18799(entity.method_5720().method_1029().method_1021(speed));
            projectile.setOwner(entity);
        } else {
            projectile.method_33574(caster.getTargetPos());
            class_2382 normal = caster.getFacing().method_10163();
            projectile.method_18799(new class_243((double)normal.method_10263(), (double)normal.method_10264(), (double)normal.method_10260()).method_1021(speed));
        }
        projectile.setOrigin(caster.getOrigin());
        projectile.setDuration((int)Math.round(10.0 * duration));
        projectile.setColor(color);
        projectile.setCompletable(future);
        caster.getLevel().method_8649((class_1297)projectile);
        return future;
    }
}

