/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlayerSpellsSavedData
extends class_18 {
    public HashMap<Integer, HashMap<String, Boolean>> spells = new HashMap();
    public HashMap<Integer, HashMap<String, Boolean>> scraps = new HashMap();
    public static final Codec<PlayerSpellsSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("spells").forGetter(data -> {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int i : data.spells.keySet()) {
            for (String s : data.spells.get(i).keySet()) {
                list.add((CallSite)((Object)(i + ":" + s)));
            }
        }
        return list;
    }), (App)Codec.STRING.listOf().fieldOf("scraps").forGetter(data -> {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int i : data.scraps.keySet()) {
            for (String s : data.scraps.get(i).keySet()) {
                list.add((CallSite)((Object)(i + ":" + s)));
            }
        }
        return list;
    })).apply((Applicative)instance, PlayerSpellsSavedData::new));

    public PlayerSpellsSavedData(List<String> spellList, List<String> scrapList) {
        int first;
        String[] split;
        for (String pair : spellList) {
            split = pair.split(":", 2);
            first = Integer.parseInt(split[0]);
            if (!this.spells.containsKey(first)) {
                this.spells.put(first, new HashMap());
            }
            this.spells.get(first).put(split[1], true);
        }
        for (String pair : scrapList) {
            split = pair.split(":", 2);
            first = Integer.parseInt(split[0]);
            if (!this.spells.containsKey(first)) {
                this.spells.put(first, new HashMap());
            }
            this.spells.get(first).put(split[1], true);
        }
    }

    public PlayerSpellsSavedData() {
    }

    public HashMap<String, Boolean> getTier(int tier) {
        if (!this.spells.containsKey(tier)) {
            this.spells.put(tier, new HashMap());
        }
        return this.spells.get(tier);
    }

    public HashMap<String, Boolean> getScrapTier(int tier) {
        if (!this.scraps.containsKey(tier)) {
            this.scraps.put(tier, new HashMap());
        }
        return this.scraps.get(tier);
    }

    public class_2487 method_75(class_2487 tag) {
        Optional result = CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).get().left();
        result.ifPresent(value -> tag.method_10566("scriptor:obtained_spells", value));
        return tag;
    }

    public static PlayerSpellsSavedData load(class_2487 tag) {
        Optional result;
        class_2520 input = tag.method_10580("scriptor:obtained_spells");
        if (input != null && (result = CODEC.decode((DynamicOps)class_2509.field_11560, (Object)input).get().left()).isPresent() && ((Pair)result.get()).getFirst() != null) {
            return (PlayerSpellsSavedData)((Object)((Pair)result.get()).getFirst());
        }
        return null;
    }

    @Nullable
    public static PlayerSpellsSavedData computeIfAbsent(class_1657 player) {
        class_1937 level = player.method_37908();
        MinecraftServer minecraft = level.method_8503();
        if (minecraft == null) {
            return null;
        }
        class_3218 server = minecraft.method_3847(class_1937.field_25179);
        if (server == null) {
            return null;
        }
        try {
            class_26 storage = server.method_17983();
            if (storage == null) {
                return null;
            }
            if (!Files.exists(storage.field_17664.toPath().resolve("scriptor_players"), new LinkOption[0])) {
                Files.createDirectory(storage.field_17664.toPath().resolve("scriptor_players"), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Objects.requireNonNull(server);
        return (PlayerSpellsSavedData)server.method_17983().method_17924(PlayerSpellsSavedData::load, PlayerSpellsSavedData::new, "scriptor_players/spells_" + player.method_5845());
    }
}

