/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.reloadlisteners;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.advancement.ScriptorAdvancements;
import com.ssblur.scriptor.data.PlayerSpellsSavedData;
import com.ssblur.scriptor.events.reloadlisteners.ScriptorReloadListener;
import com.ssblur.scriptor.helpers.resource.TomeResource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class TomeReloadListener
extends ScriptorReloadListener {
    static Type TOME_TYPE = new TypeToken<TomeResource>(){}.getType();
    static Random RANDOM = new Random();
    public static final TomeReloadListener INSTANCE = new TomeReloadListener();
    HashMap<Integer, HashMap<class_2960, TomeResource>> tomes;
    ArrayList<class_2960> keys;

    TomeReloadListener() {
        super("scriptor/tomes");
    }

    public HashMap<Integer, HashMap<class_2960, TomeResource>> getTiers() {
        return this.tomes;
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        this.tomes = new HashMap();
        this.keys = new ArrayList();
        super.apply(object, resourceManager, profilerFiller);
    }

    @Override
    public void loadResource(class_2960 resourceLocation, JsonElement jsonElement) {
        TomeResource resource = (TomeResource)GSON.fromJson(jsonElement, TOME_TYPE);
        if (!this.tomes.containsKey(resource.getTier())) {
            this.tomes.put(resource.getTier(), new HashMap());
        }
        this.keys.add(resourceLocation);
        this.tomes.get(resource.getTier()).put(resourceLocation, resource);
    }

    public TomeResource getRandomTome(int tier) {
        Set<class_2960> keys = this.tomes.get(tier).keySet();
        return this.tomes.get(tier).get(keys.toArray(new class_2960[0])[RANDOM.nextInt(keys.size())]);
    }

    public TomeResource getRandomTome(int tier, class_1657 player) {
        PlayerSpellsSavedData data;
        Set<class_2960> keys = this.tomes.get(tier).keySet();
        if (ScriptorMod.COMMUNITY_MODE) {
            class_1937 level = player.method_37908();
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                int bracket = (int)serverLevel.method_8412() % 5;
                bracket += 10;
                bracket %= 5;
                bracket = Math.min(bracket, keys.size() - 1);
                HashSet<class_2960> filteredKeys = new HashSet<class_2960>();
                class_2960[] array = keys.toArray(new class_2960[0]);
                for (int i = 0; i < keys.size(); ++i) {
                    if (bracket != i % 5) continue;
                    filteredKeys.add(array[i]);
                }
                keys = filteredKeys;
            } else {
                return null;
            }
        }
        if ((data = PlayerSpellsSavedData.computeIfAbsent(player)) != null) {
            class_2960 resource;
            HashMap<String, Boolean> spells = data.getTier(tier);
            if (keys.size() <= spells.size()) {
                switch (tier) {
                    case 1: {
                        ScriptorAdvancements.TOME_1.trigger((class_3222)player);
                        break;
                    }
                    case 2: {
                        ScriptorAdvancements.TOME_2.trigger((class_3222)player);
                        break;
                    }
                    case 3: {
                        ScriptorAdvancements.TOME_3.trigger((class_3222)player);
                        break;
                    }
                    case 4: {
                        ScriptorAdvancements.TOME_4.trigger((class_3222)player);
                    }
                }
                return this.tomes.get(tier).get(keys.toArray(new class_2960[0])[RANDOM.nextInt(keys.size())]);
            }
            class_2960[] keysArray = keys.toArray(new class_2960[0]);
            int maxAttempts = 10;
            do {
                resource = keysArray[RANDOM.nextInt(keys.size())];
            } while (--maxAttempts > 0 && spells.containsKey(resource.method_43903()));
            spells.put(resource.method_43903(), true);
            data.method_80();
            return this.tomes.get(tier).get(resource);
        }
        return this.tomes.get(tier).get(keys.toArray(new class_2960[0])[RANDOM.nextInt(keys.size())]);
    }
}

