/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.ItemTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;

public class ItemTargetableHelper {
    public static class_1799 getTargetItemStack(Targetable targetable, boolean aggressive) {
        InventoryTargetable inventoryTargetable;
        ItemTargetable itemTargetable;
        if (targetable instanceof ItemTargetable && ((itemTargetable = (ItemTargetable)targetable).shouldTargetItem() || aggressive)) {
            return itemTargetable.getTargetItem();
        }
        if (targetable instanceof InventoryTargetable && (inventoryTargetable = (InventoryTargetable)((Object)targetable)).getContainer() != null) {
            int slot = inventoryTargetable.shouldIgnoreTargetedSlot() ? inventoryTargetable.getFirstFilledSlot() : inventoryTargetable.getTargetedSlot();
            return inventoryTargetable.getContainer().method_5438(slot);
        }
        return class_1799.field_8037;
    }

    public static class_1799 getTargetItemStack(Targetable targetable, boolean aggressive, Predicate<class_1799> condition) {
        int slot;
        InventoryTargetable inventoryTargetable;
        ItemTargetable itemTargetable;
        if (targetable instanceof ItemTargetable && ((itemTargetable = (ItemTargetable)targetable).shouldTargetItem() || aggressive)) {
            if (condition.test(itemTargetable.getTargetItem())) {
                return itemTargetable.getTargetItem();
            }
        } else if (targetable instanceof InventoryTargetable && (inventoryTargetable = (InventoryTargetable)((Object)targetable)).getContainer() != null && (slot = inventoryTargetable.shouldIgnoreTargetedSlot() ? inventoryTargetable.getFirstMatchingSlot(condition) : inventoryTargetable.getTargetedSlot()) >= 0 && condition.test(inventoryTargetable.getContainer().method_5438(slot))) {
            return inventoryTargetable.getContainer().method_5438(slot);
        }
        return class_1799.field_8037;
    }

    public static class_1799 getTargetItemStack(Targetable targetable) {
        return ItemTargetableHelper.getTargetItemStack(targetable, false);
    }

    public static class_1799 getTargetItemStackAggressively(Targetable targetable) {
        return ItemTargetableHelper.getTargetItemStack(targetable, true);
    }

    public static void depositItemStack(Targetable targetable, class_1799 itemStack) {
        class_1657 player;
        ItemTargetable itemTargetable;
        class_1297 class_12972;
        InventoryTargetable inventoryTargetable;
        if (targetable instanceof InventoryTargetable && (inventoryTargetable = (InventoryTargetable)((Object)targetable)).getContainer() != null) {
            int slot = inventoryTargetable.getFirstMatchingSlotNotEmpty(itemStack);
            if (slot >= 0) {
                class_1799 item = inventoryTargetable.getContainer().method_5438(slot);
                if (item.method_7947() + itemStack.method_7947() < item.method_7914()) {
                    item.method_7933(itemStack.method_7947());
                    return;
                }
                int diff = item.method_7914() - item.method_7947();
                item.method_7933(diff);
                itemStack.method_7934(diff);
            }
            if ((slot = inventoryTargetable.getFirstMatchingSlot(class_1799::method_7960)) >= 0) {
                inventoryTargetable.getContainer().method_5447(slot, itemStack.method_7972());
                return;
            }
        }
        if (targetable instanceof ItemTargetable && (class_12972 = (itemTargetable = (ItemTargetable)targetable).getTargetEntity()) instanceof class_1657 && (player = (class_1657)class_12972).method_7270(itemStack)) {
            return;
        }
        class_243 pos = targetable.getTargetPos();
        class_1542 entity = new class_1542(targetable.getLevel(), pos.method_10216(), pos.method_10214() + 1.0, pos.method_10215(), itemStack);
        targetable.getLevel().method_8649((class_1297)entity);
    }
}

