/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.item.ScriptorItems;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LimitedBookSerializer {
    static Type PAGE_TYPE = new TypeToken<Page>(){}.getType();

    public static String decodeText(class_2499 text) {
        Gson gson = new Gson();
        StringBuilder builder = new StringBuilder();
        for (class_2520 tag : text) {
            try {
                Page page = (Page)gson.fromJson(tag.method_10714(), PAGE_TYPE);
                builder.append(page.text.strip());
                builder.append(" ");
            }
            catch (Exception page) {
                try {
                    String string = (String)gson.fromJson(tag.method_10714(), String.class);
                    builder.append(string.strip());
                    builder.append(" ");
                }
                catch (Exception e) {
                    builder.append(tag.toString());
                    builder.append(" ");
                }
            }
        }
        return builder.toString().stripTrailing();
    }

    public static String decodeText(String text) {
        Gson gson = new Gson();
        try {
            Page page = (Page)gson.fromJson(text, PAGE_TYPE);
            return page.text.strip();
        }
        catch (Exception page) {
            try {
                String string = (String)gson.fromJson(text, String.class);
                return string.strip();
            }
            catch (Exception e) {
                return "Error parsing text: \"" + text + "\".";
            }
        }
    }

    public static class_2499 encodeText(String text) {
        Gson gson = new Gson();
        ArrayList<Page> list = new ArrayList<Page>();
        String[] tokens = text.split("\\s+");
        int pageLength = 0;
        StringBuilder page = new StringBuilder();
        for (String token : tokens) {
            if (token.length() >= 96) {
                pageLength = 0;
                list.add(new Page(page.toString()));
                list.add(new Page(token));
                page = new StringBuilder();
                continue;
            }
            if (token.length() + page.length() >= 96) {
                pageLength = token.length();
                list.add(new Page(page.toString()));
                page = new StringBuilder();
                page.append(token);
                page.append(" ");
                continue;
            }
            pageLength += token.length();
            page.append(token);
            page.append(" ");
        }
        if (!page.isEmpty()) {
            list.add(new Page(page.toString()));
        }
        class_2499 tag = new class_2499();
        for (Page p : list) {
            tag.add((Object)class_2519.method_23256((String)gson.toJson((Object)p)));
        }
        return tag;
    }

    public static class_1799 createSpellbook(String author, String title, String text, @Nullable String item) {
        class_2487 tag = new class_2487();
        tag.method_10582("author", author);
        tag.method_10582("title", title);
        tag.method_10566("pages", (class_2520)LimitedBookSerializer.encodeText(text));
        if (ScriptorMod.COMMUNITY_MODE) {
            class_2487 scriptor = new class_2487();
            scriptor.method_10556("community", true);
            tag.method_10566("scriptor", (class_2520)scriptor);
        }
        class_1799 itemStack = item != null ? new class_1799((class_1935)Objects.requireNonNull((class_1792)ScriptorItems.ITEMS.getRegistrar().get(new class_2960(item)))) : new class_1799((class_1935)ScriptorItems.SPELLBOOK.get());
        itemStack.method_7939(1);
        itemStack.method_7980(tag);
        return itemStack;
    }

    static class Page {
        String text;

        public Page(String text) {
            this.text = text;
        }
    }
}

