/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.block.CastingLecternBlock;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.events.network.ParticleNetwork;
import com.ssblur.scriptor.gamerules.ScriptorGameRules;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.helpers.targetable.LecternTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.item.casters.CasterCrystal;
import com.ssblur.scriptor.word.Spell;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CastingLecternBlockEntity
extends BlockEntity {
    public static final int SPELLBOOK_SLOT = 0;
    public static final int CASTING_FOCUS_SLOT = 1;
    NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    int focusTarget;
    int cooldown;

    public CastingLecternBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ScriptorBlockEntities.CASTING_LECTERN.get(), blockPos, blockState);
    }

    public ItemStack getSpellbook() {
        return (ItemStack)this.items.get(0);
    }

    public void setSpellbook(ItemStack itemStack) {
        this.items.set(0, (Object)itemStack);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    public ItemStack getFocus() {
        return (ItemStack)this.items.get(1);
    }

    public void setFocus(ItemStack itemStack) {
        this.items.set(1, (Object)itemStack);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void tick() {
        ItemStack item;
        CompoundTag tag;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.cooldown = Math.max(0, this.cooldown - 1);
        if (this.f_58857_.m_277173_(this.m_58899_()) == 0 && !this.getSpellbook().m_41619_() && this.cooldown == 0 && (tag = (item = this.getSpellbook()).m_41783_()) instanceof CompoundTag) {
            CompoundTag compound = tag;
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                ListTag text = compound.m_128437_("pages", 8);
                Spell spell = DictionarySavedData.computeIfAbsent(server).parse(LimitedBookSerializer.decodeText(text));
                if (spell != null) {
                    CasterCrystal crystal;
                    List<Targetable> foci;
                    if (spell.cost() > (double)this.f_58857_.m_46469_().m_46215_(ScriptorGameRules.CASTING_LECTERN_MAX_COST)) {
                        ParticleNetwork.fizzle(this.f_58857_, this.m_58899_());
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.4f + 0.8f);
                        this.cooldown += (int)Math.round(200.0 * ((double)this.f_58857_.m_46469_().m_46215_(ScriptorGameRules.CASTING_LECTERN_COOLDOWN_MULTIPLIER) / 100.0));
                        return;
                    }
                    BlockState state = this.f_58857_.m_8055_(this.m_58899_());
                    Direction direction = ((Direction)state.m_61143_((Property)CastingLecternBlock.FACING)).m_122424_();
                    BlockPos blockPos = this.m_58899_();
                    Vec3 pos = blockPos.m_252807_();
                    Targetable target = new LecternTargetable(this.m_58904_(), pos).setFacing(direction);
                    Item item2 = this.getFocus().m_41720_();
                    if (item2 instanceof CasterCrystal && (foci = (crystal = (CasterCrystal)item2).getTargetables(this.getFocus(), this.f_58857_)).size() > 0) {
                        ++this.focusTarget;
                        this.focusTarget %= foci.size();
                        Targetable focus = foci.get(this.focusTarget);
                        if (focus.getTargetPos().m_82554_(target.getTargetPos()) <= 16.0 && focus.getLevel() == this.f_58857_) {
                            target.setFinalTargetable(focus);
                        }
                    }
                    spell.cast(target);
                    this.cooldown += (int)Math.round(spell.cost() * 10.0 * ((double)this.f_58857_.m_46469_().m_46215_(ScriptorGameRules.CASTING_LECTERN_COOLDOWN_MULTIPLIER) / 100.0));
                }
            }
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof CastingLecternBlockEntity) {
            CastingLecternBlockEntity tile = (CastingLecternBlockEntity)entity;
            tile.tick();
        }
    }
}

