/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.events.network.ParticleNetwork;
import com.ssblur.scriptor.gamerules.ScriptorGameRules;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChalkBlockEntity
extends BlockEntity {
    String word = "";
    Direction facing = Direction.EAST;

    public ChalkBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ScriptorBlockEntities.CHALK.get(), blockPos, blockState);
    }

    public ChalkBlockEntity(BlockEntityType blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void cast() {
        this.cast(new ArrayList<BlockPos>(), "", true);
    }

    public void cast(List<BlockPos> visited, String words, boolean primary) {
        ChalkBlockEntity entity;
        BlockEntity blockEntity;
        boolean continued = false;
        assert (this.f_58857_ != null);
        visited.add(this.m_58899_());
        if (!visited.contains(this.m_58899_().m_122012_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122012_())) instanceof ChalkBlockEntity) {
            entity = (ChalkBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, primary);
            continued = true;
        }
        if (!visited.contains(this.m_58899_().m_122019_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122019_())) instanceof ChalkBlockEntity) {
            entity = (ChalkBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, !continued && primary);
            continued = true;
        }
        if (!visited.contains(this.m_58899_().m_122029_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122029_())) instanceof ChalkBlockEntity) {
            entity = (ChalkBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, !continued && primary);
            continued = true;
        }
        if (!visited.contains(this.m_58899_().m_122024_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122024_())) instanceof ChalkBlockEntity) {
            entity = (ChalkBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, !continued && primary);
            continued = true;
        }
        if (continued) {
            return;
        }
        blockEntity = this.f_58857_;
        if (blockEntity instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)blockEntity;
            words = (String)words + " " + this.word;
            Spell spell = DictionarySavedData.computeIfAbsent(server).parse(((String)words).trim());
            if (spell != null && spell.cost() < (double)server.m_46469_().m_46215_(ScriptorGameRules.CHALK_MAX_COST)) {
                Targetable target = new Targetable(this.f_58857_, this.m_58899_());
                target.setFacing(this.facing);
                for (BlockPos block : visited) {
                    this.f_58857_.m_46597_(block, Blocks.f_50016_.m_49966_());
                }
                this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
                spell.cast(target);
            } else if (primary) {
                ParticleNetwork.fizzle(this.f_58857_, visited.get(0));
                this.f_58857_.m_5594_(null, visited.get(0), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.4f + 0.8f);
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128359_("scriptor:word", this.word);
        tag.m_128405_("scriptor:facing", this.facing.ordinal());
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.word = tag.m_128461_("scriptor:word");
        this.facing = Direction.values()[tag.m_128451_("scriptor:facing")];
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("scriptor:word", this.word);
        tag.m_128405_("scriptor:facing", this.facing.ordinal());
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String getWord() {
        return this.word;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
    }

    public Direction getFacing() {
        return this.facing;
    }
}

