/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.blockentity.ChalkBlockEntity;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.events.network.ParticleNetwork;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EngravingBlockEntity
extends ChalkBlockEntity {
    int cooldown;

    public EngravingBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ScriptorBlockEntities.ENGRAVING.get(), blockPos, blockState);
    }

    @Override
    public void cast(List<BlockPos> visited, String words, boolean primary) {
        EngravingBlockEntity entity;
        BlockEntity blockEntity;
        if (this.cooldown > 0) {
            ParticleNetwork.fizzle(this.f_58857_, this.m_58899_());
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.4f + 0.8f);
            return;
        }
        boolean continued = false;
        assert (this.f_58857_ != null);
        visited.add(this.m_58899_());
        if (!visited.contains(this.m_58899_().m_122012_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122012_())) instanceof EngravingBlockEntity) {
            entity = (EngravingBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, primary);
            continued = true;
        }
        if (!visited.contains(this.m_58899_().m_122019_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122019_())) instanceof EngravingBlockEntity) {
            entity = (EngravingBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, !continued && primary);
            continued = true;
        }
        if (!visited.contains(this.m_58899_().m_122029_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122029_())) instanceof EngravingBlockEntity) {
            entity = (EngravingBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, !continued && primary);
            continued = true;
        }
        if (!visited.contains(this.m_58899_().m_122024_()) && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122024_())) instanceof EngravingBlockEntity) {
            entity = (EngravingBlockEntity)blockEntity;
            entity.cast(visited, (String)words + " " + this.word, !continued && primary);
            continued = true;
        }
        if (continued) {
            return;
        }
        blockEntity = this.f_58857_;
        if (blockEntity instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)blockEntity;
            words = (String)words + " " + this.word;
            Spell spell = DictionarySavedData.computeIfAbsent(server).parse(((String)words).trim());
            if (spell != null) {
                Targetable target = new Targetable(this.f_58857_, this.m_58899_());
                target.setFacing(this.facing);
                for (BlockPos block : visited) {
                    BlockEntity blockEntity2 = this.f_58857_.m_7702_(block);
                    if (!(blockEntity2 instanceof EngravingBlockEntity)) continue;
                    EngravingBlockEntity engraving = (EngravingBlockEntity)blockEntity2;
                    engraving.cooldown = (int)((double)engraving.cooldown + spell.cost() * 20.0);
                }
                this.cooldown = (int)((double)this.cooldown + spell.cost() * 20.0);
                spell.cast(target);
            } else if (primary) {
                ParticleNetwork.fizzle(this.f_58857_, visited.get(0));
                this.f_58857_.m_5594_(null, visited.get(0), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.4f + 0.8f);
            }
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof EngravingBlockEntity) {
            EngravingBlockEntity tile = (EngravingBlockEntity)entity;
            tile.cooldown = Math.max(0, tile.cooldown - 1);
        }
    }
}

