/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.block.EngravingBlock;
import com.ssblur.scriptor.block.GenerateBlock;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.EngravingBlockEntity;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.events.reloadlisteners.EngravingReloadListener;
import com.ssblur.scriptor.helpers.resource.EngravingResource;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GenerateBlockEntity
extends BlockEntity {
    public GenerateBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ScriptorBlockEntities.GENERATE.get(), blockPos, blockState);
    }

    static void generateEngraving(ServerLevel level, BlockPos pos) {
        Direction dir;
        Random random = new Random();
        EngravingResource engraving = EngravingReloadListener.INSTANCE.getRandomEngraving();
        String[] words = DictionarySavedData.computeIfAbsent(level).generate(engraving.getSpell()).split(" ");
        Direction last = dir = Direction.m_122387_((Direction.Axis)(random.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z), (Direction.AxisDirection)(random.nextBoolean() ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
        BlockPos curPos = pos;
        boolean forward = false;
        boolean first = true;
        for (String word : words) {
            if (forward) {
                GenerateBlockEntity.engrave(level, curPos, word, false);
                curPos = pos.m_121945_(dir);
                forward = false;
                continue;
            }
            if (last == dir) {
                switch (random.nextInt(3)) {
                    case 0: {
                        last = dir;
                        break;
                    }
                    case 1: {
                        last = dir.m_122427_();
                        break;
                    }
                    case 2: {
                        last = dir.m_122428_();
                    }
                }
            } else if (random.nextBoolean()) {
                last = dir;
                forward = true;
            }
            GenerateBlockEntity.engrave(level, curPos, word, first);
            first = false;
            curPos = curPos.m_121945_(last);
        }
    }

    static void engrave(ServerLevel level, BlockPos pos, String word, boolean bold) {
        if (!level.m_8055_(pos.m_7918_(0, -1, 0)).m_280296_()) {
            level.m_46597_(pos.m_7918_(0, -1, 0), Blocks.f_50069_.m_49966_());
        }
        BlockState blockState = ((Block)ScriptorBlocks.ENGRAVING.get()).m_49966_();
        if (bold) {
            blockState = (BlockState)blockState.m_61124_((Property)EngravingBlock.HIGHLIGHT, (Comparable)Boolean.valueOf(true));
        }
        level.m_46597_(pos, blockState);
        EngravingBlockEntity entity = new EngravingBlockEntity(pos, blockState);
        entity.setWord(word);
        level.m_151523_((BlockEntity)entity);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T entity) {
        if (level.f_46443_) {
            return;
        }
        if (state.m_61143_(GenerateBlock.FEATURE) == GenerateBlock.Feature.ENGRAVING) {
            GenerateBlockEntity.generateEngraving((ServerLevel)level, pos);
        }
    }
}

