/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PhasedBlockBlockEntity
extends BlockEntity {
    static final int ANIM_DURATION = 5;
    CompoundTag data;
    BlockState blockState;
    int countdown = -1;
    long created = -1L;

    public PhasedBlockBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ScriptorBlockEntities.PHASED_BLOCK.get(), blockPos, blockState);
    }

    public void tick() {
        --this.countdown;
        if (this.countdown <= 0 && this.f_58857_ != null) {
            BlockEntity entity;
            this.f_58857_.m_46597_(this.m_58899_(), this.blockState);
            if (this.data != null && (entity = BlockEntity.m_155241_((BlockPos)this.m_58899_(), (BlockState)this.blockState, (CompoundTag)this.data)) != null) {
                this.f_58857_.m_151523_(entity);
            }
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof PhasedBlockBlockEntity) {
            PhasedBlockBlockEntity tile = (PhasedBlockBlockEntity)entity;
            tile.tick();
        }
    }

    public static void phase(Level level, BlockPos pos) {
        PhasedBlockBlockEntity.phase(level, pos, 5);
    }

    public static void phase(Level level, BlockPos pos, int duration) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PhasedBlockBlockEntity) {
            PhasedBlockBlockEntity blockEntity2 = (PhasedBlockBlockEntity)blockEntity;
            blockEntity2.countdown = duration;
            return;
        }
        BlockState state = level.m_8055_(pos);
        BlockEntity entity = level.m_7702_(pos);
        if (state.m_60713_(Blocks.f_50752_) || state.m_278721_() || state.m_60795_()) {
            return;
        }
        BlockState newState = ((Block)ScriptorBlocks.PHASED_BLOCK.get()).m_49966_();
        PhasedBlockBlockEntity newEntity = new PhasedBlockBlockEntity(pos, newState);
        newEntity.blockState = state;
        if (entity != null) {
            newEntity.data = entity.m_187480_();
        }
        newEntity.countdown = duration;
        level.m_46747_(pos);
        level.m_46597_(pos, newState);
        level.m_151523_((BlockEntity)newEntity);
        level.m_7260_(pos, newState, newState, 7);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.data = tag.m_128469_("data");
        Tag state = tag.m_128423_("blockState");
        BlockState.f_61039_.decode((DynamicOps)NbtOps.f_128958_, (Object)state).result().ifPresent(result -> {
            this.blockState = (BlockState)result.getFirst();
        });
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.data != null) {
            tag.m_128365_("data", (Tag)this.data);
        }
        DataResult state = BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.blockState);
        state.result().ifPresent(result -> tag.m_128365_("blockState", result));
    }

    public BlockState getPhasedBlockState() {
        return this.blockState;
    }

    public float getAnim() {
        if (this.f_58857_ == null) {
            return 0.0f;
        }
        if (this.created == -1L) {
            this.created = this.f_58857_.m_46467_();
        }
        float f = 1.0f;
        long anim = Math.min(5L, this.f_58857_.m_46467_() - this.created);
        if (this.countdown == -1) {
            return (float)anim / 5.0f;
        }
        return Math.min((float)anim, (float)this.countdown * f) / 5.0f;
    }
}

