/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.color.interfaces.Colorable;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class RuneBlockEntity
extends BlockEntity
implements Colorable {
    public Entity owner;
    public UUID ownerUUID;
    public Spell spell;
    public String spellText;
    public CompletableFuture<List<Targetable>> future;
    public int color;
    boolean unloadedSpell = true;

    public RuneBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ScriptorBlockEntities.RUNE.get(), blockPos, blockState);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("com/ssblur/scriptor/color", this.color);
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.color = tag.m_128451_("com/ssblur/scriptor/color");
        if (tag.m_128441_("spell")) {
            this.spellText = tag.m_128461_("spell");
        } else {
            this.unloadedSpell = false;
        }
        if (tag.m_128441_("owner")) {
            this.ownerUUID = UUID.fromString(tag.m_128461_("owner"));
        }
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.spell != null) {
                tag.m_128359_("spell", DictionarySavedData.computeIfAbsent(server).generate(this.spell));
            }
        }
        if (this.owner != null && this.owner.m_20148_() != null) {
            tag.m_128359_("owner", this.owner.m_20149_());
        } else if (this.ownerUUID != null) {
            tag.m_128359_("owner", this.ownerUUID.toString());
        }
        tag.m_128405_("com/ssblur/scriptor/color", this.color);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 40L == 0L && this.owner == null && this.ownerUUID != null && this.f_58857_.m_46003_(this.ownerUUID) != null) {
            this.owner = this.f_58857_.m_46003_(this.ownerUUID);
            Spell spell = DictionarySavedData.computeIfAbsent((ServerLevel)this.f_58857_).parse(this.spellText);
            if (spell != null) {
                this.future = this.owner != null ? spell.createFuture(new EntityTargetable(this.owner)) : spell.createFuture(new Targetable(this.f_58857_, this.m_58899_()));
            }
        }
        if (this.future == null || this.future.isDone()) {
            if (this.spell != null) {
                this.future = this.owner != null && this.owner.m_6084_() ? this.spell.createFuture(new EntityTargetable(this.owner)) : this.spell.createFuture(new Targetable(this.f_58857_, this.m_58899_()));
            } else if (this.spellText != null) {
                this.spell = DictionarySavedData.computeIfAbsent((ServerLevel)this.f_58857_).parse(this.spellText);
                if (this.spell != null) {
                    this.future = this.owner == null ? this.spell.createFuture(new Targetable(this.f_58857_, this.f_58858_)) : this.spell.createFuture(new EntityTargetable(this.owner));
                }
            }
        }
        double xMin = this.f_58858_.m_123341_() >= 0 ? 0.2 : -0.8;
        double zMin = this.f_58858_.m_123343_() >= 0 ? 0.2 : -0.8;
        double xMax = this.f_58858_.m_123341_() >= 0 ? 0.6 : -0.4;
        double zMax = this.f_58858_.m_123343_() >= 0 ? 0.6 : -0.4;
        AABB box = AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i((int)((double)this.f_58858_.m_123341_() + xMin), (int)((double)this.f_58858_.m_123342_() + 0.0), (int)((double)this.f_58858_.m_123343_() + zMin)), (Vec3i)new Vec3i((int)((double)this.f_58858_.m_123341_() + xMax), (int)((double)this.f_58858_.m_123342_() + 0.0625), (int)((double)this.f_58858_.m_123343_() + zMax))));
        List entities = this.f_58857_.m_45933_(null, box);
        if (entities.size() > 0) {
            ArrayList<EntityTargetable> targets = new ArrayList<EntityTargetable>();
            for (Entity entity : entities) {
                targets.add(new EntityTargetable(entity));
            }
            if (this.future != null) {
                this.future.complete(targets);
            }
            this.f_58857_.m_7471_(this.f_58858_, true);
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof RuneBlockEntity) {
            RuneBlockEntity tile = (RuneBlockEntity)entity;
            tile.tick();
        }
    }

    @Override
    public void setColor(int color) {
        this.color = color;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

