/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity.renderers;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ssblur.scriptor.blockentity.PhasedBlockBlockEntity;
import com.ssblur.scriptor.mixin.BlockRenderDispatcherAccessor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class PhasedBlockBlockEntityRenderer
implements BlockEntityRenderer<PhasedBlockBlockEntity> {
    BlockEntityRendererProvider.Context context;

    public PhasedBlockBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(PhasedBlockBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        float ba;
        float ga;
        float ra;
        BlockState blockState = blockEntity.getPhasedBlockState();
        Level level = blockEntity.m_58904_();
        if (blockState == null || level == null) {
            return;
        }
        BlockRenderDispatcher dispatcher = this.context.m_173584_();
        VertexConsumer buffer = multiBufferSource.m_6299_(Sheets.m_110792_());
        BakedModel model = dispatcher.m_110910_(blockState);
        RandomSource randomSource = RandomSource.m_216327_();
        PoseStack.Pose pose = poseStack.m_85850_();
        int color = ((BlockRenderDispatcherAccessor)dispatcher).getBlockColors().m_92577_(blockState, null, null, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 1.0f - 0.8f * blockEntity.getAnim();
        for (Direction direction : Direction.values()) {
            randomSource.m_188584_(42L);
            for (BakedQuad bakedQuad : model.m_213637_(blockState, direction, randomSource)) {
                if (bakedQuad.m_111304_()) {
                    ra = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
                    ga = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
                    ba = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
                } else {
                    ra = 1.0f;
                    ga = 1.0f;
                    ba = 1.0f;
                }
                this.putBulkData(buffer, pose, bakedQuad, ra, ga, ba, a, i, j);
            }
        }
        randomSource.m_188584_(42L);
        for (BakedQuad bakedQuad : model.m_213637_(blockState, null, randomSource)) {
            if (bakedQuad.m_111304_()) {
                ra = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
                ga = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
                ba = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
            } else {
                ra = 1.0f;
                ga = 1.0f;
                ba = 1.0f;
            }
            this.putBulkData(buffer, pose, bakedQuad, ra, ga, ba, a, i, j);
        }
    }

    public void putBulkData(VertexConsumer consumer, PoseStack.Pose pose, BakedQuad bakedQuad, float f, float g, float h, float a, int i, int j) {
        this.putBulkData(consumer, pose, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, f, g, h, a, new int[]{i, i, i, i}, j, false);
    }

    public void putBulkData(VertexConsumer consumer, PoseStack.Pose pose, BakedQuad bakedQuad, float[] fs, float f, float g, float h, float a, int[] is, int i, boolean bl) {
        float[] gs = new float[]{fs[0], fs[1], fs[2], fs[3]};
        int[] js = new int[]{is[0], is[1], is[2], is[3]};
        int[] ks = bakedQuad.m_111303_();
        Vec3i vec3i = bakedQuad.m_111306_().m_122436_();
        Matrix4f matrix4f = pose.m_252922_();
        Vector3f vector3f = pose.m_252943_().transform(new Vector3f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_()));
        int j = 8;
        int k = ks.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int l = 0; l < k; ++l) {
                float u;
                float t;
                float s;
                float r;
                float q;
                intBuffer.clear();
                intBuffer.put(ks, l * 8, 8);
                float m = byteBuffer.getFloat(0);
                float n = byteBuffer.getFloat(4);
                float o = byteBuffer.getFloat(8);
                if (bl) {
                    float p = (float)(byteBuffer.get(12) & 0xFF) / 255.0f;
                    q = (float)(byteBuffer.get(13) & 0xFF) / 255.0f;
                    r = (float)(byteBuffer.get(14) & 0xFF) / 255.0f;
                    s = p * gs[l] * f;
                    t = q * gs[l] * g;
                    u = r * gs[l] * h;
                } else {
                    s = gs[l] * f;
                    t = gs[l] * g;
                    u = gs[l] * h;
                }
                int v = js[l];
                q = byteBuffer.getFloat(16);
                r = byteBuffer.getFloat(20);
                Vector4f vector4f = matrix4f.transform(new Vector4f(m, n, o, 1.0f));
                consumer.m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), s, t, u, a, q, r, i, v, vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
    }
}

