/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity.renderers;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.ssblur.scriptor.blockentity.RuneBlockEntity;
import com.ssblur.scriptor.color.CustomColors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RuneBlockEntityRenderer
implements BlockEntityRenderer<RuneBlockEntity> {
    static ResourceLocation magicCircle = new ResourceLocation("scriptor", "textures/entity/magic_circle.png");
    static ResourceLocation emptyCircle = new ResourceLocation("scriptor", "textures/entity/empty_circle.png");
    static RenderType magicLayer = RenderType.m_173215_((String)"scriptor:rune", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)64, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(magicCircle, false, false)).m_110661_(new RenderStateShard.CullStateShard(false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_173292_(RenderStateShard.f_173101_).m_110691_(true));
    static RenderType emptyLayer = RenderType.m_173215_((String)"scriptor:circle", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)64, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(emptyCircle, false, false)).m_110661_(new RenderStateShard.CullStateShard(false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_173292_(RenderStateShard.f_173101_).m_110691_(true));

    public RuneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RuneBlockEntity rune, float tickDelta, PoseStack matrix, MultiBufferSource buffers, int light, int j) {
        if (rune.m_58904_() == null) {
            return;
        }
        matrix.m_85836_();
        int c = CustomColors.getColor(rune.color, (float)rune.m_58904_().m_46467_() + tickDelta);
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91073_ != null);
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        float yo = 0.0625f;
        matrix.m_252880_(0.0f, yo, 0.0f);
        Matrix4f pose = matrix.m_85850_().m_252922_();
        VertexConsumer buffer = buffers.m_6299_(magicLayer);
        int cycle = 240;
        double rot = rune.m_58904_().m_46467_() % (long)cycle;
        rot = (rot + (double)tickDelta) / (double)cycle * 2.0 * Math.PI;
        double R = 0.5;
        float x = (float)(R * Math.cos(rot));
        float y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        buffer = buffers.m_6299_(emptyLayer);
        R = 0.2;
        x = (float)(R * Math.cos(rot *= -1.0));
        y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.m_252986_(pose, x + 0.5f, 0.0f, y + 0.5f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        matrix.m_85849_();
    }
}

