/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.color;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.word.descriptor.color.ColorDescriptor;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;

public class CustomColors {
    public static CustomColors INSTANCE = new CustomColors();
    HashMap<Integer, Function<Float, Integer>> registry = new HashMap();
    int currentNumber = 0;
    HashMap<String, Integer> colors = new HashMap();

    public void reset() {
        this.currentNumber = 0;
        this.colors = new HashMap();
        this.registry = new HashMap();
        INSTANCE.register("rainbow", tick -> {
            float s = tick.floatValue() % 31.0f;
            s /= 93.0f;
            float b = tick.floatValue() % 23.0f;
            b /= 46.0f;
            tick = Float.valueOf(tick.floatValue() % 40.0f);
            return Color.getHSBColor(tick.floatValue() / 40.0f, s += 0.75f, b += 0.5f).getRGB();
        });
    }

    public void putColor(int index, String key, int[] colors) {
        this.colors.put(key, index);
        this.registry.put(index, CustomColors.createCustomColor(colors));
    }

    public int register(String value, Function<Float, Integer> color) {
        --this.currentNumber;
        this.colors.put(value, this.currentNumber);
        this.registry.put(this.currentNumber, color);
        return this.currentNumber;
    }

    public static int registerWithEasing(String key, int[] values) {
        return INSTANCE.register(key, CustomColors.createCustomColor(values));
    }

    public static int getKey(String key) {
        return CustomColors.INSTANCE.colors.get(key);
    }

    public static int getColor(int color, float tick) {
        if (color > 0) {
            return color;
        }
        if (CustomColors.INSTANCE.registry.containsKey(color)) {
            return CustomColors.INSTANCE.registry.get(color).apply(Float.valueOf(tick));
        }
        return 0;
    }

    public static int getColor(Iterable<Descriptor> descriptors) {
        long r = 0L;
        long g = 0L;
        long b = 0L;
        long a = 0L;
        int colorN = 0;
        for (Descriptor d : descriptors) {
            if (!(d instanceof ColorDescriptor)) continue;
            ColorDescriptor descriptor = (ColorDescriptor)d;
            if (descriptor.getColor() >= 0) {
                ++colorN;
                int c = descriptor.getColor();
                b += (long)(c & 0xFF);
                g += (long)(c >> 8 & 0xFF);
                r += (long)(c >> 16 & 0xFF);
                a += (long)(c >> 24 & 0xFF);
                continue;
            }
            return descriptor.getColor();
        }
        if (colorN == 0) {
            return 10494192;
        }
        return (int)(((a /= (long)colorN) << 24) + ((r /= (long)colorN) << 16) + ((g /= (long)colorN) << 8) + (b /= (long)colorN));
    }

    public static int getColor(Descriptor[] descriptors) {
        return CustomColors.getColor(Arrays.stream(descriptors).toList());
    }

    static int ease(int from, int to, float partial) {
        partial = (float)Math.pow(partial, 5.0);
        int bA = from & 0xFF;
        int gA = from >> 8 & 0xFF;
        int rA = from >> 16 & 0xFF;
        int aA = from >> 24 & 0xFF;
        int bB = to & 0xFF;
        int gB = to >> 8 & 0xFF;
        int rB = to >> 16 & 0xFF;
        int aB = to >> 24 & 0xFF;
        int b = (int)((float)bA * partial + (float)bB * (1.0f - partial));
        int g = (int)((float)gA * partial + (float)gB * (1.0f - partial));
        int r = (int)((float)rA * partial + (float)rB * (1.0f - partial));
        int a = (int)((float)aA * partial + (float)aB * (1.0f - partial));
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    static Function<Float, Integer> createCustomColor(int[] list) {
        return tick -> {
            float partial = tick.floatValue() % 60.0f / 60.0f;
            tick = Float.valueOf(tick.floatValue() / 60.0f);
            tick = Float.valueOf(tick.floatValue() % (float)list.length);
            int index = tick.intValue();
            int color = list[index];
            int nextColor = list[(index + 1) % list.length];
            return CustomColors.ease(nextColor, color, partial);
        };
    }

    public static DyeColor getDyeColor(int color, float tick) {
        int distance = -1;
        DyeColor dyeColor = DyeColor.WHITE;
        int c = CustomColors.getColor(color, tick);
        int b = c & 0xFF;
        int g = c >> 8 & 0xFF;
        int r = c >> 16 & 0xFF;
        for (DyeColor dye : DyeColor.values()) {
            int cD = dye.m_41070_();
            int bD = cD & 0xFF;
            int gD = cD >> 8 & 0xFF;
            int rD = cD >> 16 & 0xFF;
            int d = (int)Math.sqrt(Math.pow(b - bD, 2.0) + Math.pow(g - gD, 2.0) + Math.pow(r - rD, 2.0));
            if (d >= distance && distance != -1) continue;
            dyeColor = dye;
            distance = d;
        }
        return dyeColor;
    }

    static {
        INSTANCE.reset();
    }
}

