/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.color;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.color.interfaces.ColorableBlock;
import com.ssblur.scriptor.registry.colorable.ColorableBlockRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DyeColorableBlock
implements ColorableBlock {
    BiMap<DyeColor, Block> blocks = HashBiMap.create();
    Random random = new Random();

    @Override
    public void setColor(int color, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        level.m_7731_(blockPos, ((Block)this.blocks.get((Object)CustomColors.getDyeColor(color, level.m_46467_()))).m_152465_(level.m_8055_(blockPos)), 2);
        if (blockEntity != null) {
            level.m_46747_(blockPos);
            level.m_151523_(blockEntity);
        }
    }

    @Override
    public ItemStack setColor(int color, ItemStack itemStack) {
        Block block = (Block)this.blocks.get((Object)CustomColors.getDyeColor(color, Math.abs(this.random.nextInt())));
        CompoundTag tag = itemStack.m_41783_();
        int count = itemStack.m_41613_();
        ItemStack itemOut = new ItemStack((ItemLike)block);
        itemOut.m_41764_(count);
        itemOut.m_41751_(tag);
        return itemOut;
    }

    public void add(Block block, DyeColor dyeColor) {
        this.blocks.put((Object)dyeColor, (Object)block);
    }

    public void register() {
        for (Block entry : this.blocks.values()) {
            ColorableBlockRegistry.register(entry, this);
        }
    }
}

