/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;

public class PlayerSpellsSavedData
extends SavedData {
    public HashMap<Integer, HashMap<String, Boolean>> spells = new HashMap();
    public HashMap<Integer, HashMap<String, Boolean>> scraps = new HashMap();
    public static final Codec<PlayerSpellsSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("spells").forGetter(data -> {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int i : data.spells.keySet()) {
            for (String s : data.spells.get(i).keySet()) {
                list.add((CallSite)((Object)(i + ":" + s)));
            }
        }
        return list;
    }), (App)Codec.STRING.listOf().fieldOf("scraps").forGetter(data -> {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int i : data.scraps.keySet()) {
            for (String s : data.scraps.get(i).keySet()) {
                list.add((CallSite)((Object)(i + ":" + s)));
            }
        }
        return list;
    })).apply((Applicative)instance, PlayerSpellsSavedData::new));

    public PlayerSpellsSavedData(List<String> spellList, List<String> scrapList) {
        int first;
        String[] split;
        for (String pair : spellList) {
            split = pair.split(":", 2);
            first = Integer.parseInt(split[0]);
            if (!this.spells.containsKey(first)) {
                this.spells.put(first, new HashMap());
            }
            this.spells.get(first).put(split[1], true);
        }
        for (String pair : scrapList) {
            split = pair.split(":", 2);
            first = Integer.parseInt(split[0]);
            if (!this.spells.containsKey(first)) {
                this.spells.put(first, new HashMap());
            }
            this.spells.get(first).put(split[1], true);
        }
    }

    public PlayerSpellsSavedData() {
    }

    public HashMap<String, Boolean> getTier(int tier) {
        if (!this.spells.containsKey(tier)) {
            this.spells.put(tier, new HashMap());
        }
        return this.spells.get(tier);
    }

    public HashMap<String, Boolean> getScrapTier(int tier) {
        if (!this.scraps.containsKey(tier)) {
            this.scraps.put(tier, new HashMap());
        }
        return this.scraps.get(tier);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        Optional result = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).get().left();
        result.ifPresent(value -> tag.m_128365_("scriptor:obtained_spells", value));
        return tag;
    }

    public static PlayerSpellsSavedData load(CompoundTag tag) {
        Optional result;
        Tag input = tag.m_128423_("scriptor:obtained_spells");
        if (input != null && (result = CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)input).get().left()).isPresent() && ((Pair)result.get()).getFirst() != null) {
            return (PlayerSpellsSavedData)((Object)((Pair)result.get()).getFirst());
        }
        return null;
    }

    @Nullable
    public static PlayerSpellsSavedData computeIfAbsent(Player player) {
        Level level = player.m_9236_();
        MinecraftServer minecraft = level.m_7654_();
        if (minecraft == null) {
            return null;
        }
        ServerLevel server = minecraft.m_129880_(Level.f_46428_);
        if (server == null) {
            return null;
        }
        try {
            DimensionDataStorage storage = server.m_8895_();
            if (storage == null) {
                return null;
            }
            if (!Files.exists(storage.f_78146_.toPath().resolve("scriptor_players"), new LinkOption[0])) {
                Files.createDirectory(storage.f_78146_.toPath().resolve("scriptor_players"), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Objects.requireNonNull(server);
        return (PlayerSpellsSavedData)server.m_8895_().m_164861_(PlayerSpellsSavedData::load, PlayerSpellsSavedData::new, "scriptor_players/spells_" + player.m_20149_());
    }
}

