/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.entity;

import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ScriptorProjectile
extends Entity {
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(ScriptorProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ScriptorProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OWNER = SynchedEntityData.m_135353_(ScriptorProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    CompletableFuture<List<Targetable>> completable;
    Vec3 origin;

    public ScriptorProjectile(EntityType<ScriptorProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void setCompletable(CompletableFuture<List<Targetable>> completable) {
        this.completable = completable;
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DURATION, (Object)duration);
    }

    public void setOwner(int owner) {
        this.f_19804_.m_135381_(OWNER, (Object)owner);
    }

    public void setOwner(Entity owner) {
        this.f_19804_.m_135381_(OWNER, (Object)owner.m_19879_());
    }

    public void setOrigin(@Nullable BlockPos origin) {
        this.origin = origin == null ? null : new Vec3((double)origin.m_123341_() + 0.5, (double)origin.m_123342_() + 0.5, (double)origin.m_123343_() + 0.5);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR, (Object)10494192);
        this.f_19804_.m_135372_(DURATION, (Object)120);
        this.f_19804_.m_135372_(OWNER, (Object)0);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        CompoundTag tag = compoundTag.m_128469_("scriptor:projectile_data");
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128451_("com/ssblur/scriptor/color"));
        this.f_19804_.m_135381_(DURATION, (Object)tag.m_128451_("duration"));
        this.f_19804_.m_135381_(OWNER, (Object)tag.m_128451_("owner"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        CompoundTag tag = compoundTag.m_128469_("scriptor:projectile_data");
        tag.m_128405_("com/ssblur/scriptor/color", ((Integer)this.f_19804_.m_135370_(COLOR)).intValue());
        tag.m_128405_("duration", ((Integer)this.f_19804_.m_135370_(DURATION)).intValue());
        tag.m_128405_("owner", ((Integer)this.f_19804_.m_135370_(OWNER)).intValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, ((Integer)this.f_19804_.m_135370_(OWNER)).intValue());
    }

    public void m_8119_() {
        LivingEntity entity;
        Entity entity2;
        EntityHitResult entityHitResult;
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return;
        }
        this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        if (this.origin != null && this.m_20182_().m_82554_(this.origin) <= 1.0) {
            return;
        }
        int duration = (Integer)this.f_19804_.m_135370_(DURATION);
        Entity owner = level.m_6815_(((Integer)this.f_19804_.m_135370_(OWNER)).intValue());
        if (this.f_19797_ > duration || this.completable == null || this.completable.isDone()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        Vec3 dest = this.m_20182_().m_82549_(this.m_20184_());
        BlockHitResult blockHitResult = level.m_45547_(new ClipContext(this.m_20182_(), dest, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
            dest = blockHitResult.m_82450_();
        }
        if ((entityHitResult = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)this.m_20182_(), (Vec3)dest, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), e -> true)) != null && (entity2 = entityHitResult.m_82443_()) instanceof LivingEntity && (entity = (LivingEntity)entity2) != owner) {
            this.completable.complete(List.of(new EntityTargetable((Entity)entity)));
        } else if (!(blockHitResult.m_6662_() == HitResult.Type.MISS || this.origin != null && blockHitResult.m_6662_() == HitResult.Type.BLOCK && this.origin.m_82557_(dest) < 0.55)) {
            this.completable.complete(List.of(new Targetable(this.m_9236_(), blockHitResult.m_82425_().m_121955_(blockHitResult.m_82434_().m_122436_())).setFacing(blockHitResult.m_82434_())));
        }
    }
}

