/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events;

import com.ssblur.scriptor.damage.ScriptorDamage;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.effect.ScriptorEffects;
import com.ssblur.scriptor.gamerules.ChatRules;
import com.ssblur.scriptor.gamerules.ScriptorGameRules;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.word.Spell;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpellChatEvents
implements ChatEvent.Received {
    public EventResult received(@Nullable ServerPlayer player, Component component) {
        String sentence = component.getString();
        if (player != null) {
            ServerLevel server;
            Spell spell;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel && (spell = DictionarySavedData.computeIfAbsent(server = (ServerLevel)level).parse(sentence)) != null) {
                if (player.m_21023_((MobEffect)ScriptorEffects.HOARSE.get())) {
                    player.m_213846_((Component)Component.m_237115_((String)"extra.scriptor.hoarse"));
                    return EventResult.interruptFalse();
                }
                if (player.m_21023_((MobEffect)ScriptorEffects.MUTE.get())) {
                    player.m_213846_((Component)Component.m_237115_((String)"extra.scriptor.mute"));
                    return EventResult.interruptFalse();
                }
                int cost = (int)Math.round(spell.cost() * 30.0);
                if (level.m_46469_().m_46215_(ScriptorGameRules.VOCAL_MAX_COST) >= 0 && cost > level.m_46469_().m_46215_(ScriptorGameRules.VOCAL_MAX_COST)) {
                    player.m_213846_((Component)Component.m_237115_((String)"extra.scriptor.mute"));
                }
                int adjustedCost = (int)Math.round((double)cost * ((double)level.m_46469_().m_46215_(ScriptorGameRules.VOCAL_COOLDOWN_MULTIPLIER) / 100.0));
                if (!player.m_7500_()) {
                    player.m_7292_(new MobEffectInstance((MobEffect)ScriptorEffects.HOARSE.get(), adjustedCost));
                    if (adjustedCost > level.m_46469_().m_46215_(ScriptorGameRules.VOCAL_HUNGER_THRESHOLD)) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 2 * (adjustedCost - level.m_46469_().m_46215_(ScriptorGameRules.VOCAL_HUNGER_THRESHOLD))));
                    }
                    if (adjustedCost > level.m_46469_().m_46215_(ScriptorGameRules.VOCAL_DAMAGE_THRESHOLD)) {
                        player.m_6469_(Objects.requireNonNull(ScriptorDamage.overload((Entity)player)), ((float)adjustedCost - (float)level.m_46469_().m_46215_(ScriptorGameRules.VOCAL_DAMAGE_THRESHOLD) * 0.75f) / 100.0f);
                    }
                }
                if (player.m_21223_() > 0.0f) {
                    spell.cast(new EntityTargetable((Entity)player));
                }
                if (!server.m_46469_().m_46207_(ChatRules.SHOW_SPELLS_IN_CHAT)) {
                    return EventResult.interruptFalse();
                }
            }
            if (level instanceof ServerLevel && (server = (ServerLevel)level).m_46469_().m_46207_(ChatRules.PROXIMITY_CHAT)) {
                int distance = server.m_46469_().m_46215_(ChatRules.PROXIMITY_RANGE);
                Component name = player.m_5446_();
                MutableComponent message = name == null ? Component.m_237113_((String)"> ").m_7220_(component) : Component.m_237113_((String)"<").m_7220_(name).m_7220_((Component)Component.m_237113_((String)"> ")).m_7220_(component);
                List players = server.m_8795_(recipient -> recipient.m_20270_((Entity)player) <= (float)distance);
                for (ServerPlayer recipient2 : players) {
                    recipient2.m_213846_((Component)message);
                }
                if (players.size() <= 1) {
                    player.m_213846_((Component)Component.m_237115_((String)"command.scriptor.unheard").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                }
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }
}

