/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.ChalkBlockEntity;
import com.ssblur.scriptor.blockentity.EngravingBlockEntity;
import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.item.Chalk;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ChalkNetwork {
    public static void sendChalkMessage(boolean permanent) {
        Minecraft client = Minecraft.m_91087_();
        HitResult hit = client.f_91077_;
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hit;
            FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
            out.m_130062_(blockHitResult);
            out.writeBoolean(permanent);
            NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_RECEIVE_CHALK_MESSAGE, (FriendlyByteBuf)out);
        }
    }

    public static void sendChalkMessage() {
        ChalkNetwork.sendChalkMessage(false);
    }

    public static void receiveChalkMessage(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!(itemStack.m_41720_() instanceof Chalk)) {
            itemStack = player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (!(itemStack.m_41720_() instanceof Chalk)) {
            return;
        }
        String text = itemStack.m_41786_().getString();
        BlockHitResult blockHitResult = buf.m_130283_();
        BlockPos pos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
        boolean permanent = buf.readBoolean();
        if (player.m_9236_().m_8055_(pos).m_247087_()) {
            Level level = player.m_9236_();
            if (permanent) {
                level.m_7731_(pos, ((Block)ScriptorBlocks.ENGRAVING.get()).m_49966_(), 11);
            } else {
                level.m_7731_(pos, ((Block)ScriptorBlocks.CHALK.get()).m_49966_(), 11);
            }
            ChalkBlockEntity blockEntity = permanent ? new EngravingBlockEntity(pos, level.m_8055_(pos)) : new ChalkBlockEntity(pos, level.m_8055_(pos));
            blockEntity.setWord(text);
            blockEntity.setFacing(player.m_6350_());
            level.m_151523_((BlockEntity)blockEntity);
            BlockState blockState = level.m_8055_(pos);
            level.m_7260_(pos, blockState, blockState, 11);
        }
    }
}

