/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.subject.InventorySubject;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EnchantNetwork {
    public static void useBook(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        Level level = player.m_9236_();
        int slot = buf.readInt();
        ItemStack item = (ItemStack)player.f_36096_.m_38927_().get(slot);
        ItemStack carried = player.f_36096_.m_142621_();
        if (carried == null || carried.m_41619_()) {
            return;
        }
        CompoundTag tag = carried.m_41783_();
        if (tag != null && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ListTag text = tag.m_128437_("pages", 8);
            Spell spell = DictionarySavedData.computeIfAbsent(server).parse(LimitedBookSerializer.decodeText(text));
            if (spell == null) {
                return;
            }
            Subject subject = spell.subject();
            if (subject instanceof InventorySubject) {
                InventorySubject subject2 = (InventorySubject)((Object)subject);
                subject2.castOnItem(spell, player, item);
                player.m_36335_().m_41524_(carried.m_41720_(), (int)Math.round(spell.cost() * 7.0));
            }
        }
    }

    public static void clientUseBook(int slot) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.writeInt(slot);
        NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_CURSOR_USE_BOOK, (FriendlyByteBuf)out);
    }

    public static void useBookCreative(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ItemStack item = ItemStack.m_41712_((CompoundTag)Objects.requireNonNull(buf.m_130260_()));
        int slot = buf.readInt();
        CompoundTag compound = item.m_41783_();
        if (compound == null) {
            return;
        }
        ListTag text = compound.m_128437_("pages", 8);
        List<String> spell = DictionarySavedData.computeIfAbsent((ServerLevel)context.getPlayer().m_9236_()).parseComponents(LimitedBookSerializer.decodeText(text));
        CompoundTag tagOut = new CompoundTag();
        ListTag list = new ListTag();
        spell.forEach(i -> list.add((Object)StringTag.m_129297_((String)i)));
        tagOut.m_128365_("components", (Tag)list);
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130079_(tagOut);
        out.writeInt(slot);
        NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)context.getPlayer()), (ResourceLocation)ScriptorNetwork.CLIENT_CURSOR_RETURN_BOOK_CREATIVE, (FriendlyByteBuf)out);
    }

    public static void returnBookCreative(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        CompoundTag tag = buf.m_130260_();
        if (tag == null) {
            return;
        }
        int slot = buf.readInt();
        ListTag list = tag.m_128437_("components", 8);
        List<String> components = list.stream().map(Object::toString).toList();
        Action action = null;
        Subject subject = null;
        ArrayList<Descriptor> descriptor = new ArrayList<Descriptor>();
        for (String i : components) {
            String[] split = i.replace("\"", "").split(":", 2);
            switch (split[0]) {
                case "action": {
                    action = (Action)WordRegistry.INSTANCE.actionRegistry.get((Object)split[1]);
                    break;
                }
                case "descriptor": {
                    descriptor.add((Descriptor)WordRegistry.INSTANCE.descriptorRegistry.get((Object)split[1]));
                    break;
                }
                case "subject": {
                    subject = (Subject)WordRegistry.INSTANCE.subjectRegistry.get((Object)split[1]);
                }
            }
        }
        Spell spell = new Spell(subject, new PartialSpell(action, descriptor.toArray(new Descriptor[0])));
        Player player = context.getPlayer();
        ItemStack item = (ItemStack)player.f_36096_.m_38927_().get(slot);
        ItemStack carried = player.f_36096_.m_142621_();
        Subject subject2 = spell.subject();
        if (subject2 instanceof InventorySubject) {
            InventorySubject inventorySubject = (InventorySubject)((Object)subject2);
            inventorySubject.castOnItem(spell, player, item);
            player.m_36335_().m_41524_(carried.m_41720_(), 5);
        }
    }

    public static void clientUseBookCreative(ItemStack itemStack, int slot) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag tag = new CompoundTag();
        itemStack.m_41739_(tag);
        out.m_130079_(tag);
        out.writeInt(slot);
        NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_CURSOR_USE_BOOK_CREATIVE, (FriendlyByteBuf)out);
    }
}

