/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class IdentifyNetwork {
    public static void useScroll(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        Level level = player.m_9236_();
        int slot = buf.readInt();
        ItemStack item = (ItemStack)player.f_36096_.m_38927_().get(slot);
        ItemStack carried = player.f_36096_.m_142621_();
        if (carried == null || carried.m_41619_()) {
            return;
        }
        CompoundTag tag = item.m_41783_();
        if (tag != null && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ListTag text = tag.m_128437_("pages", 8);
            List<String> tokens = DictionarySavedData.computeIfAbsent(server).parseComponents(LimitedBookSerializer.decodeText(text));
            if (tokens == null) {
                return;
            }
            CompoundTag scriptor = item.m_41698_("scriptor");
            if (scriptor.m_128441_("identified")) {
                return;
            }
            scriptor.m_128365_("identified", (Tag)new CompoundTag());
            CompoundTag identified = scriptor.m_128469_("identified");
            for (String token : tokens) {
                identified.m_128379_(token, true);
            }
            carried.m_41774_(1);
            player.m_36335_().m_41524_(carried.m_41720_(), 10);
        }
    }

    public static void clientUseScroll(int slot) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.writeInt(slot);
        NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_CURSOR_USE_SCROLL, (FriendlyByteBuf)out);
    }

    public static void receiveDataCreative(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int slot = buf.readInt();
        CompoundTag tag = buf.m_130260_();
        assert (Minecraft.m_91087_().f_91074_ != null);
        Minecraft.m_91087_().f_91074_.f_36096_.m_38853_(slot).m_7993_().m_41751_(tag);
    }

    public static void useScrollCreative(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Level level = context.getPlayer().m_9236_();
        int slot = buf.readInt();
        CompoundTag tag = buf.m_130260_();
        if (tag != null && level instanceof ServerLevel) {
            CompoundTag scriptor;
            ServerLevel server = (ServerLevel)level;
            ListTag text = tag.m_128437_("pages", 8);
            List<String> tokens = DictionarySavedData.computeIfAbsent(server).parseComponents(LimitedBookSerializer.decodeText(text));
            if (tokens == null) {
                return;
            }
            if (!tag.m_128441_("scriptor")) {
                tag.m_128365_("scriptor", (Tag)new CompoundTag());
            }
            if ((scriptor = tag.m_128469_("scriptor")).m_128441_("identified")) {
                return;
            }
            scriptor.m_128365_("identified", (Tag)new CompoundTag());
            CompoundTag identified = scriptor.m_128469_("identified");
            for (String token : tokens) {
                identified.m_128379_(token, true);
            }
            FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
            out.writeInt(slot);
            out.m_130079_(tag);
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)context.getPlayer()), (ResourceLocation)ScriptorNetwork.CLIENT_CURSOR_RETURN_SCROLL_CREATIVE, (FriendlyByteBuf)out);
        }
    }

    public static void clientUseScrollCreative(ItemStack book, int slot) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.writeInt(slot);
        out.m_130079_(book.m_41783_());
        NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_CURSOR_USE_SCROLL_CREATIVE, (FriendlyByteBuf)out);
    }
}

