/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.helpers.ParticleQueue;
import com.ssblur.scriptor.particle.MagicParticleData;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleNetwork {
    public static void fizzle(Level level, BlockPos pos) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130068_((Enum)TYPE.FIZZLE);
        out.m_130064_(pos);
        NetworkManager.sendToPlayers(level.m_6907_().stream().map(player -> (ServerPlayer)player).toList(), (ResourceLocation)ScriptorNetwork.CLIENT_PARTICLE, (FriendlyByteBuf)out);
    }

    public static void wither(Level level, BlockPos pos) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130068_((Enum)TYPE.WITHER);
        out.m_130064_(pos);
        NetworkManager.sendToPlayers(level.m_6907_().stream().map(player -> (ServerPlayer)player).toList(), (ResourceLocation)ScriptorNetwork.CLIENT_PARTICLE, (FriendlyByteBuf)out);
    }

    public static void magicTrail(Level level, int color, Vec3 from, Vec3 to) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130068_((Enum)TYPE.MAGIC);
        out.writeInt(color);
        out.m_269582_(new Vector3f((float)from.f_82479_, (float)from.f_82480_, (float)from.f_82481_));
        out.m_269582_(new Vector3f((float)to.f_82479_, (float)to.f_82480_, (float)to.f_82481_));
        NetworkManager.sendToPlayers(level.m_6907_().stream().map(player -> (ServerPlayer)player).toList(), (ResourceLocation)ScriptorNetwork.CLIENT_PARTICLE, (FriendlyByteBuf)out);
    }

    public static void getParticles(FriendlyByteBuf buf, NetworkManager.PacketContext ignoredContext) {
        Minecraft client = Minecraft.m_91087_();
        Random random = new Random();
        TYPE type = (TYPE)buf.m_130066_(TYPE.class);
        if (client.f_91073_ != null) {
            switch (type) {
                case FIZZLE: 
                case WITHER: {
                    BlockPos pos = buf.m_130135_();
                    for (int i = 0; i < 9; ++i) {
                        ParticleQueue.queue((ParticleOptions)new DustParticleOptions(type.color, 1.0f), (float)pos.m_123341_() - 0.25f + random.nextFloat(1.5f), (float)pos.m_123342_() + 0.5f + random.nextFloat(0.7f), (float)pos.m_123343_() - 0.25f + random.nextFloat(1.5f));
                    }
                    break;
                }
                case MAGIC: {
                    int c = buf.readInt();
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    Vector3f from = buf.m_269394_();
                    Vector3f to = buf.m_269394_();
                    for (float i = 1.0f; i < 10.0f; i += 1.0f) {
                        Vector3f pos = from.lerp((Vector3fc)to, i / 10.0f);
                        ParticleQueue.queue(MagicParticleData.magic(r, g, b), pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0);
                    }
                    break;
                }
            }
        }
    }

    static enum TYPE {
        FIZZLE(new Vector3f(0.2f, 0.2f, 0.2f)),
        WITHER(new Vector3f(0.1f, 0.1f, 0.1f)),
        MAGIC(new Vector3f(0.0f, 0.0f, 0.0f));

        public final Vector3f color;

        private TYPE(Vector3f vector3f) {
            this.color = vector3f;
        }
    }
}

