/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.item.BookOfBooks;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ScrollNetwork {
    public static void scrollBook(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int direction = buf.readBoolean() ? 1 : -1;
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        Player player = context.getPlayer();
        ItemStack item = player.m_21120_(hand);
        if (item.m_41720_() instanceof BookOfBooks) {
            CompoundTag tag = item.m_41737_("scriptor");
            if (tag == null) {
                return;
            }
            ListTag list = tag.m_128437_("items", 10);
            if (list == null || list.size() == 0) {
                return;
            }
            int slot = tag.m_128451_("active_slot");
            slot = slot + direction + list.size();
            tag.m_128405_("active_slot", slot %= list.size());
        }
    }

    public static void sendScroll(InteractionHand interactionHand, double amount) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.writeBoolean(amount > 0.0);
        out.writeBoolean(interactionHand == InteractionHand.MAIN_HAND);
        NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_SCROLL_NETWORK, (FriendlyByteBuf)out);
    }
}

