/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.network;

import com.ssblur.scriptor.events.network.ScriptorNetwork;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TraceNetwork {
    static HashMap<UUID, TraceQueue> queue = new HashMap();

    public static void requestTraceData(Player player, TraceCallback callback) {
        UUID uuid = UUID.randomUUID();
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130077_(uuid);
        queue.put(uuid, new TraceQueue(new WeakReference<Player>(player), callback));
        NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ScriptorNetwork.CLIENT_GET_TRACE_DATA, (FriendlyByteBuf)out);
    }

    public static void requestExtendedTraceData(Player player, TraceCallback callback) {
        UUID uuid = UUID.randomUUID();
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130077_(uuid);
        queue.put(uuid, new TraceQueue(new WeakReference<Player>(player), callback));
        NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ScriptorNetwork.CLIENT_GET_HITSCAN_DATA, (FriendlyByteBuf)out);
    }

    public static void validateAndRun(UUID uuid, Player player, Targetable targetable) {
        TraceQueue queueItem = queue.get(uuid);
        if (queueItem.player.get() == player) {
            queueItem.callback.run(targetable);
        }
    }

    public static void validateAndDrop(UUID uuid, Player player) {
        TraceQueue queueItem = queue.get(uuid);
        if (queueItem.player.get() == player) {
            queue.remove(uuid);
        }
    }

    public static void getExtendedTraceData(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130077_(buf.m_130259_());
        Player player = context.getPlayer();
        Level level = player.m_9236_();
        Vec3 position = player.m_146892_();
        Vec3 angle = player.m_20154_().m_82541_().m_82542_(20.0, 20.0, 20.0);
        Vec3 dest = angle.m_82549_(position);
        BlockHitResult blockHitResult = level.m_45547_(new ClipContext(position, dest, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)position, (Vec3)dest, (AABB)AABB.m_165882_((Vec3)position.m_82492_(0.1, 0.1, 0.1), (double)0.2, (double)0.2, (double)0.2).m_82369_(angle).m_82400_(1.0), e -> true);
        if (entityHitResult != null && entityHitResult.m_6662_() != HitResult.Type.MISS) {
            if (blockHitResult.m_6662_() != HitResult.Type.MISS && blockHitResult.m_82448_((Entity)player) < entityHitResult.m_82448_((Entity)player)) {
                out.m_130068_((Enum)TYPE.BLOCK);
                out.m_130062_(blockHitResult);
                NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (FriendlyByteBuf)out);
                return;
            }
            Entity entity = entityHitResult.m_82443_();
            out.m_130068_((Enum)TYPE.ENTITY);
            out.writeInt(entity.m_19879_());
            out.m_130077_(entity.m_20148_());
            NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (FriendlyByteBuf)out);
            return;
        }
        if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
            out.m_130068_((Enum)TYPE.BLOCK);
            out.m_130062_(blockHitResult);
            NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (FriendlyByteBuf)out);
            return;
        }
        out.m_130068_((Enum)TYPE.MISS);
        NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (FriendlyByteBuf)out);
    }

    public static void getTraceData(FriendlyByteBuf buf, NetworkManager.PacketContext ignoredContext) {
        Minecraft client = Minecraft.m_91087_();
        HitResult hit = client.f_91077_;
        FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
        out.m_130077_(buf.m_130259_());
        switch (Objects.requireNonNull(hit).m_6662_()) {
            case BLOCK: {
                BlockHitResult blockHit = (BlockHitResult)hit;
                out.m_130068_((Enum)TYPE.BLOCK);
                out.m_130062_(blockHit);
                break;
            }
            case ENTITY: {
                EntityHitResult entityHit = (EntityHitResult)hit;
                Entity entity = entityHit.m_82443_();
                out.m_130068_((Enum)TYPE.ENTITY);
                out.writeInt(entity.m_19879_());
                out.m_130077_(entity.m_20148_());
                break;
            }
            default: {
                out.m_130068_((Enum)TYPE.MISS);
            }
        }
        NetworkManager.sendToServer((ResourceLocation)ScriptorNetwork.SERVER_RETURN_TRACE_DATA, (FriendlyByteBuf)out);
    }

    public static void returnTraceData(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        UUID uuid = buf.m_130259_();
        Player player = context.getPlayer();
        TYPE type = (TYPE)buf.m_130066_(TYPE.class);
        switch (type) {
            case BLOCK: {
                BlockHitResult result = buf.m_130283_();
                BlockPos pos = result.m_82425_().m_121945_(result.m_82434_());
                Targetable targetable = new Targetable(player.m_9236_(), pos).setFacing(result.m_82434_());
                context.queue(() -> TraceNetwork.validateAndRun(uuid, player, targetable));
                break;
            }
            case ENTITY: {
                int entityId = buf.readInt();
                UUID entityUUID = buf.m_130259_();
                Level level = player.m_9236_();
                Entity entity = level.m_6815_(entityId);
                if (entity != null && entity.m_20148_().equals(entityUUID)) {
                    context.queue(() -> TraceNetwork.validateAndRun(uuid, player, new EntityTargetable(entity)));
                    break;
                }
                context.queue(() -> TraceNetwork.validateAndDrop(uuid, player));
                break;
            }
            default: {
                context.queue(() -> TraceNetwork.validateAndDrop(uuid, player));
            }
        }
    }

    record TraceQueue(WeakReference<Player> player, TraceCallback callback) {
    }

    public static interface TraceCallback {
        public void run(Targetable var1);
    }

    static enum TYPE {
        BLOCK,
        ENTITY,
        MISS;

    }
}

