/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.reloadlisteners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.events.reloadlisteners.ScriptorReloadListener;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.descriptor.color.CustomColorDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import oshi.util.tuples.Triplet;

public class CustomColorReloadListener
extends ScriptorReloadListener {
    public static final CustomColorReloadListener INSTANCE = new CustomColorReloadListener();
    public List<Triplet<Integer, String, int[]>> cache;

    public CustomColorReloadListener() {
        super("scriptor/colors");
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.cache = new ArrayList<Triplet<Integer, String, int[]>>();
        super.apply(object, resourceManager, profilerFiller);
    }

    @Override
    public void loadResource(ResourceLocation resourceLocation, JsonElement jsonElement) {
        assert (jsonElement.isJsonObject());
        JsonObject json = jsonElement.getAsJsonObject();
        assert (json.has("color"));
        String name = resourceLocation.m_214299_();
        ScriptorMod.LOGGER.info("Loaded custom color " + name);
        JsonElement jsonElement2 = json.get("color");
        if (jsonElement2 instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement2;
            int[] colors = array.asList().stream().map(element -> Integer.parseInt(element.getAsString(), 16)).mapToInt(i -> i).toArray();
            int index = CustomColors.registerWithEasing(name, colors);
            this.cache.add((Triplet<Integer, String, int[]>)new Triplet((Object)index, (Object)name, (Object)colors));
            WordRegistry.INSTANCE.register("color." + resourceLocation.m_214299_(), new CustomColorDescriptor(name));
        } else if (json.get("color").isJsonPrimitive()) {
            CustomColors.registerWithEasing(name, new int[]{Integer.parseInt(json.get("color").getAsString(), 16)});
            WordRegistry.INSTANCE.register("color." + resourceLocation.m_214299_(), new CustomColorDescriptor(name));
        }
    }
}

