/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.reloadlisteners;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.data.PlayerSpellsSavedData;
import com.ssblur.scriptor.events.reloadlisteners.ScriptorReloadListener;
import com.ssblur.scriptor.helpers.resource.ScrapResource;
import com.ssblur.scriptor.item.ScriptorItems;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ScrapReloadListener
extends ScriptorReloadListener {
    static Random RANDOM = new Random();
    static Type SCRAP_TYPE = new TypeToken<ScrapResource>(){}.getType();
    public static final ScrapReloadListener INSTANCE = new ScrapReloadListener();
    public HashMap<Integer, HashMap<ResourceLocation, String>> tiers = new HashMap();

    public ScrapReloadListener() {
        super("scriptor/scraps");
    }

    @Override
    public void loadResource(ResourceLocation resourceLocation, JsonElement jsonElement) {
        ScrapResource resource = (ScrapResource)GSON.fromJson(jsonElement, SCRAP_TYPE);
        if (!this.tiers.containsKey(resource.getTier())) {
            this.tiers.put(resource.getTier(), new HashMap());
        }
        if (!resource.isDisabled()) {
            for (String key : resource.getKeys()) {
                this.tiers.get(resource.getTier()).put(resourceLocation.m_266382_("." + key.replace(":", ".")), key);
            }
        }
    }

    public HashMap<ResourceLocation, String> getTier(int tier) {
        if (!this.tiers.containsKey(tier)) {
            this.tiers.put(tier, new HashMap());
        }
        return this.tiers.get(tier);
    }

    public String getRandomScrapWord(int tier, Player player) {
        PlayerSpellsSavedData data;
        Set<ResourceLocation> keys = this.getTier(tier).keySet();
        if (ScriptorMod.COMMUNITY_MODE) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int bracket = (int)serverLevel.m_7328_() % 5;
                bracket = Math.min(bracket, keys.size());
                HashSet<ResourceLocation> filteredKeys = new HashSet<ResourceLocation>();
                ResourceLocation[] array = keys.toArray(new ResourceLocation[0]);
                for (int i = 0; i < keys.size(); ++i) {
                    if (bracket != i % 5) continue;
                    filteredKeys.add(array[i]);
                }
                keys = filteredKeys;
            } else {
                return null;
            }
        }
        if ((data = PlayerSpellsSavedData.computeIfAbsent(player)) != null) {
            ResourceLocation resource;
            HashMap<String, Boolean> scraps = data.getScrapTier(tier);
            ResourceLocation[] keysArray = keys.toArray(new ResourceLocation[0]);
            while (scraps.containsKey((resource = keysArray[RANDOM.nextInt(keys.size())]).m_214299_()) && scraps.size() < keys.size()) {
            }
            scraps.put(resource.m_214299_(), true);
            data.m_77762_();
            return this.tiers.get(tier).get(resource);
        }
        return this.tiers.get(tier).get(keys.toArray(new ResourceLocation[0])[RANDOM.nextInt(keys.size())]);
    }

    public ItemStack getRandomScrap(int tier, Player player) {
        String key = this.getRandomScrapWord(tier, player);
        CompoundTag scriptor = new CompoundTag();
        scriptor.m_128359_("spell", key);
        scriptor.m_128359_("word", DictionarySavedData.computeIfAbsent((ServerLevel)player.m_9236_()).getWord(key));
        if (ScriptorMod.COMMUNITY_MODE) {
            scriptor.m_128379_("community", true);
        }
        ItemStack itemStack = new ItemStack((ItemLike)ScriptorItems.SCRAP.get());
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128365_("scriptor", (Tag)scriptor);
        return itemStack;
    }
}

