/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events.reloadlisteners;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.advancement.ScriptorAdvancements;
import com.ssblur.scriptor.data.PlayerSpellsSavedData;
import com.ssblur.scriptor.events.reloadlisteners.ScriptorReloadListener;
import com.ssblur.scriptor.helpers.resource.TomeResource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TomeReloadListener
extends ScriptorReloadListener {
    static Type TOME_TYPE = new TypeToken<TomeResource>(){}.getType();
    static Random RANDOM = new Random();
    public static final TomeReloadListener INSTANCE = new TomeReloadListener();
    HashMap<Integer, HashMap<ResourceLocation, TomeResource>> tomes;
    ArrayList<ResourceLocation> keys;

    TomeReloadListener() {
        super("scriptor/tomes");
    }

    public HashMap<Integer, HashMap<ResourceLocation, TomeResource>> getTiers() {
        return this.tomes;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.tomes = new HashMap();
        this.keys = new ArrayList();
        super.apply(object, resourceManager, profilerFiller);
    }

    @Override
    public void loadResource(ResourceLocation resourceLocation, JsonElement jsonElement) {
        TomeResource resource = (TomeResource)GSON.fromJson(jsonElement, TOME_TYPE);
        if (!this.tomes.containsKey(resource.getTier())) {
            this.tomes.put(resource.getTier(), new HashMap());
        }
        this.keys.add(resourceLocation);
        this.tomes.get(resource.getTier()).put(resourceLocation, resource);
    }

    public TomeResource getRandomTome(int tier) {
        Set<ResourceLocation> keys = this.tomes.get(tier).keySet();
        return this.tomes.get(tier).get(keys.toArray(new ResourceLocation[0])[RANDOM.nextInt(keys.size())]);
    }

    public TomeResource getRandomTome(int tier, Player player) {
        PlayerSpellsSavedData data;
        Set<ResourceLocation> keys = this.tomes.get(tier).keySet();
        if (ScriptorMod.COMMUNITY_MODE) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int bracket = (int)serverLevel.m_7328_() % 5;
                bracket += 10;
                bracket %= 5;
                bracket = Math.min(bracket, keys.size() - 1);
                HashSet<ResourceLocation> filteredKeys = new HashSet<ResourceLocation>();
                ResourceLocation[] array = keys.toArray(new ResourceLocation[0]);
                for (int i = 0; i < keys.size(); ++i) {
                    if (bracket != i % 5) continue;
                    filteredKeys.add(array[i]);
                }
                keys = filteredKeys;
            } else {
                return null;
            }
        }
        if ((data = PlayerSpellsSavedData.computeIfAbsent(player)) != null) {
            ResourceLocation resource;
            HashMap<String, Boolean> spells = data.getTier(tier);
            if (keys.size() <= spells.size()) {
                switch (tier) {
                    case 1: {
                        ScriptorAdvancements.TOME_1.trigger((ServerPlayer)player);
                        break;
                    }
                    case 2: {
                        ScriptorAdvancements.TOME_2.trigger((ServerPlayer)player);
                        break;
                    }
                    case 3: {
                        ScriptorAdvancements.TOME_3.trigger((ServerPlayer)player);
                        break;
                    }
                    case 4: {
                        ScriptorAdvancements.TOME_4.trigger((ServerPlayer)player);
                    }
                }
                return this.tomes.get(tier).get(keys.toArray(new ResourceLocation[0])[RANDOM.nextInt(keys.size())]);
            }
            ResourceLocation[] keysArray = keys.toArray(new ResourceLocation[0]);
            int maxAttempts = 10;
            do {
                resource = keysArray[RANDOM.nextInt(keys.size())];
            } while (--maxAttempts > 0 && spells.containsKey(resource.m_214299_()));
            spells.put(resource.m_214299_(), true);
            data.m_77762_();
            return this.tomes.get(tier).get(resource);
        }
        return this.tomes.get(tier).get(keys.toArray(new ResourceLocation[0])[RANDOM.nextInt(keys.size())]);
    }
}

