/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.ssblur.scriptor.ScriptorMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class ComponentHelper {
    static final int DEFAULT_WIDTH = 38;

    public static void updateTooltipWith(int size, List<Component> list, String key, Object ... substitutions) {
        ComponentHelper.updateTooltipWith(size, Style.f_131099_, list, key, substitutions);
    }

    public static void updateTooltipWith(List<Component> list, String key, Object ... substitutions) {
        ComponentHelper.updateTooltipWith(38, list, key, substitutions);
    }

    public static void updateTooltipWith(ChatFormatting style, List<Component> list, String key, Object ... substitutions) {
        ComponentHelper.updateTooltipWith(38, style, list, key, substitutions);
    }

    public static void updateTooltipWith(Style style, List<Component> list, String key, Object ... substitutions) {
        ComponentHelper.updateTooltipWith(38, style, list, key, substitutions);
    }

    public static void updateTooltipWith(int size, Style style, List<Component> list, String key, Object ... substitutions) {
        list.addAll(ComponentHelper.orderedTranslatableComponents(size, key, substitutions).stream().map(component -> component.m_130948_(style)).toList());
    }

    public static void updateTooltipWith(int size, ChatFormatting style, List<Component> list, String key, Object ... substitutions) {
        list.addAll(ComponentHelper.orderedTranslatableComponents(size, key, substitutions).stream().map(component -> component.m_130940_(style)).toList());
    }

    public static List<MutableComponent> orderedTranslatableComponents(int size, String key, Object ... substitutions) {
        String text = I18n.m_118938_((String)key, (Object[])substitutions);
        String[] tokens = text.split("\\s+");
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String token : tokens) {
            if (token.length() >= size) {
                list.add(line.toString());
                list.add(token);
                line = new StringBuilder();
                continue;
            }
            if (token.length() + line.length() >= size) {
                list.add(line.toString());
                line = new StringBuilder();
                line.append(token);
                line.append(" ");
                continue;
            }
            line.append(token);
            line.append(" ");
        }
        list.add(line.toString());
        return list.stream().map(Component::m_237113_).toList();
    }

    public static void addCommunityDisclaimer(List<Component> list, ItemStack itemStack) {
        CompoundTag scriptor = itemStack.m_41737_("scriptor");
        if (scriptor != null && scriptor.m_128471_("community") && !ScriptorMod.COMMUNITY_MODE) {
            list.add((Component)Component.m_237115_((String)"lore.scriptor.not_community_2").m_130940_(ChatFormatting.RED));
            list.add((Component)Component.m_237115_((String)"lore.scriptor.not_community_3").m_130940_(ChatFormatting.RED));
        } else if ((scriptor == null || !scriptor.m_128471_("community")) && ScriptorMod.COMMUNITY_MODE) {
            list.add((Component)Component.m_237115_((String)"lore.scriptor.not_community_1").m_130940_(ChatFormatting.RED));
            list.add((Component)Component.m_237115_((String)"lore.scriptor.not_community_3").m_130940_(ChatFormatting.RED));
        }
    }
}

