/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.ItemTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemTargetableHelper {
    public static ItemStack getTargetItemStack(Targetable targetable, boolean aggressive) {
        InventoryTargetable inventoryTargetable;
        ItemTargetable itemTargetable;
        if (targetable instanceof ItemTargetable && ((itemTargetable = (ItemTargetable)targetable).shouldTargetItem() || aggressive)) {
            return itemTargetable.getTargetItem();
        }
        if (targetable instanceof InventoryTargetable && (inventoryTargetable = (InventoryTargetable)((Object)targetable)).getContainer() != null) {
            int slot = inventoryTargetable.shouldIgnoreTargetedSlot() ? inventoryTargetable.getFirstFilledSlot() : inventoryTargetable.getTargetedSlot();
            return inventoryTargetable.getContainer().m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getTargetItemStack(Targetable targetable, boolean aggressive, Predicate<ItemStack> condition) {
        int slot;
        InventoryTargetable inventoryTargetable;
        ItemTargetable itemTargetable;
        if (targetable instanceof ItemTargetable && ((itemTargetable = (ItemTargetable)targetable).shouldTargetItem() || aggressive)) {
            if (condition.test(itemTargetable.getTargetItem())) {
                return itemTargetable.getTargetItem();
            }
        } else if (targetable instanceof InventoryTargetable && (inventoryTargetable = (InventoryTargetable)((Object)targetable)).getContainer() != null && (slot = inventoryTargetable.shouldIgnoreTargetedSlot() ? inventoryTargetable.getFirstMatchingSlot(condition) : inventoryTargetable.getTargetedSlot()) >= 0 && condition.test(inventoryTargetable.getContainer().m_8020_(slot))) {
            return inventoryTargetable.getContainer().m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getTargetItemStack(Targetable targetable) {
        return ItemTargetableHelper.getTargetItemStack(targetable, false);
    }

    public static ItemStack getTargetItemStackAggressively(Targetable targetable) {
        return ItemTargetableHelper.getTargetItemStack(targetable, true);
    }

    public static void depositItemStack(Targetable targetable, ItemStack itemStack) {
        Player player;
        ItemTargetable itemTargetable;
        Entity entity;
        InventoryTargetable inventoryTargetable;
        if (targetable instanceof InventoryTargetable && (inventoryTargetable = (InventoryTargetable)((Object)targetable)).getContainer() != null) {
            int slot = inventoryTargetable.getFirstMatchingSlotNotEmpty(itemStack);
            if (slot >= 0) {
                ItemStack item = inventoryTargetable.getContainer().m_8020_(slot);
                if (item.m_41613_() + itemStack.m_41613_() < item.m_41741_()) {
                    item.m_41769_(itemStack.m_41613_());
                    return;
                }
                int diff = item.m_41741_() - item.m_41613_();
                item.m_41769_(diff);
                itemStack.m_41774_(diff);
            }
            if ((slot = inventoryTargetable.getFirstMatchingSlot(ItemStack::m_41619_)) >= 0) {
                inventoryTargetable.getContainer().m_6836_(slot, itemStack.m_41777_());
                return;
            }
        }
        if (targetable instanceof ItemTargetable && (entity = (itemTargetable = (ItemTargetable)targetable).getTargetEntity()) instanceof Player && (player = (Player)entity).m_36356_(itemStack)) {
            return;
        }
        Vec3 pos = targetable.getTargetPos();
        ItemEntity entity2 = new ItemEntity(targetable.getLevel(), pos.m_7096_(), pos.m_7098_() + 1.0, pos.m_7094_(), itemStack);
        targetable.getLevel().m_7967_((Entity)entity2);
    }
}

