/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.item.ScriptorItems;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class LimitedBookSerializer {
    static Type PAGE_TYPE = new TypeToken<Page>(){}.getType();

    public static String decodeText(ListTag text) {
        Gson gson = new Gson();
        StringBuilder builder = new StringBuilder();
        for (Tag tag : text) {
            try {
                Page page = (Page)gson.fromJson(tag.m_7916_(), PAGE_TYPE);
                builder.append(page.text.strip());
                builder.append(" ");
            }
            catch (Exception page) {
                try {
                    String string = (String)gson.fromJson(tag.m_7916_(), String.class);
                    builder.append(string.strip());
                    builder.append(" ");
                }
                catch (Exception e) {
                    builder.append(tag.toString());
                    builder.append(" ");
                }
            }
        }
        return builder.toString().stripTrailing();
    }

    public static String decodeText(String text) {
        Gson gson = new Gson();
        try {
            Page page = (Page)gson.fromJson(text, PAGE_TYPE);
            return page.text.strip();
        }
        catch (Exception page) {
            try {
                String string = (String)gson.fromJson(text, String.class);
                return string.strip();
            }
            catch (Exception e) {
                return "Error parsing text: \"" + text + "\".";
            }
        }
    }

    public static ListTag encodeText(String text) {
        Gson gson = new Gson();
        ArrayList<Page> list = new ArrayList<Page>();
        String[] tokens = text.split("\\s+");
        int pageLength = 0;
        StringBuilder page = new StringBuilder();
        for (String token : tokens) {
            if (token.length() >= 96) {
                pageLength = 0;
                list.add(new Page(page.toString()));
                list.add(new Page(token));
                page = new StringBuilder();
                continue;
            }
            if (token.length() + page.length() >= 96) {
                pageLength = token.length();
                list.add(new Page(page.toString()));
                page = new StringBuilder();
                page.append(token);
                page.append(" ");
                continue;
            }
            pageLength += token.length();
            page.append(token);
            page.append(" ");
        }
        if (!page.isEmpty()) {
            list.add(new Page(page.toString()));
        }
        ListTag tag = new ListTag();
        for (Page p : list) {
            tag.add((Object)StringTag.m_129297_((String)gson.toJson((Object)p)));
        }
        return tag;
    }

    public static ItemStack createSpellbook(String author, String title, String text, @Nullable String item) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("author", author);
        tag.m_128359_("title", title);
        tag.m_128365_("pages", (Tag)LimitedBookSerializer.encodeText(text));
        if (ScriptorMod.COMMUNITY_MODE) {
            CompoundTag scriptor = new CompoundTag();
            scriptor.m_128379_("community", true);
            tag.m_128365_("scriptor", (Tag)scriptor);
        }
        ItemStack itemStack = item != null ? new ItemStack((ItemLike)Objects.requireNonNull((Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(item)))) : new ItemStack((ItemLike)ScriptorItems.SPELLBOOK.get());
        itemStack.m_41764_(1);
        itemStack.m_41751_(tag);
        return itemStack;
    }

    static class Page {
        String text;

        public Page(String text) {
            this.text = text;
        }
    }
}

