/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.ssblur.scriptor.advancement.ScriptorAdvancements;
import com.ssblur.scriptor.data.DictionarySavedData;
import com.ssblur.scriptor.gamerules.ScriptorGameRules;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.helpers.targetable.SpellbookTargetable;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SpellbookHelper {
    public static List<Item> SPELLBOOKS = new ArrayList<Item>();

    public static boolean castFromItem(ItemStack itemStack, Player player) {
        CompoundTag compound = itemStack.m_41783_();
        Level level = player.m_9236_();
        if (compound == null || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 0.4f, level.m_213780_().m_188501_() * 1.2f + 0.6f);
        ListTag text = compound.m_128437_("pages", 8);
        Spell spell = DictionarySavedData.computeIfAbsent(server).parse(LimitedBookSerializer.decodeText(text));
        if (spell != null) {
            if (spell.cost() > (double)level.m_46469_().m_46215_(ScriptorGameRules.TOME_MAX_COST)) {
                player.m_213846_((Component)Component.m_237115_((String)"extra.scriptor.fizzle"));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ScriptorAdvancements.FIZZLE.trigger(serverPlayer);
                }
                if (!player.m_7500_()) {
                    SpellbookHelper.addCooldown(player, (int)Math.round(350.0 * ((double)level.m_46469_().m_46215_(ScriptorGameRules.TOME_COOLDOWN_MULTIPLIER) / 100.0)));
                }
                return true;
            }
            spell.cast(new SpellbookTargetable(itemStack, player, player.m_150109_().f_35977_).withTargetItem(false));
            if (!player.m_7500_()) {
                double adjustedCost = spell.cost() * ((double)level.m_46469_().m_46215_(ScriptorGameRules.TOME_COOLDOWN_MULTIPLIER) / 100.0);
                SpellbookHelper.addCooldown(player, (int)Math.round(adjustedCost * 7.0));
            }
            return false;
        }
        return true;
    }

    static void addCooldown(Player player, int time) {
        for (Item spellbook : SPELLBOOKS) {
            player.m_36335_().m_41524_(spellbook, time);
        }
    }
}

